/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.rtf;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.Locale;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.io.FilenameUtils;
import org.apache.poi.poifs.filesystem.DirectoryEntry;
import org.apache.poi.poifs.filesystem.DirectoryNode;
import org.apache.poi.poifs.filesystem.DocumentEntry;
import org.apache.poi.poifs.filesystem.DocumentInputStream;
import org.apache.poi.poifs.filesystem.Entry;
import org.apache.poi.poifs.filesystem.NPOIFSFileSystem;
import org.apache.poi.poifs.filesystem.Ole10Native;
import org.apache.poi.poifs.filesystem.Ole10NativeException;
import org.apache.poi.util.IOUtils;
import org.apache.tika.io.TikaInputStream;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.metadata.RTFMetadata;
import org.apache.tika.parser.microsoft.OfficeParser;
import org.apache.tika.parser.rtf.RTFParser;

class RTFObjDataParser {
    private static final int[] INT_LE_POWS = new int[]{1, 256, 65536, 0x1000000};
    private static final String WIN_ASCII = "WINDOWS-1252";

    RTFObjDataParser() {
    }

    protected byte[] parse(byte[] bytes, Metadata metadata, AtomicInteger unknownFilenameCount) throws IOException {
        ByteArrayInputStream is = new ByteArrayInputStream(bytes);
        long version = this.readUInt(is);
        metadata.add(RTFMetadata.EMB_APP_VERSION, Long.toString(version));
        long formatId = this.readUInt(is);
        if (formatId != 2L) {
            return null;
        }
        String className = this.readLengthPrefixedAnsiString(is).trim();
        String topicName = this.readLengthPrefixedAnsiString(is).trim();
        String itemName = this.readLengthPrefixedAnsiString(is).trim();
        if (className != null && className.length() > 0) {
            metadata.add(RTFMetadata.EMB_CLASS, className);
        }
        if (topicName != null && topicName.length() > 0) {
            metadata.add(RTFMetadata.EMB_TOPIC, topicName);
        }
        if (itemName != null && itemName.length() > 0) {
            metadata.add(RTFMetadata.EMB_ITEM, itemName);
        }
        long dataSz = this.readUInt(is);
        byte[] embObjBytes = this.readBytes(is, dataSz);
        if (className.toLowerCase(Locale.ROOT).equals("package")) {
            return this.handlePackage(embObjBytes, metadata);
        }
        if (className.toLowerCase(Locale.ROOT).equals("pbrush")) {
            return embObjBytes;
        }
        ByteArrayInputStream embIs = new ByteArrayInputStream(embObjBytes);
        if (NPOIFSFileSystem.hasPOIFSHeader((InputStream)embIs)) {
            try {
                return this.handleEmbeddedPOIFS(embIs, metadata, unknownFilenameCount);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return embObjBytes;
    }

    private byte[] handleEmbeddedPOIFS(InputStream is, Metadata metadata, AtomicInteger unknownFilenameCount) throws IOException {
        byte[] ret;
        block35: {
            ret = null;
            try (NPOIFSFileSystem fs = new NPOIFSFileSystem(is);){
                DirectoryNode root = fs.getRoot();
                if (root == null) {
                    byte[] byArray = ret;
                    return byArray;
                }
                if (root.hasEntry("Package")) {
                    Entry ooxml = root.getEntry("Package");
                    TikaInputStream stream = TikaInputStream.get((InputStream)new DocumentInputStream((DocumentEntry)ooxml));
                    ByteArrayOutputStream out = new ByteArrayOutputStream();
                    IOUtils.copy((InputStream)stream, (OutputStream)out);
                    ret = out.toByteArray();
                    break block35;
                }
                OfficeParser.POIFSDocumentType type = OfficeParser.POIFSDocumentType.detectType((DirectoryEntry)root);
                if (type == OfficeParser.POIFSDocumentType.OLE10_NATIVE) {
                    try {
                        Ole10Native ole = Ole10Native.createFromEmbeddedOleObject((DirectoryNode)root);
                        ret = ole.getDataBuffer();
                    }
                    catch (Ole10NativeException ole) {}
                    break block35;
                }
                if (type == OfficeParser.POIFSDocumentType.COMP_OBJ) {
                    DocumentEntry contentsEntry;
                    try {
                        contentsEntry = (DocumentEntry)root.getEntry("CONTENTS");
                    }
                    catch (FileNotFoundException ioe) {
                        contentsEntry = (DocumentEntry)root.getEntry("Contents");
                    }
                    try (DocumentInputStream inp = new DocumentInputStream(contentsEntry);){
                        ret = new byte[contentsEntry.getSize()];
                        inp.readFully(ret);
                        break block35;
                    }
                }
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                is.reset();
                IOUtils.copy((InputStream)is, (OutputStream)out);
                ret = out.toByteArray();
                metadata.set("resourceName", "file_" + unknownFilenameCount.getAndIncrement() + "." + type.getExtension());
                metadata.set("Content-Type", type.getType().toString());
            }
        }
        return ret;
    }

    private byte[] handlePackage(byte[] pkgBytes, Metadata metadata) throws IOException {
        ByteArrayInputStream is = new ByteArrayInputStream(pkgBytes);
        this.readUShort(is);
        String displayName = this.readAnsiString(is);
        this.readAnsiString(is);
        this.readUShort(is);
        int type = this.readUShort(is);
        if (type != 3) {
            return null;
        }
        this.readUInt(is);
        String ansiFilePath = this.readAnsiString(is);
        long bytesLen = this.readUInt(is);
        byte[] objBytes = this.initByteArray(bytesLen);
        is.read(objBytes);
        StringBuilder unicodeFilePath = new StringBuilder();
        try {
            long unicodeLen = this.readUInt(is);
            int i = 0;
            while ((long)i < unicodeLen) {
                int lo = is.read();
                int hi = is.read();
                int sum = lo + 256 * hi;
                if (hi == -1 || lo == -1) {
                    unicodeFilePath.setLength(0);
                    break;
                }
                unicodeFilePath.append((char)sum);
                ++i;
            }
        }
        catch (IOException e) {
            unicodeFilePath.setLength(0);
        }
        String fileNameToUse = "";
        String pathToUse = "";
        if (unicodeFilePath.length() > 0) {
            String p;
            fileNameToUse = p = unicodeFilePath.toString();
            pathToUse = p;
        } else {
            fileNameToUse = displayName == null ? "" : displayName;
            pathToUse = ansiFilePath == null ? "" : ansiFilePath;
        }
        metadata.set("resourceName", FilenameUtils.getName((String)fileNameToUse));
        metadata.set("embeddedRelationshipId", pathToUse);
        return objBytes;
    }

    private int readUShort(InputStream is) throws IOException {
        int lo = is.read();
        int hi = is.read() * 256;
        if (lo == -1 || hi == -1) {
            throw new IOException("Hit end of stream before reading little endian unsigned short.");
        }
        return hi + lo;
    }

    private long readUInt(InputStream is) throws IOException {
        long sum = 0L;
        for (int i = 0; i < 4; ++i) {
            int v = is.read();
            if (v == -1) {
                throw new IOException("Hit end of stream before finishing little endian unsigned int.");
            }
            sum += (long)v * (long)INT_LE_POWS[i];
        }
        return sum;
    }

    private String readAnsiString(InputStream is) throws IOException {
        StringBuilder sb = new StringBuilder();
        int c = is.read();
        while (c > 0) {
            sb.append((char)c);
            c = is.read();
        }
        if (c == -1) {
            throw new IOException("Hit end of stream before end of AnsiString");
        }
        return sb.toString();
    }

    private String readLengthPrefixedAnsiString(InputStream is) throws IOException {
        long len = this.readUInt(is);
        byte[] bytes = this.readBytes(is, len);
        try {
            return new String(bytes, WIN_ASCII);
        }
        catch (UnsupportedEncodingException e) {
            throw new IOException("Unsupported encoding");
        }
    }

    private byte[] readBytes(InputStream is, long len) throws IOException {
        byte[] bytes = this.initByteArray(len);
        int read = is.read(bytes);
        if ((long)read != len) {
            throw new IOException("Hit end of stream before reading all bytes");
        }
        return bytes;
    }

    private byte[] initByteArray(long len) throws IOException {
        if (len < 0L || len > (long)RTFParser.getMaxBytesForEmbeddedObject()) {
            throw new IOException("Requested length for reading bytes is out of bounds: " + len);
        }
        return new byte[(int)len];
    }
}

