/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.pdf;

import java.awt.image.BufferedImage;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.xml.stream.XMLStreamException;
import org.apache.commons.io.IOExceptionWithCause;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSInputStream;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSStream;
import org.apache.pdfbox.io.IOUtils;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDDocumentCatalog;
import org.apache.pdfbox.pdmodel.PDDocumentNameDictionary;
import org.apache.pdfbox.pdmodel.PDEmbeddedFilesNameTreeNode;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.PDResources;
import org.apache.pdfbox.pdmodel.common.PDNameTreeNode;
import org.apache.pdfbox.pdmodel.common.filespecification.PDComplexFileSpecification;
import org.apache.pdfbox.pdmodel.common.filespecification.PDEmbeddedFile;
import org.apache.pdfbox.pdmodel.graphics.PDXObject;
import org.apache.pdfbox.pdmodel.graphics.color.PDDeviceGray;
import org.apache.pdfbox.pdmodel.graphics.color.PDDeviceRGB;
import org.apache.pdfbox.pdmodel.graphics.form.PDFormXObject;
import org.apache.pdfbox.pdmodel.graphics.image.PDImageXObject;
import org.apache.pdfbox.pdmodel.interactive.action.PDAction;
import org.apache.pdfbox.pdmodel.interactive.action.PDActionURI;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAnnotation;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAnnotationFileAttachment;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAnnotationLink;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAnnotationMarkup;
import org.apache.pdfbox.pdmodel.interactive.digitalsignature.PDSignature;
import org.apache.pdfbox.pdmodel.interactive.documentnavigation.outline.PDDocumentOutline;
import org.apache.pdfbox.pdmodel.interactive.documentnavigation.outline.PDOutlineItem;
import org.apache.pdfbox.pdmodel.interactive.documentnavigation.outline.PDOutlineNode;
import org.apache.pdfbox.pdmodel.interactive.form.PDAcroForm;
import org.apache.pdfbox.pdmodel.interactive.form.PDField;
import org.apache.pdfbox.pdmodel.interactive.form.PDNonTerminalField;
import org.apache.pdfbox.pdmodel.interactive.form.PDSignatureField;
import org.apache.pdfbox.pdmodel.interactive.form.PDXFAResource;
import org.apache.pdfbox.text.PDFTextStripper;
import org.apache.pdfbox.text.TextPosition;
import org.apache.pdfbox.tools.imageio.ImageIOUtil;
import org.apache.tika.exception.TikaException;
import org.apache.tika.extractor.EmbeddedDocumentExtractor;
import org.apache.tika.extractor.ParsingEmbeddedDocumentExtractor;
import org.apache.tika.io.TikaInputStream;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.metadata.TikaCoreProperties;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.parser.pdf.PDFParserConfig;
import org.apache.tika.parser.pdf.XFAExtractor;
import org.apache.tika.sax.EmbeddedContentHandler;
import org.apache.tika.sax.XHTMLContentHandler;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

class PDF2XHTML
extends PDFTextStripper {
    private static final int MAX_ACROFORM_RECURSIONS = 10;
    private final SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZ", Locale.ROOT);
    private final ContentHandler originalHandler;
    private final ParseContext context;
    private final XHTMLContentHandler handler;
    private final PDFParserConfig config;
    private final Metadata metadata;
    private final List<IOException> exceptions = new ArrayList<IOException>();
    private Map<String, Integer> processedInlineImages = new HashMap<String, Integer>();
    private int inlineImageCounter = 0;

    private PDF2XHTML(ContentHandler handler, ParseContext context, Metadata metadata, PDFParserConfig config) throws IOException {
        this.config = config;
        this.originalHandler = handler;
        this.context = context;
        this.handler = new XHTMLContentHandler(handler, metadata);
        this.metadata = metadata;
    }

    public static void process(PDDocument document, ContentHandler handler, ParseContext context, Metadata metadata, PDFParserConfig config) throws SAXException, TikaException {
        PDF2XHTML pdf2XHTML = null;
        try {
            pdf2XHTML = new PDF2XHTML(handler, context, metadata, config);
            config.configure(pdf2XHTML);
            pdf2XHTML.writeText(document, new Writer(){

                @Override
                public void write(char[] cbuf, int off, int len) {
                }

                @Override
                public void flush() {
                }

                @Override
                public void close() {
                }
            });
        }
        catch (IOException e) {
            if (e.getCause() instanceof SAXException) {
                throw (SAXException)e.getCause();
            }
            throw new TikaException("Unable to extract PDF content", (Throwable)e);
        }
        if (pdf2XHTML.exceptions.size() > 0) {
            throw new TikaException("Unable to extract all PDF content", (Throwable)pdf2XHTML.exceptions.get(0));
        }
    }

    void extractBookmarkText() throws SAXException {
        PDDocumentOutline outline = this.document.getDocumentCatalog().getDocumentOutline();
        if (outline != null) {
            this.extractBookmarkText((PDOutlineNode)outline);
        }
    }

    void extractBookmarkText(PDOutlineNode bookmark) throws SAXException {
        PDOutlineItem current = bookmark.getFirstChild();
        if (current != null) {
            this.handler.startElement("ul");
            while (current != null) {
                this.handler.startElement("li");
                this.handler.characters(current.getTitle());
                this.handler.endElement("li");
                this.extractBookmarkText((PDOutlineNode)current);
                current = current.getNextSibling();
            }
            this.handler.endElement("ul");
        }
    }

    public void processPage(PDPage page) throws IOException {
        try {
            super.processPage(page);
        }
        catch (IOException e) {
            this.handleCatchableIOE(e);
        }
    }

    protected void startDocument(PDDocument pdf) throws IOException {
        try {
            this.handler.startDocument();
        }
        catch (SAXException e) {
            throw new IOExceptionWithCause("Unable to start a document", (Throwable)e);
        }
    }

    protected void endDocument(PDDocument pdf) throws IOException {
        try {
            this.extractBookmarkText();
            try {
                this.extractEmbeddedDocuments(pdf, this.originalHandler);
            }
            catch (IOException e) {
                this.handleCatchableIOE(e);
            }
            if (this.config.getExtractAcroFormContent()) {
                try {
                    this.extractAcroForm(pdf, this.handler);
                }
                catch (IOException e) {
                    this.handleCatchableIOE(e);
                }
            }
            this.handler.endDocument();
        }
        catch (TikaException e) {
            throw new IOExceptionWithCause("Unable to end a document", (Throwable)e);
        }
        catch (SAXException e) {
            throw new IOExceptionWithCause("Unable to end a document", (Throwable)e);
        }
    }

    protected void startPage(PDPage page) throws IOException {
        try {
            this.handler.startElement("div", "class", "page");
        }
        catch (SAXException e) {
            throw new IOExceptionWithCause("Unable to start a page", (Throwable)e);
        }
        this.writeParagraphStart();
    }

    protected void endPage(PDPage page) throws IOException {
        try {
            this.writeParagraphEnd();
            try {
                this.extractImages(page.getResources(), new HashSet<COSBase>());
            }
            catch (IOException e) {
                this.handleCatchableIOE(e);
            }
            EmbeddedDocumentExtractor extractor = this.getEmbeddedDocumentExtractor();
            for (PDAnnotation annotation : page.getAnnotations()) {
                PDActionURI uri;
                String link;
                PDAction action;
                PDAnnotationLink annotationlink;
                if (annotation instanceof PDAnnotationFileAttachment) {
                    PDAnnotationFileAttachment fann = (PDAnnotationFileAttachment)annotation;
                    PDComplexFileSpecification fileSpec = (PDComplexFileSpecification)fann.getFile();
                    try {
                        this.extractMultiOSPDEmbeddedFiles("", fileSpec, extractor);
                    }
                    catch (SAXException e) {
                        throw new IOExceptionWithCause("file embedded in annotation sax exception", (Throwable)e);
                    }
                    catch (TikaException e) {
                        throw new IOExceptionWithCause("file embedded in annotation tika exception", (Throwable)e);
                    }
                    catch (IOException e) {
                        this.handleCatchableIOE(e);
                    }
                }
                if (!this.config.getExtractAnnotationText()) continue;
                if (annotation instanceof PDAnnotationLink && (annotationlink = (PDAnnotationLink)annotation).getAction() != null && (action = annotationlink.getAction()) instanceof PDActionURI && (link = (uri = (PDActionURI)action).getURI()) != null) {
                    this.handler.startElement("div", "class", "annotation");
                    this.handler.startElement("a", "href", link);
                    this.handler.endElement("a");
                    this.handler.endElement("div");
                }
                if (!(annotation instanceof PDAnnotationMarkup)) continue;
                PDAnnotationMarkup annotationMarkup = (PDAnnotationMarkup)annotation;
                String title = annotationMarkup.getTitlePopup();
                String subject = annotationMarkup.getSubject();
                String contents = annotationMarkup.getContents();
                if (title == null && subject == null && contents == null) continue;
                this.handler.startElement("div", "class", "annotation");
                if (title != null) {
                    this.handler.startElement("div", "class", "annotationTitle");
                    this.handler.characters(title);
                    this.handler.endElement("div");
                }
                if (subject != null) {
                    this.handler.startElement("div", "class", "annotationSubject");
                    this.handler.characters(subject);
                    this.handler.endElement("div");
                }
                if (contents != null) {
                    this.handler.startElement("div", "class", "annotationContents");
                    this.handler.characters(contents);
                    this.handler.endElement("div");
                }
                this.handler.endElement("div");
            }
            this.handler.endElement("div");
        }
        catch (SAXException e) {
            throw new IOExceptionWithCause("Unable to end a page", (Throwable)e);
        }
        catch (IOException e) {
            this.exceptions.add(e);
        }
    }

    private void extractImages(PDResources resources, Set<COSBase> seenThisPage) throws SAXException, IOException {
        if (resources == null || !this.config.getExtractInlineImages()) {
            return;
        }
        for (COSName name : resources.getXObjectNames()) {
            COSStream cosObject;
            PDXObject object = resources.getXObject(name);
            if (object == null || seenThisPage.contains(cosObject = object.getCOSObject())) continue;
            seenThisPage.add((COSBase)cosObject);
            if (object instanceof PDFormXObject) {
                this.extractImages(((PDFormXObject)object).getResources(), seenThisPage);
                continue;
            }
            if (!(object instanceof PDImageXObject)) continue;
            PDImageXObject image = (PDImageXObject)object;
            Metadata metadata = new Metadata();
            String extension = image.getSuffix();
            if (extension == null) {
                metadata.set("Content-Type", "image/png");
                extension = "png";
            } else if (extension.equals("jpg")) {
                metadata.set("Content-Type", "image/jpeg");
            } else if (extension.equals("tiff")) {
                metadata.set("Content-Type", "image/tiff");
                extension = "tif";
            }
            Integer imageNumber = this.processedInlineImages.get(name.getName());
            if (imageNumber == null) {
                imageNumber = this.inlineImageCounter++;
            }
            String fileName = "image" + imageNumber + "." + extension;
            metadata.set("resourceName", fileName);
            AttributesImpl attr = new AttributesImpl();
            attr.addAttribute("", "src", "src", "CDATA", "embedded:" + fileName);
            attr.addAttribute("", "alt", "alt", "CDATA", fileName);
            this.handler.startElement("img", attr);
            this.handler.endElement("img");
            if (this.config.getExtractUniqueInlineImagesOnly()) {
                String cosObjectId = name.getName();
                if (this.processedInlineImages.containsKey(cosObjectId)) continue;
                this.processedInlineImages.put(cosObjectId, imageNumber);
            }
            metadata.set(TikaCoreProperties.EMBEDDED_RESOURCE_TYPE, TikaCoreProperties.EmbeddedResourceType.INLINE.toString());
            EmbeddedDocumentExtractor extractor = this.getEmbeddedDocumentExtractor();
            if (!extractor.shouldParseEmbedded(metadata)) continue;
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            try {
                this.writeToBuffer(image, extension, buffer);
                extractor.parseEmbedded((InputStream)new ByteArrayInputStream(buffer.toByteArray()), (ContentHandler)new EmbeddedContentHandler((ContentHandler)this.handler), metadata, false);
            }
            catch (IOException e) {
                this.handleCatchableIOE(e);
            }
        }
    }

    private void writeToBuffer(PDImageXObject pdImage, String suffix, OutputStream out) throws IOException {
        BufferedImage image = pdImage.getImage();
        if (image != null) {
            if ("jpg".equals(suffix)) {
                String colorSpaceName = pdImage.getColorSpace().getName();
                if (PDDeviceGray.INSTANCE.getName().equals(colorSpaceName) || PDDeviceRGB.INSTANCE.getName().equals(colorSpaceName)) {
                    COSInputStream data = pdImage.getStream().createInputStream();
                    IOUtils.copy((InputStream)data, (OutputStream)out);
                    IOUtils.closeQuietly((Closeable)data);
                } else {
                    ImageIOUtil.writeImage((BufferedImage)image, (String)suffix, (OutputStream)out);
                }
            } else {
                ImageIOUtil.writeImage((BufferedImage)image, (String)suffix, (OutputStream)out);
            }
        }
        out.flush();
    }

    protected EmbeddedDocumentExtractor getEmbeddedDocumentExtractor() {
        EmbeddedDocumentExtractor extractor = (EmbeddedDocumentExtractor)this.context.get(EmbeddedDocumentExtractor.class);
        if (extractor == null) {
            extractor = new ParsingEmbeddedDocumentExtractor(this.context);
        }
        return extractor;
    }

    protected void writeParagraphStart() throws IOException {
        super.writeParagraphStart();
        try {
            this.handler.startElement("p");
        }
        catch (SAXException e) {
            throw new IOExceptionWithCause("Unable to start a paragraph", (Throwable)e);
        }
    }

    protected void writeParagraphEnd() throws IOException {
        super.writeParagraphEnd();
        try {
            this.handler.endElement("p");
        }
        catch (SAXException e) {
            throw new IOExceptionWithCause("Unable to end a paragraph", (Throwable)e);
        }
    }

    protected void writeString(String text) throws IOException {
        try {
            this.handler.characters(text);
        }
        catch (SAXException e) {
            throw new IOExceptionWithCause("Unable to write a string: " + text, (Throwable)e);
        }
    }

    protected void writeCharacters(TextPosition text) throws IOException {
        try {
            this.handler.characters(text.getUnicode());
        }
        catch (SAXException e) {
            throw new IOExceptionWithCause("Unable to write a character: " + text.getUnicode(), (Throwable)e);
        }
    }

    protected void writeWordSeparator() throws IOException {
        try {
            this.handler.characters(this.getWordSeparator());
        }
        catch (SAXException e) {
            throw new IOExceptionWithCause("Unable to write a space character", (Throwable)e);
        }
    }

    protected void writeLineSeparator() throws IOException {
        try {
            this.handler.newline();
        }
        catch (SAXException e) {
            throw new IOExceptionWithCause("Unable to write a newline character", (Throwable)e);
        }
    }

    private void extractEmbeddedDocuments(PDDocument document, ContentHandler handler) throws IOException, SAXException, TikaException {
        PDDocumentNameDictionary namesDictionary = new PDDocumentNameDictionary(document.getDocumentCatalog());
        PDEmbeddedFilesNameTreeNode efTree = namesDictionary.getEmbeddedFiles();
        if (efTree == null) {
            return;
        }
        Map embeddedFileNames = efTree.getNames();
        if (embeddedFileNames != null) {
            this.processEmbeddedDocNames(embeddedFileNames);
        } else {
            List kids = efTree.getKids();
            if (kids == null) {
                return;
            }
            for (PDNameTreeNode node : kids) {
                embeddedFileNames = node.getNames();
                if (embeddedFileNames == null) continue;
                this.processEmbeddedDocNames(embeddedFileNames);
            }
        }
    }

    private void processEmbeddedDocNames(Map<String, PDComplexFileSpecification> embeddedFileNames) throws IOException, SAXException, TikaException {
        if (embeddedFileNames == null || embeddedFileNames.isEmpty()) {
            return;
        }
        EmbeddedDocumentExtractor extractor = this.getEmbeddedDocumentExtractor();
        for (Map.Entry<String, PDComplexFileSpecification> ent : embeddedFileNames.entrySet()) {
            PDComplexFileSpecification spec = ent.getValue();
            this.extractMultiOSPDEmbeddedFiles(ent.getKey(), spec, extractor);
        }
    }

    private void extractMultiOSPDEmbeddedFiles(String defaultName, PDComplexFileSpecification spec, EmbeddedDocumentExtractor extractor) throws IOException, SAXException, TikaException {
        if (spec == null) {
            return;
        }
        this.extractPDEmbeddedFile(defaultName, spec.getFile(), spec.getEmbeddedFile(), extractor);
        this.extractPDEmbeddedFile(defaultName, spec.getFileMac(), spec.getEmbeddedFileMac(), extractor);
        this.extractPDEmbeddedFile(defaultName, spec.getFileDos(), spec.getEmbeddedFileDos(), extractor);
        this.extractPDEmbeddedFile(defaultName, spec.getFileUnix(), spec.getEmbeddedFileUnix(), extractor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void extractPDEmbeddedFile(String defaultName, String fileName, PDEmbeddedFile file, EmbeddedDocumentExtractor extractor) throws SAXException, IOException, TikaException {
        if (file == null) {
            return;
        }
        fileName = fileName == null ? defaultName : fileName;
        Metadata metadata = new Metadata();
        metadata.set("resourceName", fileName);
        metadata.set("Content-Type", file.getSubtype());
        metadata.set("Content-Length", Long.toString(file.getSize()));
        metadata.set(TikaCoreProperties.EMBEDDED_RESOURCE_TYPE, TikaCoreProperties.EmbeddedResourceType.ATTACHMENT.toString());
        if (extractor.shouldParseEmbedded(metadata)) {
            TikaInputStream stream = null;
            try {
                stream = TikaInputStream.get((InputStream)file.createInputStream());
                extractor.parseEmbedded((InputStream)stream, (ContentHandler)new EmbeddedContentHandler((ContentHandler)this.handler), metadata, false);
                AttributesImpl attributes = new AttributesImpl();
                attributes.addAttribute("", "class", "class", "CDATA", "embedded");
                attributes.addAttribute("", "id", "id", "CDATA", fileName);
                this.handler.startElement("div", attributes);
                this.handler.endElement("div");
            }
            finally {
                org.apache.commons.io.IOUtils.closeQuietly((InputStream)stream);
            }
        }
    }

    private void extractAcroForm(PDDocument pdf, XHTMLContentHandler handler) throws IOException, SAXException {
        List fields;
        PDDocumentCatalog catalog = pdf.getDocumentCatalog();
        if (catalog == null) {
            return;
        }
        PDAcroForm form = catalog.getAcroForm();
        if (form == null) {
            return;
        }
        PDXFAResource pdxfa = form.getXFA();
        if (pdxfa != null) {
            XFAExtractor xfaExtractor = new XFAExtractor();
            try (BufferedInputStream is2 = new BufferedInputStream(new ByteArrayInputStream(pdxfa.getBytes()));){
                xfaExtractor.extract(is2, handler, this.metadata, this.context);
                return;
            }
            catch (IOException | XMLStreamException is2) {
                // empty catch block
            }
        }
        if ((fields = form.getFields()) == null) {
            return;
        }
        ListIterator itr = fields.listIterator();
        if (itr == null) {
            return;
        }
        handler.startElement("div", "class", "acroform");
        handler.startElement("ol");
        while (itr.hasNext()) {
            Object obj = itr.next();
            if (obj == null || !(obj instanceof PDField)) continue;
            this.processAcroField((PDField)obj, handler, 0);
        }
        handler.endElement("ol");
        handler.endElement("div");
    }

    private void processAcroField(PDField field, XHTMLContentHandler handler, int currentRecursiveDepth) throws SAXException, IOException {
        if (currentRecursiveDepth >= 10) {
            return;
        }
        this.addFieldString(field, handler);
        if (field instanceof PDNonTerminalField) {
            int r = currentRecursiveDepth + 1;
            handler.startElement("ol");
            for (PDField child : ((PDNonTerminalField)field).getChildren()) {
                this.processAcroField(child, handler, r);
            }
            handler.endElement("ol");
        }
    }

    private void addFieldString(PDField field, XHTMLContentHandler handler) throws SAXException {
        String partName = field.getPartialName();
        String altName = field.getAlternateFieldName();
        StringBuilder sb = new StringBuilder();
        AttributesImpl attrs = new AttributesImpl();
        if (partName != null) {
            sb.append(partName).append(": ");
        }
        if (altName != null) {
            attrs.addAttribute("", "altName", "altName", "CDATA", altName);
        }
        if (field instanceof PDSignatureField) {
            this.handleSignature(attrs, (PDSignatureField)field, handler);
            return;
        }
        String value = field.getValueAsString();
        if (value != null && !value.equals("null")) {
            sb.append(value);
        }
        if (attrs.getLength() > 0 || sb.length() > 0) {
            handler.startElement("li", attrs);
            handler.characters(sb.toString());
            handler.endElement("li");
        }
    }

    private void handleSignature(AttributesImpl parentAttributes, PDSignatureField sigField, XHTMLContentHandler handler) throws SAXException {
        PDSignature sig = sigField.getSignature();
        if (sig == null) {
            return;
        }
        TreeMap<String, String> vals = new TreeMap<String, String>();
        vals.put("name", sig.getName());
        vals.put("contactInfo", sig.getContactInfo());
        vals.put("location", sig.getLocation());
        vals.put("reason", sig.getReason());
        Calendar cal = sig.getSignDate();
        if (cal != null) {
            this.dateFormat.setTimeZone(cal.getTimeZone());
            vals.put("date", this.dateFormat.format(cal.getTime()));
        }
        int nonNull = 0;
        for (String val : vals.keySet()) {
            if (val == null || val.equals("")) continue;
            ++nonNull;
        }
        if (nonNull > 0) {
            handler.startElement("li", parentAttributes);
            AttributesImpl attrs = new AttributesImpl();
            attrs.addAttribute("", "type", "type", "CDATA", "signaturedata");
            handler.startElement("ol", attrs);
            for (Map.Entry e : vals.entrySet()) {
                if (e.getValue() == null || ((String)e.getValue()).equals("")) continue;
                attrs = new AttributesImpl();
                attrs.addAttribute("", "signdata", "signdata", "CDATA", (String)e.getKey());
                handler.startElement("li", attrs);
                handler.characters((String)e.getValue());
                handler.endElement("li");
            }
            handler.endElement("ol");
            handler.endElement("li");
        }
    }

    private void handleCatchableIOE(IOException e) throws IOException {
        String msg;
        if (this.config.isCatchIntermediateIOExceptions()) {
            msg = e.getMessage();
            if (msg == null) {
                msg = "IOException, no message";
            }
        } else {
            throw e;
        }
        this.metadata.add(TikaCoreProperties.TIKA_META_EXCEPTION_WARNING, msg);
        this.exceptions.add(e);
    }
}

