/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.strings;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.tika.exception.TikaException;
import org.apache.tika.io.TikaInputStream;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.mime.MediaType;
import org.apache.tika.parser.AbstractParser;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.parser.external.ExternalParser;
import org.apache.tika.parser.strings.FileConfig;
import org.apache.tika.parser.strings.StringsConfig;
import org.apache.tika.sax.XHTMLContentHandler;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class StringsParser
extends AbstractParser {
    private static final long serialVersionUID = 802566634661575025L;
    private static final Set<MediaType> SUPPORTED_TYPES = Collections.singleton(MediaType.OCTET_STREAM);
    private static final StringsConfig DEFAULT_STRINGS_CONFIG = new StringsConfig();
    private static final FileConfig DEFAULT_FILE_CONFIG = new FileConfig();
    private static Map<String, Boolean[]> STRINGS_PRESENT = new HashMap<String, Boolean[]>();

    public Set<MediaType> getSupportedTypes(ParseContext context) {
        return SUPPORTED_TYPES;
    }

    public void parse(InputStream stream, ContentHandler handler, Metadata metadata, ParseContext context) throws IOException, SAXException, TikaException {
        StringsConfig stringsConfig = (StringsConfig)context.get(StringsConfig.class, (Object)DEFAULT_STRINGS_CONFIG);
        FileConfig fileConfig = (FileConfig)context.get(FileConfig.class, (Object)DEFAULT_FILE_CONFIG);
        if (!this.hasStrings(stringsConfig)) {
            return;
        }
        TikaInputStream tis = TikaInputStream.get((InputStream)stream);
        File input = tis.getFile();
        metadata.set("strings:min-len", "" + stringsConfig.getMinLength());
        metadata.set("strings:encoding", stringsConfig.toString());
        metadata.set("strings:file_output", this.doFile(input, fileConfig));
        int totalBytes = 0;
        XHTMLContentHandler xhtml = new XHTMLContentHandler(handler, metadata);
        xhtml.startDocument();
        totalBytes = this.doStrings(input, stringsConfig, xhtml);
        xhtml.endDocument();
        metadata.set("strings:length", "" + totalBytes);
    }

    private boolean hasStrings(StringsConfig config) {
        String stringsProg = config.getStringsPath() + StringsParser.getStringsProg();
        if (STRINGS_PRESENT.containsKey(stringsProg)) {
            return STRINGS_PRESENT.get(stringsProg)[0];
        }
        String[] checkCmd = new String[]{stringsProg, "--version"};
        try {
            boolean hasStrings = ExternalParser.check((String[])checkCmd, (int[])new int[0]);
            boolean encodingOpt = false;
            if (!System.getProperty("os.name").startsWith("Windows")) {
                String[] checkOpt = new String[]{stringsProg, "-e", "" + config.getEncoding().get(), "/dev/null"};
                int[] errorValues = new int[]{1, 2};
                encodingOpt = ExternalParser.check((String[])checkOpt, (int[])errorValues);
            }
            Boolean[] values = new Boolean[]{hasStrings, encodingOpt};
            STRINGS_PRESENT.put(stringsProg, values);
            return hasStrings;
        }
        catch (NoClassDefFoundError ncdfe) {
            Boolean[] values = new Boolean[]{false, false};
            STRINGS_PRESENT.put(stringsProg, values);
            return false;
        }
    }

    private boolean hasFile(FileConfig config) {
        String fileProg = config.getFilePath() + StringsParser.getFileProg();
        String[] checkCmd = new String[]{fileProg, "--version"};
        boolean hasFile = ExternalParser.check((String[])checkCmd, (int[])new int[0]);
        return hasFile;
    }

    private int doStrings(File input, StringsConfig config, XHTMLContentHandler xhtml) throws IOException, TikaException, SAXException {
        String stringsProg = config.getStringsPath() + StringsParser.getStringsProg();
        ArrayList<String> cmdList = new ArrayList<String>(4);
        cmdList.add(stringsProg);
        cmdList.add("-n");
        cmdList.add("" + config.getMinLength());
        if (STRINGS_PRESENT.get(stringsProg)[1].booleanValue()) {
            cmdList.add("-e");
            cmdList.add("" + config.getEncoding().get());
        }
        cmdList.add(input.getPath());
        String[] cmd = cmdList.toArray(new String[cmdList.size()]);
        ProcessBuilder pb = new ProcessBuilder(cmd);
        final Process process = pb.start();
        InputStream out = process.getInputStream();
        FutureTask<Integer> waitTask = new FutureTask<Integer>(new Callable<Integer>(){

            @Override
            public Integer call() throws Exception {
                return process.waitFor();
            }
        });
        Thread waitThread = new Thread(waitTask);
        waitThread.start();
        int totalBytes = 0;
        totalBytes = this.extractOutput(out, xhtml);
        try {
            waitTask.get(config.getTimeout(), TimeUnit.SECONDS);
        }
        catch (InterruptedException ie) {
            waitThread.interrupt();
            process.destroy();
            Thread.currentThread().interrupt();
            throw new TikaException(StringsParser.class.getName() + " interrupted", (Throwable)ie);
        }
        catch (ExecutionException ee) {
        }
        catch (TimeoutException te) {
            waitThread.interrupt();
            process.destroy();
            throw new TikaException(StringsParser.class.getName() + " timeout", (Throwable)te);
        }
        return totalBytes;
    }

    private int extractOutput(InputStream stream, XHTMLContentHandler xhtml) throws SAXException, IOException {
        char[] buffer = new char[1024];
        int totalBytes = 0;
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(stream, StandardCharsets.UTF_8));){
            int n = 0;
            while ((n = reader.read(buffer)) != -1) {
                if (n > 0) {
                    xhtml.characters(buffer, 0, n);
                }
                totalBytes += n;
            }
        }
        return totalBytes;
    }

    private String doFile(File input, FileConfig config) throws IOException {
        if (!this.hasFile(config)) {
            return null;
        }
        ArrayList<String> cmdList = new ArrayList<String>(3);
        cmdList.add(config.getFilePath() + StringsParser.getFileProg());
        cmdList.add("-b");
        if (config.isMimetype()) {
            cmdList.add("-I");
        }
        cmdList.add(input.getPath());
        String[] cmd = cmdList.toArray(new String[cmdList.size()]);
        ProcessBuilder pb = new ProcessBuilder(cmd);
        Process process = pb.start();
        InputStream out = process.getInputStream();
        String fileOutput = null;
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(out, StandardCharsets.UTF_8));){
            fileOutput = reader.readLine();
        }
        catch (IOException ioe) {
            fileOutput = "";
        }
        return fileOutput;
    }

    public static String getStringsProg() {
        return System.getProperty("os.name").startsWith("Windows") ? "strings.exe" : "strings";
    }

    public static String getFileProg() {
        return System.getProperty("os.name").startsWith("Windows") ? "file.exe" : "file";
    }
}

