/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.pot;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Logger;
import org.apache.commons.exec.CommandLine;
import org.apache.commons.exec.DefaultExecutor;
import org.apache.commons.exec.ExecuteStreamHandler;
import org.apache.commons.exec.ExecuteWatchdog;
import org.apache.commons.exec.PumpStreamHandler;
import org.apache.commons.exec.environment.EnvironmentUtils;
import org.apache.tika.exception.TikaException;
import org.apache.tika.io.TemporaryResources;
import org.apache.tika.io.TikaInputStream;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.mime.MediaType;
import org.apache.tika.parser.AbstractParser;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.parser.external.ExternalParser;
import org.apache.tika.sax.XHTMLContentHandler;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class PooledTimeSeriesParser
extends AbstractParser {
    private static final long serialVersionUID = -2855917932512164988L;
    private static final Set<MediaType> SUPPORTED_TYPES = Collections.unmodifiableSet(new HashSet<MediaType>(Arrays.asList(MediaType.video((String)"avi"), MediaType.video((String)"mp4"))));
    private static final Logger LOG = Logger.getLogger(PooledTimeSeriesParser.class.getName());

    public boolean isAvailable() {
        return ExternalParser.check((String[])new String[]{"pooled-time-series", "--help"}, (int[])new int[]{-1});
    }

    public Set<MediaType> getSupportedTypes(ParseContext context) {
        return SUPPORTED_TYPES;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parse(InputStream stream, ContentHandler handler, Metadata metadata, ParseContext context) throws IOException, SAXException, TikaException {
        if (!this.isAvailable()) {
            LOG.warning("PooledTimeSeries not installed!");
            return;
        }
        XHTMLContentHandler xhtml = new XHTMLContentHandler(handler, metadata);
        TemporaryResources tmp = new TemporaryResources();
        File output = null;
        try {
            TikaInputStream tikaStream = TikaInputStream.get((InputStream)stream, (TemporaryResources)tmp);
            File input = tikaStream.getFile();
            String cmdOutput = this.computePoT(input);
            FileInputStream ofStream = new FileInputStream(new File(input.getAbsoluteFile() + ".of.txt"));
            FileInputStream ogStream = new FileInputStream(new File(input.getAbsoluteFile() + ".hog.txt"));
            this.extractHeaderOutput(ofStream, metadata, "of");
            this.extractHeaderOutput(ogStream, metadata, "og");
            xhtml.startDocument();
            this.doExtract(ofStream, xhtml, "Histogram of Optical Flows (HOF)", metadata.get("of_frames"), metadata.get("of_vecSize"));
            this.doExtract(ogStream, xhtml, "Histogram of Oriented Gradients (HOG)", metadata.get("og_frames"), metadata.get("og_vecSize"));
            xhtml.endDocument();
        }
        finally {
            tmp.dispose();
            if (output != null) {
                output.delete();
            }
        }
    }

    private String computePoT(File input) throws IOException, TikaException {
        CommandLine cmdLine = new CommandLine("pooled-time-series");
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        cmdLine.addArgument("-f");
        cmdLine.addArgument(input.getAbsolutePath());
        LOG.fine("Executing: " + cmdLine);
        DefaultExecutor exec = new DefaultExecutor();
        exec.setExitValue(0);
        ExecuteWatchdog watchdog = new ExecuteWatchdog(60000L);
        exec.setWatchdog(watchdog);
        PumpStreamHandler streamHandler = new PumpStreamHandler((OutputStream)outputStream);
        exec.setStreamHandler((ExecuteStreamHandler)streamHandler);
        int exitValue = exec.execute(cmdLine, EnvironmentUtils.getProcEnvironment());
        return outputStream.toString("UTF-8");
    }

    private void doExtract(InputStream stream, XHTMLContentHandler xhtml, String tableTitle, String frames, String vecSize) throws SAXException, IOException {
        BufferedReader reader = new BufferedReader(new InputStreamReader(stream, StandardCharsets.UTF_8));
        String line = null;
        AttributesImpl attributes = new AttributesImpl();
        attributes.addAttribute("", "", "rows", "CDATA", frames);
        attributes.addAttribute("", "", "cols", "CDATA", vecSize);
        xhtml.startElement("h3");
        xhtml.characters(tableTitle);
        xhtml.endElement("h3");
        xhtml.startElement("table", attributes);
        while ((line = reader.readLine()) != null) {
            xhtml.startElement("tr");
            for (String val : line.split(" ")) {
                xhtml.startElement("td");
                xhtml.characters(val);
                xhtml.endElement("td");
            }
            xhtml.endElement("tr");
        }
        xhtml.endElement("table");
    }

    private void extractHeaderOutput(InputStream stream, Metadata metadata, String prefix) throws IOException {
        BufferedReader reader = new BufferedReader(new InputStreamReader(stream, StandardCharsets.UTF_8));
        String line = reader.readLine();
        String[] firstLine = line.split(" ");
        String frames = firstLine[0];
        String vecSize = firstLine[1];
        if (prefix == null) {
            prefix = "";
        }
        metadata.add(prefix + "_frames", frames);
        metadata.add(prefix + "_vecSize", vecSize);
    }
}

