/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.geo.topic;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Set;
import java.util.logging.Logger;
import org.apache.commons.exec.CommandLine;
import org.apache.commons.exec.DefaultExecutor;
import org.apache.commons.exec.ExecuteException;
import org.apache.commons.exec.ExecuteStreamHandler;
import org.apache.commons.exec.ExecuteWatchdog;
import org.apache.commons.exec.PumpStreamHandler;
import org.apache.commons.exec.environment.EnvironmentUtils;
import org.apache.tika.exception.TikaException;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.mime.MediaType;
import org.apache.tika.parser.AbstractParser;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.parser.external.ExternalParser;
import org.apache.tika.parser.geo.topic.GeoParserConfig;
import org.apache.tika.parser.geo.topic.GeoTag;
import org.apache.tika.parser.geo.topic.NameEntityExtractor;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.JSONValue;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class GeoParser
extends AbstractParser {
    private static final long serialVersionUID = -2241391757440215491L;
    private static final MediaType MEDIA_TYPE = MediaType.application((String)"geotopic");
    private static final Set<MediaType> SUPPORTED_TYPES = Collections.singleton(MEDIA_TYPE);
    private GeoParserConfig config = new GeoParserConfig();
    private static final Logger LOG = Logger.getLogger(GeoParser.class.getName());

    public Set<MediaType> getSupportedTypes(ParseContext parseContext) {
        return SUPPORTED_TYPES;
    }

    public void parse(InputStream stream, ContentHandler handler, Metadata metadata, ParseContext context) throws IOException, SAXException, TikaException {
        this.config = (GeoParserConfig)context.get(GeoParserConfig.class, (Object)this.config);
        String nerModelPath = this.config.getNERPath();
        if (!this.isAvailable()) {
            return;
        }
        NameEntityExtractor extractor = new NameEntityExtractor(nerModelPath);
        extractor.getAllNameEntitiesfromInput(stream);
        extractor.getBestNameEntity();
        ArrayList<String> locationNameEntities = extractor.locationNameEntities;
        String bestner = extractor.bestNameEntity;
        HashMap<String, ArrayList<String>> resolvedGeonames = this.searchGeoNames(locationNameEntities);
        GeoTag geotag = new GeoTag();
        geotag.toGeoTag(resolvedGeonames, bestner);
        metadata.add("Geographic_NAME", geotag.Geographic_NAME);
        metadata.add("Geographic_LONGITUDE", geotag.Geographic_LONGTITUDE);
        metadata.add("Geographic_LATITUDE", geotag.Geographic_LATITUDE);
        for (int i = 0; i < geotag.alternatives.size(); ++i) {
            GeoTag alter = geotag.alternatives.get(i);
            metadata.add("Optional_NAME" + (i + 1), alter.Geographic_NAME);
            metadata.add("Optional_LONGITUDE" + (i + 1), alter.Geographic_LONGTITUDE);
            metadata.add("Optional_LATITUDE" + (i + 1), alter.Geographic_LATITUDE);
        }
    }

    public HashMap<String, ArrayList<String>> searchGeoNames(ArrayList<String> locationNameEntities) throws ExecuteException, IOException {
        CommandLine cmdLine = new CommandLine("lucene-geo-gazetteer");
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        cmdLine.addArgument("-s");
        for (String name : locationNameEntities) {
            cmdLine.addArgument(name);
        }
        LOG.fine("Executing: " + cmdLine);
        DefaultExecutor exec = new DefaultExecutor();
        exec.setExitValue(0);
        ExecuteWatchdog watchdog = new ExecuteWatchdog(60000L);
        exec.setWatchdog(watchdog);
        PumpStreamHandler streamHandler = new PumpStreamHandler((OutputStream)outputStream);
        exec.setStreamHandler((ExecuteStreamHandler)streamHandler);
        int exitValue = exec.execute(cmdLine, EnvironmentUtils.getProcEnvironment());
        String outputJson = outputStream.toString("UTF-8");
        JSONArray json = (JSONArray)JSONValue.parse((String)outputJson);
        HashMap<String, ArrayList<String>> returnHash = new HashMap<String, ArrayList<String>>();
        for (int i = 0; i < json.size(); ++i) {
            JSONObject obj = (JSONObject)json.get(i);
            for (Object key : obj.keySet()) {
                String theKey = (String)key;
                JSONArray vals = (JSONArray)obj.get((Object)theKey);
                ArrayList<String> stringVals = new ArrayList<String>(vals.size());
                for (int j = 0; j < vals.size(); ++j) {
                    String val = (String)vals.get(j);
                    stringVals.add(val);
                }
                returnHash.put(theKey, stringVals);
            }
        }
        return returnHash;
    }

    public boolean isAvailable() {
        return ExternalParser.check((String[])new String[]{"lucene-geo-gazetteer", "--help"}, (int[])new int[]{-1}) && this.config.getNERPath() != null && !this.config.getNERPath().equals("");
    }
}

