/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.microsoft.ooxml;

import java.io.IOException;
import org.apache.poi.POIXMLTextExtractor;
import org.apache.poi.xslf.XSLFSlideShow;
import org.apache.poi.xslf.extractor.XSLFPowerPointExtractor;
import org.apache.poi.xslf.usermodel.XMLSlideShow;
import org.apache.poi.xslf.usermodel.XSLFSlide;
import org.apache.tika.parser.microsoft.ooxml.AbstractOOXMLExtractor;
import org.apache.tika.sax.XHTMLContentHandler;
import org.apache.xmlbeans.XmlException;
import org.openxmlformats.schemas.drawingml.x2006.main.CTRegularTextRun;
import org.openxmlformats.schemas.drawingml.x2006.main.CTTextBody;
import org.openxmlformats.schemas.drawingml.x2006.main.CTTextParagraph;
import org.openxmlformats.schemas.presentationml.x2006.main.CTComment;
import org.openxmlformats.schemas.presentationml.x2006.main.CTCommentList;
import org.openxmlformats.schemas.presentationml.x2006.main.CTGroupShape;
import org.openxmlformats.schemas.presentationml.x2006.main.CTNotesSlide;
import org.openxmlformats.schemas.presentationml.x2006.main.CTShape;
import org.openxmlformats.schemas.presentationml.x2006.main.CTSlide;
import org.openxmlformats.schemas.presentationml.x2006.main.CTSlideIdListEntry;
import org.xml.sax.SAXException;

public class XSLFPowerPointExtractorDecorator
extends AbstractOOXMLExtractor {
    public XSLFPowerPointExtractorDecorator(XSLFPowerPointExtractor extractor) {
        super((POIXMLTextExtractor)extractor, "application/vnd.openxmlformats-officedocument.presentationml.presentation");
    }

    protected void buildXHTML(XHTMLContentHandler xhtml) throws SAXException, XmlException, IOException {
        XSLFSlide[] slides;
        XSLFSlideShow slideShow = (XSLFSlideShow)this.extractor.getDocument();
        XMLSlideShow xmlSlideShow = new XMLSlideShow(slideShow);
        XSLFSlide[] arr$ = slides = xmlSlideShow.getSlides();
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            XSLFSlide slide = arr$[i$];
            CTSlide rawSlide = slide._getCTSlide();
            CTSlideIdListEntry slideId = slide._getCTSlideId();
            CTNotesSlide notes = xmlSlideShow._getXSLFSlideShow().getNotes(slideId);
            CTCommentList comments = xmlSlideShow._getXSLFSlideShow().getSlideComments(slideId);
            xhtml.startElement("div");
            this.extractShapeContent(rawSlide.getCSld().getSpTree(), xhtml);
            if (comments != null) {
                CTComment[] arr$2 = comments.getCmArray();
                int len$2 = arr$2.length;
                for (int i$2 = 0; i$2 < len$2; ++i$2) {
                    CTComment comment = arr$2[i$2];
                    xhtml.element("p", comment.getText());
                }
            }
            if (notes != null) {
                this.extractShapeContent(notes.getCSld().getSpTree(), xhtml);
            }
            xhtml.endElement("div");
        }
    }

    private void extractShapeContent(CTGroupShape gs, XHTMLContentHandler xhtml) throws SAXException {
        CTShape[] shapes;
        CTShape[] arr$ = shapes = gs.getSpArray();
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            CTTextParagraph[] paras;
            CTShape shape = arr$[i$];
            CTTextBody textBody = shape.getTxBody();
            if (textBody == null) continue;
            CTTextParagraph[] arr$2 = paras = textBody.getPArray();
            int len$2 = arr$2.length;
            for (int i$2 = 0; i$2 < len$2; ++i$2) {
                CTRegularTextRun[] textRuns;
                CTTextParagraph textParagraph = arr$2[i$2];
                CTRegularTextRun[] arr$3 = textRuns = textParagraph.getRArray();
                int len$3 = arr$3.length;
                for (int i$3 = 0; i$3 < len$3; ++i$3) {
                    CTRegularTextRun textRun = arr$3[i$3];
                    xhtml.element("p", textRun.getT());
                }
            }
        }
    }
}

