/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.mbox;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;
import org.apache.tika.exception.TikaException;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.parser.Parser;
import org.apache.tika.sax.XHTMLContentHandler;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class MboxParser
implements Parser {
    private static final Logger LOGGER;
    public static final String MBOX_MIME_TYPE = "application/mbox";
    public static final String MBOX_RECORD_DIVIDER = "From ";
    private static final Pattern EMAIL_HEADER_PATTERN;
    private static final String EMAIL_HEADER_METADATA_PREFIX;
    private static final String EMAIL_FROMLINE_METADATA;
    static /* synthetic */ Class class$org$apache$tika$parser$mbox$MboxParser;

    public void parse(InputStream stream, ContentHandler handler, Metadata metadata, ParseContext context) throws IOException, TikaException, SAXException {
        InputStreamReader isr;
        try {
            isr = new InputStreamReader(stream, "us-ascii");
        }
        catch (UnsupportedEncodingException e) {
            LOGGER.error((Object)"Unexpected exception setting up MboxParser", (Throwable)e);
            isr = new InputStreamReader(stream);
        }
        BufferedReader reader = new BufferedReader(isr);
        metadata.set("Content-Type", MBOX_MIME_TYPE);
        metadata.set("Content-Encoding", "us-ascii");
        XHTMLContentHandler xhtml = new XHTMLContentHandler(handler, metadata);
        xhtml.startDocument();
        ParseStates parseState = ParseStates.START;
        String multiLine = null;
        boolean inQuote = false;
        int numEmails = 0;
        String curLine = reader.readLine();
        while (curLine != null) {
            boolean newMessage = curLine.startsWith(MBOX_RECORD_DIVIDER);
            if (newMessage) {
                ++numEmails;
            }
            switch (1.$SwitchMap$org$apache$tika$parser$mbox$MboxParser$ParseStates[parseState.ordinal()]) {
                case 1: {
                    if (!newMessage) break;
                    parseState = ParseStates.IN_HEADER;
                    newMessage = false;
                }
                case 2: {
                    if (newMessage) {
                        this.saveHeaderInMetadata(numEmails, metadata, multiLine);
                        multiLine = curLine;
                        break;
                    }
                    if (curLine.length() == 0) {
                        this.saveHeaderInMetadata(numEmails, metadata, multiLine);
                        parseState = ParseStates.IN_CONTENT;
                        xhtml.startElement("div", "class", "email-entry");
                        xhtml.startElement("p");
                        inQuote = false;
                        break;
                    }
                    if (curLine.startsWith(" ") || curLine.startsWith("\t")) {
                        multiLine = multiLine + " " + curLine.trim();
                        break;
                    }
                    this.saveHeaderInMetadata(numEmails, metadata, multiLine);
                    multiLine = curLine;
                    break;
                }
                case 3: {
                    if (newMessage) {
                        this.endMessage(xhtml, inQuote);
                        parseState = ParseStates.IN_HEADER;
                        multiLine = curLine;
                        break;
                    }
                    boolean quoted = curLine.startsWith(">");
                    if (inQuote) {
                        if (!quoted) {
                            xhtml.endElement("q");
                            inQuote = false;
                        }
                    } else if (quoted) {
                        xhtml.startElement("q");
                        inQuote = true;
                    }
                    xhtml.characters(curLine);
                    xhtml.element("br", "");
                }
            }
            curLine = reader.readLine();
        }
        if (parseState == ParseStates.IN_HEADER) {
            this.saveHeaderInMetadata(numEmails, metadata, multiLine);
        } else if (parseState == ParseStates.IN_CONTENT) {
            this.endMessage(xhtml, inQuote);
        }
        xhtml.endDocument();
    }

    private void endMessage(XHTMLContentHandler xhtml, boolean inQuote) throws SAXException {
        if (inQuote) {
            xhtml.endElement("q");
        }
        xhtml.endElement("p");
        xhtml.endElement("div");
    }

    private void saveHeaderInMetadata(int numEmails, Metadata metadata, String curLine) {
        if (curLine == null || numEmails > 1) {
            return;
        }
        if (curLine.startsWith(MBOX_RECORD_DIVIDER)) {
            metadata.add(EMAIL_FROMLINE_METADATA, curLine.substring(MBOX_RECORD_DIVIDER.length()));
            return;
        }
        Matcher headerMatcher = EMAIL_HEADER_PATTERN.matcher(curLine);
        if (!headerMatcher.matches()) {
            LOGGER.warn((Object)("Malformed email header in mbox file: " + curLine));
            return;
        }
        String headerTag = headerMatcher.group(1).toLowerCase();
        String headerContent = headerMatcher.group(2);
        if (headerTag.equalsIgnoreCase("From")) {
            metadata.add("Author", headerContent);
            metadata.add("creator", headerContent);
        } else if (headerTag.equalsIgnoreCase("Subject")) {
            metadata.add("subject", headerContent);
            metadata.add("title", headerContent);
        } else if (headerTag.equalsIgnoreCase("Date")) {
            metadata.add("date", headerContent);
        } else if (headerTag.equalsIgnoreCase("Message-Id")) {
            metadata.add("identifier", headerContent);
        } else if (headerTag.equalsIgnoreCase("In-Reply-To")) {
            metadata.add("relation", headerContent);
        } else if (headerTag.equalsIgnoreCase("Content-Type")) {
            metadata.add("Content-Type", headerContent);
            metadata.add("format", headerContent);
        } else {
            metadata.add(EMAIL_HEADER_METADATA_PREFIX + headerTag, headerContent);
        }
    }

    public void parse(InputStream stream, ContentHandler handler, Metadata metadata) throws IOException, SAXException, TikaException {
        this.parse(stream, handler, metadata, new ParseContext());
    }

    static {
        Class<?> clazz = class$org$apache$tika$parser$mbox$MboxParser;
        if (clazz == null) {
            clazz = class$org$apache$tika$parser$mbox$MboxParser = new MboxParser[0].getClass().getComponentType();
        }
        LOGGER = Logger.getLogger((Class)clazz);
        EMAIL_HEADER_PATTERN = Pattern.compile("([^ ]+):[ \t]*(.*)");
        StringBuffer stringBuffer = new StringBuffer();
        Class<?> clazz2 = class$org$apache$tika$parser$mbox$MboxParser;
        if (clazz2 == null) {
            clazz2 = class$org$apache$tika$parser$mbox$MboxParser = new MboxParser[0].getClass().getComponentType();
        }
        EMAIL_HEADER_METADATA_PREFIX = stringBuffer.append(clazz2.getSimpleName()).append("-").toString();
        EMAIL_FROMLINE_METADATA = EMAIL_HEADER_METADATA_PREFIX + "from";
    }

    static class 1 {
        static final /* synthetic */ int[] $SwitchMap$org$apache$tika$parser$mbox$MboxParser$ParseStates;

        static {
            $SwitchMap$org$apache$tika$parser$mbox$MboxParser$ParseStates = new int[ParseStates.values().length];
            try {
                1.$SwitchMap$org$apache$tika$parser$mbox$MboxParser$ParseStates[ParseStates.START.ordinal()] = 1;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                1.$SwitchMap$org$apache$tika$parser$mbox$MboxParser$ParseStates[ParseStates.IN_HEADER.ordinal()] = 2;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                1.$SwitchMap$org$apache$tika$parser$mbox$MboxParser$ParseStates[ParseStates.IN_CONTENT.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
        }
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class ParseStates
    extends Enum<ParseStates> {
        public static final ParseStates START = new ParseStates("START", 0);
        public static final ParseStates IN_HEADER = new ParseStates("IN_HEADER", 1);
        public static final ParseStates IN_CONTENT = new ParseStates("IN_CONTENT", 2);
        private static final /* synthetic */ ParseStates[] $VALUES;
        static /* synthetic */ Class class$org$apache$tika$parser$mbox$MboxParser$ParseStates;

        public static final ParseStates[] values() {
            return (ParseStates[])$VALUES.clone();
        }

        public static ParseStates valueOf(String name) {
            Class<?> clazz = class$org$apache$tika$parser$mbox$MboxParser$ParseStates;
            if (clazz == null) {
                clazz = class$org$apache$tika$parser$mbox$MboxParser$ParseStates = new ParseStates[0].getClass().getComponentType();
            }
            return (ParseStates)((Object)Enum.valueOf(clazz, name));
        }

        private ParseStates() {
        }

        static {
            $VALUES = new ParseStates[]{START, IN_HEADER, IN_CONTENT};
        }
    }
}

