/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.html;

import java.net.MalformedURLException;
import java.net.URL;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.parser.html.HtmlParser;
import org.apache.tika.sax.TextContentHandler;
import org.apache.tika.sax.XHTMLContentHandler;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

class HtmlHandler
extends TextContentHandler {
    private final HtmlParser parser;
    private final XHTMLContentHandler xhtml;
    private final Metadata metadata;
    private int bodyLevel = 0;
    private int discardLevel = 0;
    private int titleLevel = 0;
    private final StringBuffer title = new StringBuffer();

    private HtmlHandler(HtmlParser parser, XHTMLContentHandler xhtml, Metadata metadata) {
        super((ContentHandler)xhtml);
        String name;
        this.parser = parser;
        this.xhtml = xhtml;
        this.metadata = metadata;
        if (metadata.get("Content-Location") == null && (name = metadata.get("resourceName")) != null) {
            name = name.trim();
            try {
                new URL(name);
                metadata.set("Content-Location", name);
            }
            catch (MalformedURLException e) {
                // empty catch block
            }
        }
    }

    public HtmlHandler(HtmlParser parser, ContentHandler handler, Metadata metadata) {
        this(parser, new XHTMLContentHandler(handler, metadata), metadata);
    }

    public void startElement(String uri, String local, String name, Attributes atts) throws SAXException {
        if ("TITLE".equals(name) || this.titleLevel > 0) {
            ++this.titleLevel;
        }
        if ("BODY".equals(name) || this.bodyLevel > 0) {
            ++this.bodyLevel;
        }
        if (this.parser.isDiscardElement(name) || this.discardLevel > 0) {
            ++this.discardLevel;
        }
        if (this.bodyLevel == 0 && this.discardLevel == 0) {
            if ("META".equals(name) && atts.getValue("content") != null) {
                if (atts.getValue("http-equiv") != null) {
                    this.metadata.set(atts.getValue("http-equiv"), atts.getValue("content"));
                }
                if (atts.getValue("name") != null) {
                    this.metadata.set(atts.getValue("name"), atts.getValue("content"));
                }
            } else if ("BASE".equals(name) && atts.getValue("href") != null) {
                this.metadata.set("Content-Location", this.resolve(atts.getValue("href").trim()));
            }
        }
        if (this.bodyLevel > 0 && this.discardLevel == 0) {
            String safe = this.parser.mapSafeElement(name);
            if (safe != null) {
                this.xhtml.startElement(safe);
            } else if ("A".equals(name)) {
                String href = atts.getValue("href");
                if (href != null) {
                    this.xhtml.startElement("a", "href", this.resolve(href.trim()));
                } else {
                    String anchor = atts.getValue("name");
                    if (anchor != null) {
                        this.xhtml.startElement("a", "name", anchor.trim());
                    } else {
                        this.xhtml.startElement("a");
                    }
                }
            }
        }
        this.title.setLength(0);
    }

    public void endElement(String uri, String local, String name) throws SAXException {
        if (this.bodyLevel > 0 && this.discardLevel == 0) {
            String safe = this.parser.mapSafeElement(name);
            if (safe != null) {
                this.xhtml.endElement(safe);
            } else if ("A".equals(name)) {
                this.xhtml.endElement("a");
            }
        }
        if (this.titleLevel > 0) {
            --this.titleLevel;
            if (this.titleLevel == 0) {
                this.metadata.set("title", this.title.toString().trim());
            }
        }
        if (this.bodyLevel > 0) {
            --this.bodyLevel;
        }
        if (this.discardLevel > 0) {
            --this.discardLevel;
        }
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.titleLevel > 0 && this.bodyLevel == 0) {
            this.title.append(ch, start, length);
        }
        if (this.bodyLevel > 0 && this.discardLevel == 0) {
            super.characters(ch, start, length);
        }
    }

    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        if (this.bodyLevel > 0 && this.discardLevel == 0) {
            super.ignorableWhitespace(ch, start, length);
        }
    }

    private String resolve(String url) {
        if (this.metadata.get("Content-Location") == null) {
            return url;
        }
        String lower = url.toLowerCase();
        if (lower.startsWith("urn:") || lower.startsWith("mailto:") || lower.startsWith("tel:") || lower.startsWith("data:") || lower.startsWith("javascript:") || lower.startsWith("about:")) {
            return url;
        }
        try {
            URL base = new URL(this.metadata.get("Content-Location").trim());
            String path = base.getPath();
            if (url.startsWith("?") && path.length() > 0 && !path.endsWith("/")) {
                return new URL(base.getProtocol(), base.getHost(), base.getPort(), base.getPath() + url).toExternalForm();
            }
            return new URL(base, url).toExternalForm();
        }
        catch (MalformedURLException e) {
            return url;
        }
    }
}

