/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.audio;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.sound.midi.InvalidMidiDataException;
import javax.sound.midi.MetaMessage;
import javax.sound.midi.MidiMessage;
import javax.sound.midi.MidiSystem;
import javax.sound.midi.Patch;
import javax.sound.midi.Sequence;
import javax.sound.midi.Track;
import org.apache.tika.exception.TikaException;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.parser.Parser;
import org.apache.tika.sax.XHTMLContentHandler;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class MidiParser
implements Parser {
    public void parse(InputStream stream, ContentHandler handler, Metadata metadata, ParseContext context) throws IOException, SAXException, TikaException {
        XHTMLContentHandler xhtml = new XHTMLContentHandler(handler, metadata);
        xhtml.startDocument();
        BufferedInputStream buffered = new BufferedInputStream(stream);
        try {
            Sequence sequence = MidiSystem.getSequence(buffered);
            Track[] tracks = sequence.getTracks();
            metadata.set("tracks", String.valueOf(tracks.length));
            Patch[] patches = sequence.getPatchList();
            metadata.set("patches", String.valueOf(patches.length));
            float type = sequence.getDivisionType();
            if (type == 0.0f) {
                metadata.set("divisionType", "PPQ");
            } else if (type == 24.0f) {
                metadata.set("divisionType", "SMPTE_24");
            } else if (type == 25.0f) {
                metadata.set("divisionType", "SMPTE_25");
            } else if (type == 30.0f) {
                metadata.set("divisionType", "SMPTE_30");
            } else if (type == 29.97f) {
                metadata.set("divisionType", "SMPTE_30DROP");
            } else if (type == 24.0f) {
                metadata.set("divisionType", String.valueOf(type));
            }
            Track[] arr$ = tracks;
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$; ++i$) {
                Track track = arr$[i$];
                xhtml.startElement("p");
                for (int i = 0; i < track.size(); ++i) {
                    MetaMessage meta;
                    MidiMessage message = track.get(i).getMessage();
                    if (!(message instanceof MetaMessage) || (meta = (MetaMessage)message).getType() < 1 || meta.getType() > 15) continue;
                    xhtml.characters(new String(meta.getData(), "ISO-8859-1"));
                }
                xhtml.endElement("p");
            }
        }
        catch (InvalidMidiDataException ignore) {
            // empty catch block
        }
        xhtml.endDocument();
    }

    public void parse(InputStream stream, ContentHandler handler, Metadata metadata) throws IOException, SAXException, TikaException {
        this.parse(stream, handler, metadata, new ParseContext());
    }
}

