/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.detect.zip;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.List;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.tika.TikaTest;
import org.apache.tika.detect.Detector;
import org.apache.tika.detect.zip.DefaultZipContainerDetector;
import org.apache.tika.io.TikaInputStream;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.mime.MediaType;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ZipDetectionTest
extends TikaTest {
    @Test
    public void testKMZDetection() throws Exception {
        List metadataList = this.getRecursiveMetadata("testKMZ.kmz");
        Assertions.assertEquals((Object)"application/vnd.google-earth.kmz", (Object)((Metadata)metadataList.get(0)).get("Content-Type"));
    }

    @Test
    public void testJARDetection() throws Exception {
        List metadataList = this.getRecursiveMetadata("testJAR.jar");
        Assertions.assertEquals((Object)"application/java-archive", (Object)((Metadata)metadataList.get(0)).get("Content-Type"));
    }

    @Test
    public void testStreaming() throws Exception {
        String expectedDigest = this.digest("testJAR.jar");
        DefaultZipContainerDetector detector = new DefaultZipContainerDetector();
        try (Object is = TikaInputStream.get((InputStream)this.getStream("testJAR.jar"));){
            this.assertExpected((Detector)detector, (InputStream)is, "application/java-archive", expectedDigest);
        }
        for (TikaInputStream markLimit : (Object)new int[]{-1, 0, 10, 100, 1000}) {
            detector = new DefaultZipContainerDetector();
            try (TikaInputStream is = TikaInputStream.get((InputStream)this.getStream("testJAR.jar"));){
                detector.setMarkLimit((int)markLimit);
                this.assertExpected((Detector)detector, (InputStream)is, "application/java-archive", expectedDigest);
            }
        }
        detector = new DefaultZipContainerDetector();
        is = TikaInputStream.get((InputStream)this.getStream("testJAR.jar"));
        try {
            detector.setMarkLimit(-1);
            this.assertExpected((Detector)detector, (InputStream)is, "application/java-archive", expectedDigest);
        }
        finally {
            if (is != null) {
                ((InputStream)is).close();
            }
        }
        detector = new DefaultZipContainerDetector();
        is = new BufferedInputStream(Files.newInputStream(TikaInputStream.get((InputStream)this.getStream("testJAR.jar")).getPath(), new OpenOption[0]));
        try {
            this.assertExpected((Detector)detector, (InputStream)is, "application/java-archive", expectedDigest);
        }
        finally {
            ((InputStream)is).close();
        }
        detector = new DefaultZipContainerDetector();
        is = ZipDetectionTest.class.getResourceAsStream("/test-documents/testJAR.jar");
        try {
            this.assertExpected((Detector)detector, (InputStream)is, "application/java-archive", expectedDigest);
        }
        finally {
            if (is != null) {
                ((InputStream)is).close();
            }
        }
        detector = new DefaultZipContainerDetector();
        detector.setMarkLimit(100);
        is = ZipDetectionTest.class.getResourceAsStream("/test-documents/testJAR.jar");
        try {
            this.assertExpected((Detector)detector, (InputStream)is, "application/zip", expectedDigest);
        }
        finally {
            if (is != null) {
                ((InputStream)is).close();
            }
        }
        detector = new DefaultZipContainerDetector();
        detector.setMarkLimit(0);
        is = ZipDetectionTest.class.getResourceAsStream("/test-documents/testJAR.jar");
        try {
            this.assertExpected((Detector)detector, (InputStream)is, "application/zip", expectedDigest);
        }
        finally {
            if (is != null) {
                ((InputStream)is).close();
            }
        }
        detector = new DefaultZipContainerDetector();
        detector.setMarkLimit(100000);
        is = ZipDetectionTest.class.getResourceAsStream("/test-documents/testJAR.jar");
        try {
            this.assertExpected((Detector)detector, (InputStream)is, "application/java-archive", expectedDigest);
        }
        finally {
            if (is != null) {
                ((InputStream)is).close();
            }
        }
    }

    private InputStream getStream(String fileName) {
        return ZipDetectionTest.class.getResourceAsStream("/test-documents/" + fileName);
    }

    private void assertExpected(Detector detector, InputStream is, String expectedMime, String expectedDigest) throws IOException {
        MediaType mt = detector.detect(is, new Metadata());
        Assertions.assertEquals((Object)expectedMime, (Object)mt.toString());
        Assertions.assertEquals((Object)expectedDigest, (Object)this.digest(is));
    }

    private String digest(String fileName) throws IOException {
        return this.digest(ZipDetectionTest.class.getResourceAsStream("/test-documents/" + fileName));
    }

    private String digest(InputStream is) throws IOException {
        return DigestUtils.sha256Hex((InputStream)is);
    }
}

