/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.xmp;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.tika.TikaTest;
import org.apache.tika.exception.TikaException;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.metadata.TikaCoreProperties;
import org.apache.tika.metadata.XMPMM;
import org.apache.tika.parser.xmp.JempboxExtractor;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class JempboxExtractorTest
extends TikaTest {
    @Test
    public void testParseJpeg() throws IOException, TikaException {
        Metadata metadata = new Metadata();
        try (InputStream stream = this.getResourceAsStream("/test-documents/testJPEG_commented.jpg");){
            metadata.set(TikaCoreProperties.TITLE, "old title");
            metadata.set(TikaCoreProperties.DESCRIPTION, "old description");
            metadata.set(TikaCoreProperties.CREATOR, "previous author");
            metadata.add(TikaCoreProperties.SUBJECT, "oldkeyword");
            JempboxExtractor extractor = new JempboxExtractor(metadata);
            extractor.parse(stream);
            Assertions.assertEquals((Object)"Tosteberga \u00c4ngar", (Object)metadata.get(TikaCoreProperties.TITLE));
            Assertions.assertEquals((Object)"Bird site in north eastern Sk\u00e5ne, Sweden.\n(new line)", (Object)metadata.get(TikaCoreProperties.DESCRIPTION));
            Assertions.assertEquals((Object)"Some Tourist", (Object)metadata.get(TikaCoreProperties.CREATOR));
            List<String> keywords = Arrays.asList(metadata.getValues(TikaCoreProperties.SUBJECT));
            Assertions.assertTrue((boolean)keywords.contains("oldkeyword"));
            Assertions.assertTrue((boolean)keywords.contains("grazelands"));
            Assertions.assertTrue((boolean)keywords.contains("nature reserve"));
            Assertions.assertTrue((boolean)keywords.contains("bird watching"));
            Assertions.assertTrue((boolean)keywords.contains("coast"));
        }
    }

    @Test
    public void testParseJpegPhotoshop() throws IOException, TikaException {
        Metadata metadata = new Metadata();
        try (InputStream stream = this.getResourceAsStream("/test-documents/testJPEG_commented_pspcs2mac.jpg");){
            JempboxExtractor extractor = new JempboxExtractor(metadata);
            extractor.parse(stream);
            Assertions.assertEquals((Object)"Tosteberga \u00c4ngar", (Object)metadata.get(TikaCoreProperties.TITLE));
            Assertions.assertEquals((Object)"Bird site in north eastern Sk\u00e5ne, Sweden.\n(new line)", (Object)metadata.get(TikaCoreProperties.DESCRIPTION));
            Assertions.assertEquals((Object)"Some Tourist", (Object)metadata.get(TikaCoreProperties.CREATOR));
            List<String> keywords = Arrays.asList(metadata.getValues(TikaCoreProperties.SUBJECT));
            Assertions.assertTrue((boolean)keywords.contains("bird watching"));
            Assertions.assertTrue((boolean)keywords.contains("coast"));
        }
    }

    @Test
    public void testParseJpegXnviewmp() throws IOException, TikaException {
        Metadata metadata = new Metadata();
        try (InputStream stream = this.getResourceAsStream("/test-documents/testJPEG_commented_xnviewmp026.jpg");){
            JempboxExtractor extractor = new JempboxExtractor(metadata);
            extractor.parse(stream);
            Assertions.assertEquals((Object)"Bird site in north eastern Sk\u00e5ne, Sweden.\n(new line)", (Object)metadata.get(TikaCoreProperties.DESCRIPTION));
            List<String> keywords = Arrays.asList(metadata.getValues(TikaCoreProperties.SUBJECT));
            Assertions.assertTrue((boolean)keywords.contains("coast"));
            Assertions.assertTrue((boolean)keywords.contains("nature reserve"));
        }
    }

    @Test
    public void testJoinCreators() {
        new JempboxExtractor(null);
        Assertions.assertEquals((Object)"Mr B", (Object)JempboxExtractor.joinCreators(Collections.singletonList("Mr B")));
        new JempboxExtractor(null);
        Assertions.assertEquals((Object)"Mr B, Mr A", (Object)JempboxExtractor.joinCreators(Arrays.asList("Mr B", "Mr A")));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMaxXMPMMHistory() throws Exception {
        int maxHistory = JempboxExtractor.getMaxXMPMMHistory();
        try {
            Metadata m = new Metadata();
            JempboxExtractor ex = new JempboxExtractor(m);
            try (InputStream is = this.getResourceAsStream("/test-documents/testXMP.xmp");){
                ex.parse(is);
            }
            Assertions.assertEquals((int)7, (int)m.getValues(XMPMM.HISTORY_EVENT_INSTANCEID).length);
            JempboxExtractor.setMaxXMPMMHistory((int)5);
            m = new Metadata();
            ex = new JempboxExtractor(m);
            is = this.getResourceAsStream("/test-documents/testXMP.xmp");
            var5_5 = null;
            try {
                ex.parse(is);
            }
            catch (Throwable throwable) {
                var5_5 = throwable;
                throw throwable;
            }
            finally {
                if (is != null) {
                    if (var5_5 != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable) {
                            var5_5.addSuppressed(throwable);
                        }
                    } else {
                        is.close();
                    }
                }
            }
            Assertions.assertEquals((int)5, (int)m.getValues(XMPMM.HISTORY_EVENT_INSTANCEID).length);
        }
        finally {
            JempboxExtractor.setMaxXMPMMHistory((int)maxHistory);
        }
    }

    @Test
    public void testModifiedTZ() throws Exception {
        Metadata m = new Metadata();
        JempboxExtractor ex = new JempboxExtractor(m);
        try (InputStream is = this.getResourceAsStream("/test-documents/testXMP.xmp");){
            ex.parse(is);
        }
        Assertions.assertEquals((Object)"2014-03-04T22:50:41Z", (Object)m.get(XMPMM.HISTORY_WHEN));
    }
}

