/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.xml;

import java.io.InputStream;
import org.apache.tika.TikaTest;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.metadata.Property;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.parser.xml.ElementMetadataHandler;
import org.apache.tika.parser.xml.XMLParser;
import org.apache.tika.sax.BodyContentHandler;
import org.apache.tika.sax.TeeContentHandler;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.xml.sax.ContentHandler;

public class EmptyAndDuplicateElementsXMLParserTest
extends TikaTest {
    private Property FIRST_NAME = Property.internalTextBag((String)"custom:FirstName");
    private Property LAST_NAME = Property.internalTextBag((String)"custom:LastName");

    @Test
    public void testDefaultBehavior() throws Exception {
        try (InputStream input = this.getResourceAsStream("/test-documents/testXML3.xml");){
            Metadata metadata = new Metadata();
            BodyContentHandler handler = new BodyContentHandler();
            new DefaultCustomXMLTestParser().parse(input, (ContentHandler)handler, metadata, new ParseContext());
            Assertions.assertEquals((int)4, (int)metadata.getValues(this.FIRST_NAME).length);
            Assertions.assertEquals((int)2, (int)metadata.getValues(this.LAST_NAME).length);
            Assertions.assertEquals((Object)"John", (Object)metadata.getValues(this.FIRST_NAME)[0]);
            Assertions.assertEquals((Object)"Smith", (Object)metadata.getValues(this.LAST_NAME)[0]);
            Assertions.assertEquals((Object)"Jane", (Object)metadata.getValues(this.FIRST_NAME)[1]);
            Assertions.assertEquals((Object)"Doe", (Object)metadata.getValues(this.LAST_NAME)[1]);
            Assertions.assertEquals((Object)"Bob", (Object)metadata.getValues(this.FIRST_NAME)[2]);
            Assertions.assertEquals((Object)"Kate", (Object)metadata.getValues(this.FIRST_NAME)[3]);
        }
    }

    @Test
    public void testEmptiesAndRepeats() throws Exception {
        try (InputStream input = this.getResourceAsStream("/test-documents/testXML3.xml");){
            Metadata metadata = new Metadata();
            BodyContentHandler handler = new BodyContentHandler();
            new AllowEmptiesAndDuplicatesCustomXMLTestParser().parse(input, (ContentHandler)handler, metadata, new ParseContext());
            Assertions.assertEquals((int)4, (int)metadata.getValues(this.FIRST_NAME).length);
            Assertions.assertEquals((int)4, (int)metadata.getValues(this.LAST_NAME).length);
            Assertions.assertEquals((Object)"John", (Object)metadata.getValues(this.FIRST_NAME)[0]);
            Assertions.assertEquals((Object)"Smith", (Object)metadata.getValues(this.LAST_NAME)[0]);
            Assertions.assertEquals((Object)"Jane", (Object)metadata.getValues(this.FIRST_NAME)[1]);
            Assertions.assertEquals((Object)"Doe", (Object)metadata.getValues(this.LAST_NAME)[1]);
            Assertions.assertEquals((Object)"Bob", (Object)metadata.getValues(this.FIRST_NAME)[2]);
            Assertions.assertEquals((Object)"", (Object)metadata.getValues(this.LAST_NAME)[2]);
            Assertions.assertEquals((Object)"Kate", (Object)metadata.getValues(this.FIRST_NAME)[3]);
            Assertions.assertEquals((Object)"Smith", (Object)metadata.getValues(this.LAST_NAME)[3]);
        }
    }

    private class AllowEmptiesAndDuplicatesCustomXMLTestParser
    extends DefaultCustomXMLTestParser {
        private static final long serialVersionUID = 3735646809954466229L;

        private AllowEmptiesAndDuplicatesCustomXMLTestParser() {
        }

        @Override
        protected ElementMetadataHandler getCustomElementHandler(Metadata metadata, Property tikaProperty, String localPart) {
            return new ElementMetadataHandler("http://custom", localPart, metadata, tikaProperty, true, true);
        }
    }

    private class DefaultCustomXMLTestParser
    extends XMLParser {
        private static final long serialVersionUID = 2458579047014545931L;

        private DefaultCustomXMLTestParser() {
        }

        protected ElementMetadataHandler getCustomElementHandler(Metadata metadata, Property tikaProperty, String localPart) {
            return new ElementMetadataHandler("http://custom", localPart, metadata, tikaProperty);
        }

        protected ContentHandler getContentHandler(ContentHandler handler, Metadata metadata, ParseContext context) {
            return new TeeContentHandler(new ContentHandler[]{super.getContentHandler(handler, metadata, context), this.getCustomElementHandler(metadata, EmptyAndDuplicateElementsXMLParserTest.this.FIRST_NAME, "FirstName"), this.getCustomElementHandler(metadata, EmptyAndDuplicateElementsXMLParserTest.this.LAST_NAME, "LastName")});
        }
    }
}

