/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.tmx;

import java.io.InputStream;
import org.apache.tika.TikaTest;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.parser.tmx.TMXParser;
import org.apache.tika.sax.BodyContentHandler;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.xml.sax.ContentHandler;

public class TMXParserTest
extends TikaTest {
    @Test
    public void testTMX() throws Exception {
        try (InputStream input = this.getResourceAsStream("/test-documents/testTMX.tmx");){
            Metadata metadata = new Metadata();
            BodyContentHandler handler = new BodyContentHandler();
            new TMXParser().parse(input, (ContentHandler)handler, metadata, new ParseContext());
            String content = handler.toString();
            TMXParserTest.assertContains((String)"Hello world!", (String)content);
            TMXParserTest.assertContains((String)"Salut lume!", (String)content);
            Assertions.assertEquals((Object)"1", (Object)metadata.get("tu-count"));
            Assertions.assertEquals((Object)"2", (Object)metadata.get("tuv-count"));
            Assertions.assertEquals((Object)"en-us", (Object)metadata.get("source-language"));
            Assertions.assertEquals((Object)"ro-ro", (Object)metadata.get("target-language"));
            Assertions.assertEquals((Object)"apache-tika", (Object)metadata.get("creation-tool"));
        }
    }

    @Test
    public void testTMXToXMLHandler() throws Exception {
        String xml = this.getXML((String)"testTMX.tmx").xml;
        TMXParserTest.assertContains((String)"<p lang=\"en-us\">Hello world!</p>", (String)xml);
        TMXParserTest.assertContains((String)"<p lang=\"ro-ro\">Salut lume!</p>", (String)xml);
    }
}

