/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.xml;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.tika.TikaTest;
import org.apache.tika.exception.TikaException;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.parser.xml.TextAndAttributeXMLParser;
import org.apache.tika.sax.BodyContentHandler;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class TextAndAttributeXMLParserTest
extends TikaTest {
    @Test
    public void testParseTextAndAttributes() throws IOException, TikaException, SAXException {
        try (InputStream input = this.getResourceAsStream("/test-documents/testXML2.xml");){
            Metadata metadata = new Metadata();
            ParseContext context = new ParseContext();
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            BodyContentHandler handler = new BodyContentHandler((OutputStream)buffer);
            new TextAndAttributeXMLParser().parse(input, (ContentHandler)handler, metadata, context);
            String output = buffer.toString("UTF-8");
            Assertions.assertEquals((Object)"application/xml", (Object)metadata.get("Content-Type"));
            Assertions.assertTrue((boolean)output.contains("document type Microsoft Word 2003/2004"));
            Assertions.assertTrue((boolean)output.contains("doc_property type title Title test"));
            Assertions.assertTrue((boolean)output.contains("doc_property type subject Subject test"));
        }
    }
}

