/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.xml;

import java.io.InputStream;
import org.apache.tika.TikaTest;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.metadata.TikaCoreProperties;
import org.apache.tika.parser.xml.DcXMLParser;
import org.apache.tika.sax.BodyContentHandler;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.xml.sax.ContentHandler;
import org.xml.sax.helpers.DefaultHandler;

public class DcXMLParserTest
extends TikaTest {
    @Test
    public void testXMLParserAsciiChars() throws Exception {
        try (InputStream input = this.getResourceAsStream("/test-documents/testXML.xml");){
            Metadata metadata = new Metadata();
            BodyContentHandler handler = new BodyContentHandler();
            new DcXMLParser().parse(input, (ContentHandler)handler, metadata);
            Assertions.assertEquals((Object)"application/xml", (Object)metadata.get("Content-Type"));
            Assertions.assertEquals((Object)"Tika test document", (Object)metadata.get(TikaCoreProperties.TITLE));
            Assertions.assertEquals((Object)"Rida Benjelloun", (Object)metadata.get(TikaCoreProperties.CREATOR));
            Assertions.assertEquals((Object)true, (Object)metadata.isMultiValued(TikaCoreProperties.SUBJECT));
            Assertions.assertEquals((int)5, (int)metadata.getValues(TikaCoreProperties.SUBJECT).length);
            Assertions.assertEquals((Object)"Java", (Object)metadata.getValues(TikaCoreProperties.SUBJECT)[0]);
            Assertions.assertEquals((Object)"XML", (Object)metadata.getValues(TikaCoreProperties.SUBJECT)[1]);
            Assertions.assertEquals((Object)"XSLT", (Object)metadata.getValues(TikaCoreProperties.SUBJECT)[2]);
            Assertions.assertEquals((Object)"JDOM", (Object)metadata.getValues(TikaCoreProperties.SUBJECT)[3]);
            Assertions.assertEquals((Object)"Indexation", (Object)metadata.getValues(TikaCoreProperties.SUBJECT)[4]);
            Assertions.assertEquals((Object)"Framework d'indexation des documents XML, HTML, PDF etc..", (Object)metadata.get(TikaCoreProperties.DESCRIPTION));
            Assertions.assertEquals((Object)"http://www.apache.org", (Object)metadata.get(TikaCoreProperties.IDENTIFIER));
            Assertions.assertEquals((Object)"test", (Object)metadata.get(TikaCoreProperties.TYPE));
            Assertions.assertEquals((Object)"application/msword", (Object)metadata.get(TikaCoreProperties.FORMAT));
            Assertions.assertEquals((Object)"Fr", (Object)metadata.get(TikaCoreProperties.LANGUAGE));
            Assertions.assertTrue((boolean)metadata.get(TikaCoreProperties.RIGHTS).contains("testing chars"));
            String content = handler.toString();
            DcXMLParserTest.assertContains((String)"Tika test document", (String)content);
            Assertions.assertEquals((Object)"2000-12-01T00:00:00.000Z", (Object)metadata.get(TikaCoreProperties.CREATED));
        }
    }

    @Test
    public void testXMLParserNonAsciiChars() throws Exception {
        try (InputStream input = this.getResourceAsStream("/test-documents/testXML.xml");){
            Metadata metadata = new Metadata();
            new DcXMLParser().parse(input, (ContentHandler)new DefaultHandler(), metadata);
            String expected = "Archim\u00e8de et Lius \u00e0 Ch\u00e2teauneuf testing chars en \u00e9t\u00e9";
            Assertions.assertEquals((Object)"Archim\u00e8de et Lius \u00e0 Ch\u00e2teauneuf testing chars en \u00e9t\u00e9", (Object)metadata.get(TikaCoreProperties.RIGHTS));
        }
    }

    @Test
    public void testNoSpaces() throws Exception {
        String text = this.getXML((String)"testXML2.xml").xml;
        Assertions.assertFalse((boolean)text.contains("testSubject"));
    }
}

