/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.xliff;

import java.io.InputStream;
import org.apache.tika.TikaTest;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.parser.xliff.XLZParser;
import org.apache.tika.sax.BodyContentHandler;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.xml.sax.ContentHandler;

public class XLZParserTest {
    @Test
    public void testXLZ() throws Exception {
        try (InputStream input = XLZParserTest.class.getResourceAsStream("/test-documents/testXLIFF12.xlz");){
            Metadata metadata = new Metadata();
            BodyContentHandler handler = new BodyContentHandler();
            new XLZParser().parse(input, (ContentHandler)handler, metadata, new ParseContext());
            String content = handler.toString();
            TikaTest.assertContains((String)"Hooray", (String)content);
            Assertions.assertEquals((Object)"2", (Object)metadata.get("file-count"));
            Assertions.assertEquals((Object)"4", (Object)metadata.get("tu-count"));
            Assertions.assertEquals((Object)"en", (Object)metadata.get("source-language"));
            Assertions.assertEquals((Object)"fr", (Object)metadata.get("target-language"));
        }
    }
}

