/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.xliff;

import java.io.InputStream;
import org.apache.tika.TikaTest;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.parser.xliff.XLIFF12Parser;
import org.apache.tika.sax.BodyContentHandler;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.xml.sax.ContentHandler;

public class XLIFF12ParserTest
extends TikaTest {
    @Test
    public void testXLIFF12() throws Exception {
        try (InputStream input = this.getResourceAsStream("/test-documents/testXLIFF12.xlf");){
            Metadata metadata = new Metadata();
            BodyContentHandler handler = new BodyContentHandler();
            new XLIFF12Parser().parse(input, (ContentHandler)handler, metadata, new ParseContext());
            String content = handler.toString();
            XLIFF12ParserTest.assertContains((String)"Hooray", (String)content);
            Assertions.assertEquals((Object)"2", (Object)metadata.get("file-count"));
            Assertions.assertEquals((Object)"4", (Object)metadata.get("tu-count"));
            Assertions.assertEquals((Object)"en", (Object)metadata.get("source-language"));
            Assertions.assertEquals((Object)"fr", (Object)metadata.get("target-language"));
        }
    }

    @Test
    public void testXLIFF12ToXMLHandler() throws Exception {
        String xml = this.getXML((String)"testXLIFF12.xlf").xml;
        XLIFF12ParserTest.assertContains((String)"<p lang=\"en\">Another trans-unit</p>", (String)xml);
        XLIFF12ParserTest.assertContains((String)"<p lang=\"fr\">Un autre trans-unit</p>", (String)xml);
    }
}

