/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.strings;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.parser.strings.Latin1StringsParser;
import org.apache.tika.sax.BodyContentHandler;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.xml.sax.ContentHandler;

public class Latin1StringsParserTest {
    @Test
    public void testParse() throws Exception {
        String testStr = "These are Latin1 accented scripts: \u00c2 \u00c3 \u00c9 \u00dc \u00e2 \u00e3 \u00e9 \u00fc";
        String smallStr = "ab";
        byte[] iso8859Bytes = testStr.getBytes(StandardCharsets.ISO_8859_1);
        byte[] utf8Bytes = testStr.getBytes(StandardCharsets.UTF_8);
        byte[] utf16Bytes = testStr.getBytes(StandardCharsets.UTF_16);
        byte[] zeros = new byte[10];
        byte[] smallString = smallStr.getBytes(StandardCharsets.ISO_8859_1);
        byte[] trashBytes = new byte[]{0, 1, 2, 3, 30, 31, -1};
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        baos.write(iso8859Bytes);
        baos.write(zeros);
        baos.write(utf8Bytes);
        baos.write(trashBytes);
        baos.write(utf16Bytes);
        baos.write(zeros);
        baos.write(smallString);
        Latin1StringsParser parser = new Latin1StringsParser();
        BodyContentHandler handler = new BodyContentHandler();
        try (ByteArrayInputStream stream = new ByteArrayInputStream(baos.toByteArray());){
            parser.parse((InputStream)stream, (ContentHandler)handler, new Metadata(), new ParseContext());
        }
        String result = handler.toString();
        String expected = testStr + "\n" + testStr + "\n" + testStr + "\n";
        Assertions.assertTrue((boolean)result.equals(expected));
    }
}

