/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.csv;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.tika.TikaTest;
import org.apache.tika.mime.MediaType;
import org.apache.tika.parser.csv.CSVResult;
import org.apache.tika.parser.csv.CSVSniffer;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class CSVSnifferTest
extends TikaTest {
    private static char[] DELIMITERS = new char[]{',', '\t'};
    private static byte[] CSV_BASIC = "the,quick,brown\tfox\njumped \tover,the\tlazy,\tdog\nand then,ran,down\tthe\tstreet".getBytes(StandardCharsets.UTF_8);
    private static byte[] TSV_BASIC = "the\tquick\tbrown,fox\njumped ,over\tthe,lazy\t,dog\nand then\tran\tdown,the,street".getBytes(StandardCharsets.UTF_8);
    private static byte[] CSV_MID_CELL_QUOTE_EXCEPTION = "the,quick,brown\"fox\njumped over,the lazy,dog\nand then,ran,down the street".getBytes(StandardCharsets.UTF_8);
    private static byte[] ALLOW_SPACES_BEFORE_QUOTE = "the,quick,         \"brown\"\"fox\"\njumped over,the lazy,dog\nand then,ran,down the street".getBytes(StandardCharsets.UTF_8);
    private static byte[] ALLOW_SPACES_AFTER_QUOTE = "the,\"quick\"     ,brown  fox\njumped over,the lazy,dog\nand then,ran,down the street".getBytes(StandardCharsets.UTF_8);

    private static List<CSVResult> sniff(char[] delimiters, byte[] bytes, Charset charset) throws IOException {
        CSVSniffer sniffer = new CSVSniffer(delimiters);
        try (BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new ByteArrayInputStream(bytes), charset));){
            List list = sniffer.sniff((Reader)reader);
            return list;
        }
    }

    @Test
    public void testCSVBasic() throws Exception {
        List<CSVResult> results = CSVSnifferTest.sniff(DELIMITERS, CSV_BASIC, StandardCharsets.UTF_8);
        Assertions.assertEquals((int)2, (int)results.size());
        Assertions.assertEquals((Character)Character.valueOf(','), (Character)results.get(0).getDelimiter());
        results = CSVSnifferTest.sniff(DELIMITERS, TSV_BASIC, StandardCharsets.UTF_8);
        Assertions.assertEquals((int)2, (int)results.size());
        Assertions.assertEquals((Character)Character.valueOf('\t'), (Character)results.get(0).getDelimiter());
    }

    @Test
    public void testCSVMidCellQuoteException() throws Exception {
        List<CSVResult> results = CSVSnifferTest.sniff(DELIMITERS, CSV_MID_CELL_QUOTE_EXCEPTION, StandardCharsets.UTF_8);
        Assertions.assertEquals((int)2, (int)results.size());
    }

    @Test
    public void testAllowWhiteSpacesAroundAQuote() throws Exception {
        List<CSVResult> results = CSVSnifferTest.sniff(DELIMITERS, ALLOW_SPACES_BEFORE_QUOTE, StandardCharsets.UTF_8);
        Assertions.assertEquals((int)2, (int)results.size());
        Assertions.assertEquals((Character)Character.valueOf(','), (Character)results.get(0).getDelimiter());
        results = CSVSnifferTest.sniff(DELIMITERS, ALLOW_SPACES_AFTER_QUOTE, StandardCharsets.UTF_8);
        Assertions.assertEquals((int)2, (int)results.size());
        Assertions.assertEquals((Character)Character.valueOf(','), (Character)results.get(0).getDelimiter());
    }

    @Test
    public void testSort() {
        ArrayList<CSVResult> list = new ArrayList<CSVResult>();
        list.add(new CSVResult(0.1, MediaType.TEXT_HTML, Character.valueOf('-')));
        list.add(new CSVResult(0.2, MediaType.TEXT_PLAIN, Character.valueOf(',')));
        Collections.sort(list);
        Assertions.assertEquals((double)0.2, (double)((CSVResult)list.get(0)).getConfidence(), (double)1.0E-5);
    }
}

