/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.txt;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.nio.file.Files;
import org.apache.tika.TikaTest;
import org.apache.tika.config.TikaConfig;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.parser.AutoDetectParser;
import org.apache.tika.parser.Parser;
import org.apache.tika.parser.txt.CharsetDetector;
import org.apache.tika.parser.txt.CharsetMatch;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class CharsetDetectorTest
extends TikaTest {
    @Test
    public void testTagDropper() throws IOException {
        try (InputStream in = this.getResourceAsStream("/test-documents/resume.html");){
            CharsetDetector detector = new CharsetDetector();
            detector.enableInputFilter(true);
            detector.setText(in);
            CharsetMatch[] matches = detector.detectAll();
            CharsetMatch mm = null;
            for (CharsetMatch m : matches) {
                if (mm != null && mm.getConfidence() >= m.getConfidence()) continue;
                mm = m;
            }
            Assertions.assertTrue((mm != null ? 1 : 0) != 0);
            Assertions.assertEquals((Object)"UTF-8", (Object)mm.getName());
        }
    }

    @Test
    public void testEmptyOrNullDeclaredCharset() throws IOException {
        try (InputStream in = this.getResourceAsStream("/test-documents/resume.html");){
            CharsetDetector detector = new CharsetDetector();
            Reader reader = detector.getReader(in, null);
            Assertions.assertTrue((boolean)reader.ready());
            reader = detector.getReader(in, "");
            Assertions.assertTrue((boolean)reader.ready());
        }
    }

    @Test
    public void testWin125XHeuristics() throws Exception {
        CharsetDetector detector = new CharsetDetector();
        try (InputStream is = this.getResourceAsStream("/test-documents/testTXT_win-1252.txt");){
            detector.setText(is);
        }
        CharsetMatch charset = detector.detect();
        Assertions.assertEquals((Object)"windows-1252", (Object)charset.getName());
    }

    @Test
    public void testSetTextConsistency() throws Exception {
        File file = this.getResourceAsFile("/test-documents/multi-language.txt");
        byte[] fileBytes = Files.readAllBytes(file.toPath());
        ByteArrayInputStream fileStream = new ByteArrayInputStream(fileBytes);
        CharsetDetector fromBytesDetector = new CharsetDetector();
        fromBytesDetector.setText(fileBytes);
        CharsetDetector fromStreamDetector = new CharsetDetector();
        fromStreamDetector.setText((InputStream)fileStream);
        Assertions.assertEquals((Object)"ISO-8859-1", (Object)fromBytesDetector.detect().getName());
        Assertions.assertEquals((Object)"ISO-8859-1", (Object)fromStreamDetector.detect().getName());
    }

    @Test
    public void testZeroLength() throws Exception {
        CharsetDetector detector = new CharsetDetector();
        detector.setText(new byte[0]);
        Assertions.assertEquals((Object)"UTF-8", (Object)detector.detect().getName());
    }

    @Test
    public void testLengthResetCorrectly() throws IOException {
        int i;
        String computer = "\u0627\u0644\u062d\u0627\u0633\u0648\u0628";
        StringBuilder sb = new StringBuilder();
        CharsetDetector detector = new CharsetDetector();
        for (i = 0; i < 5000; ++i) {
            sb.append(computer);
        }
        detector.setText(sb.toString().getBytes("windows-1256"));
        Assertions.assertEquals((Object)"windows-1256", (Object)detector.detect().getName());
        sb.setLength(0);
        for (i = 0; i < 5; ++i) {
            sb.append(computer);
        }
        detector.setText(sb.toString().getBytes("UTF-8"));
        Assertions.assertEquals((Object)"UTF-8", (Object)detector.detect().getName());
    }

    @Test
    public void testIgnoreCharset() throws Exception {
        TikaConfig tikaConfig = new TikaConfig(this.getResourceAsStream("/test-configs/tika-config-ignore-charset.xml"));
        Metadata m = new Metadata();
        m.set("resourceName", "texty-text.txt");
        CharsetDetectorTest.assertContains((String)"ACTIVE AGE", (String)this.getXML((String)"testIgnoreCharset.txt", (Parser)new AutoDetectParser((TikaConfig)tikaConfig), (Metadata)m).xml);
    }
}

