/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.strings;

import java.io.InputStream;
import java.util.Arrays;
import java.util.Collections;
import org.apache.tika.config.Initializable;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.parser.external.ExternalParser;
import org.apache.tika.parser.strings.StringsConfig;
import org.apache.tika.parser.strings.StringsParser;
import org.apache.tika.sax.BodyContentHandler;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Assumptions;
import org.junit.jupiter.api.Test;
import org.xml.sax.ContentHandler;

public class StringsParserTest {
    public static boolean canRun() {
        String[] checkCmd = new String[]{new StringsParser().getStringsPath() + StringsParser.getStringsProg(), "--version"};
        return ExternalParser.check((String[])checkCmd, (int[])new int[0]);
    }

    @Test
    public void testParse() throws Exception {
        Assumptions.assumeTrue((boolean)StringsParserTest.canRun());
        String resource = "/test-documents/testOCTET_header.dbase3";
        String[] content = new String[]{"CLASSNO", "TITLE", "ITEMNO", "LISTNO", "LISTDATE"};
        Object[] met_attributes = new String[]{"min-len", "encoding", "strings:file_output"};
        StringsConfig stringsConfig = new StringsConfig();
        StringsParser parser = new StringsParser();
        ((Initializable)parser).initialize(Collections.emptyMap());
        BodyContentHandler handler = new BodyContentHandler();
        Metadata metadata = new Metadata();
        ParseContext context = new ParseContext();
        context.set(StringsConfig.class, (Object)stringsConfig);
        try (InputStream stream = StringsParserTest.class.getResourceAsStream(resource);){
            parser.parse(stream, (ContentHandler)handler, metadata, context);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        for (String word : content) {
            Assertions.assertTrue((boolean)handler.toString().contains(word), (String)("can't find " + word));
        }
        Arrays.equals(met_attributes, metadata.names());
    }
}

