/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.strings;

import java.io.InputStream;
import org.apache.tika.config.TikaConfig;
import org.apache.tika.parser.CompositeParser;
import org.apache.tika.parser.strings.StringsConfig;
import org.apache.tika.parser.strings.StringsEncoding;
import org.apache.tika.parser.strings.StringsParser;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class StringsConfigTest {
    @Test
    public void testNoConfig() {
        StringsConfig config = new StringsConfig();
        Assertions.assertEquals((Object)StringsEncoding.SINGLE_7_BIT, (Object)config.getEncoding(), (String)"Invalid default encoding value");
        Assertions.assertEquals((int)4, (int)config.getMinLength(), (String)"Invalid default min-len value");
        Assertions.assertEquals((int)120, (int)config.getTimeoutSeconds(), (String)"Invalid default timeout value");
    }

    @Test
    public void testPartialConfig() throws Exception {
        TikaConfig tikaConfig = null;
        try (InputStream stream = StringsConfigTest.class.getResourceAsStream("/test-configs/tika-config-strings-partial.xml");){
            tikaConfig = new TikaConfig(stream);
        }
        StringsParser p = (StringsParser)((CompositeParser)tikaConfig.getParser()).getAllComponentParsers().get(0);
        Assertions.assertEquals((Object)StringsEncoding.BIGENDIAN_16_BIT, (Object)p.getStringsEncoding(), (String)"Invalid overridden encoding value");
        Assertions.assertEquals((int)4, (int)p.getMinLength(), (String)"Invalid default min-len value");
        Assertions.assertEquals((int)60, (int)p.getTimeoutSeconds(), (String)"Invalid overridden timeout value");
    }

    @Test
    public void testFullConfig() throws Exception {
        TikaConfig tikaConfig = null;
        try (InputStream stream = StringsConfigTest.class.getResourceAsStream("/test-configs/tika-config-strings-full.xml");){
            tikaConfig = new TikaConfig(stream);
        }
        StringsParser p = (StringsParser)((CompositeParser)tikaConfig.getParser()).getAllComponentParsers().get(0);
        Assertions.assertEquals((Object)StringsEncoding.BIGENDIAN_16_BIT, (Object)p.getStringsEncoding(), (String)"Invalid overridden encoding value");
        Assertions.assertEquals((int)3, (int)p.getMinLength(), (String)"Invalid overridden min-len value");
        Assertions.assertEquals((int)60, (int)p.getTimeoutSeconds(), (String)"Invalid overridden timeout value");
    }

    @Test
    public void testValidateEconding() {
        StringsConfig config = new StringsConfig();
        Assertions.assertThrows(IllegalArgumentException.class, () -> config.setMinLength(0));
    }
}

