/*
 * Decompiled with CFR 0.152.
 */
package ucar.coord;

import java.util.ArrayList;
import java.util.Formatter;
import java.util.HashMap;
import java.util.List;
import ucar.coord.Coordinate;
import ucar.coord.CoordinateBuilder;
import ucar.coord.Counter;
import ucar.coord.SparseArray;
import ucar.ma2.Section;
import ucar.nc2.util.Indent;

public class CoordinateND<T> {
    private List<CoordinateBuilder<T>> builders;
    private List<Coordinate> coordinates;
    private SparseArray<T> sa;

    public CoordinateND() {
        this.builders = new ArrayList<CoordinateBuilder<T>>();
    }

    public void addBuilder(CoordinateBuilder<T> builder) {
        this.builders.add(builder);
    }

    public void addRecord(T gr) {
        for (CoordinateBuilder<T> builder : this.builders) {
            builder.addRecord(gr);
        }
    }

    public void finish(List<T> records, Formatter info) {
        this.coordinates = new ArrayList<Coordinate>();
        for (CoordinateBuilder<T> builder : this.builders) {
            Coordinate coord = builder.finish();
            this.coordinates.add(coord);
        }
        this.buildSparseArray(records, info);
    }

    public void buildSparseArray(List<T> records, Formatter info) {
        int[] sizeArray = new int[this.coordinates.size()];
        for (int i = 0; i < this.coordinates.size(); ++i) {
            sizeArray[i] = this.coordinates.get(i).getSize();
        }
        this.sa = new SparseArray(sizeArray);
        int[] index = new int[this.coordinates.size()];
        for (T gr : records) {
            int count = 0;
            for (CoordinateBuilder<T> builder : this.builders) {
                index[count++] = builder.getIndex(gr);
            }
            this.sa.add(gr, info, index);
        }
    }

    public List<Coordinate> getCoordinates() {
        return this.coordinates;
    }

    public int getNCoordinates() {
        return this.coordinates.size();
    }

    public SparseArray<T> getSparseArray() {
        return this.sa;
    }

    public void showInfo(List<T> records, Formatter info) {
        if (this.sa == null) {
            this.buildSparseArray(records, info);
        }
        for (Coordinate coord : this.coordinates) {
            coord.showInfo(info, new Indent(2));
        }
        info.format("%n%n", new Object[0]);
        this.sa.showInfo(info, null);
        info.format("%n", new Object[0]);
    }

    public void showInfo(Formatter info, Counter all) {
        for (Coordinate coord : this.coordinates) {
            coord.showInfo(info, new Indent(2));
        }
        if (this.sa != null) {
            this.sa.showInfo(info, all);
        }
    }

    public CoordinateND(List<Coordinate> coordinates, SparseArray<T> sa) {
        this.coordinates = coordinates;
        this.sa = sa;
    }

    public CoordinateND(List<Coordinate> coordinates) {
        this.coordinates = coordinates;
        int[] sizeArray = new int[coordinates.size()];
        for (int i = 0; i < coordinates.size(); ++i) {
            sizeArray[i] = coordinates.get(i).getSize();
        }
        this.sa = new SparseArray(sizeArray);
    }

    public void reindex(CoordinateND<T> prev) {
        this.sa.setContent(prev.getSparseArray().getContent());
        List<Coordinate> prevCoords = prev.getCoordinates();
        ArrayList<IndexMap> indexMaps = new ArrayList<IndexMap>();
        int count = 0;
        for (Coordinate curr : this.coordinates) {
            indexMaps.add(new IndexMap(curr, prevCoords.get(count++)));
        }
        int[] currIndex = new int[this.coordinates.size()];
        int[] prevIndex = new int[this.coordinates.size()];
        int[] track = new int[this.sa.getTotalSize()];
        SparseArray<T> prevSa = prev.getSparseArray();
        Section section = new Section(prevSa.getShape());
        Section.Iterator iter = section.getIterator(prevSa.getShape());
        while (iter.hasNext()) {
            int oldTrackIdx = iter.next(prevIndex);
            int oldTrackValue = prevSa.getTrack(oldTrackIdx);
            if (oldTrackValue == 0) continue;
            int coordIdx = 0;
            for (IndexMap indexMap : indexMaps) {
                currIndex[coordIdx] = indexMap.map(prevIndex[coordIdx]);
                ++coordIdx;
            }
            int trackIdx = this.sa.calcIndex(currIndex);
            track[trackIdx] = oldTrackValue;
        }
        this.sa.setTrack(track);
    }

    private class IndexMap {
        boolean identity = true;
        int[] indexMap;

        IndexMap(Coordinate curr, Coordinate prev) {
            this.identity = curr.equals(prev);
            if (this.identity) {
                return;
            }
            assert (curr.getType() == prev.getType());
            int count = 0;
            HashMap<Object, Integer> currValMap = new HashMap<Object, Integer>();
            for (Object object : curr.getValues()) {
                currValMap.put(object, count++);
            }
            count = 0;
            this.indexMap = new int[prev.getSize()];
            for (Object object : prev.getValues()) {
                this.indexMap[count++] = (Integer)currValMap.get(object);
            }
        }

        int map(int oldIndex) {
            if (this.identity) {
                return oldIndex;
            }
            return this.indexMap[oldIndex];
        }
    }
}

