/*
 * Decompiled with CFR 0.152.
 */
package org.quartz.impl.jdbcjobstore;

import jakarta.transaction.Synchronization;
import jakarta.transaction.SystemException;
import jakarta.transaction.Transaction;
import jakarta.transaction.TransactionManager;
import java.sql.Connection;
import java.util.HashSet;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.quartz.impl.jdbcjobstore.LockException;
import org.quartz.impl.jdbcjobstore.Semaphore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JTANonClusteredSemaphore
implements Semaphore {
    public static final String DEFAULT_TRANSACTION_MANAGER_LOCATION = "java:TransactionManager";
    final ThreadLocal<HashSet<String>> lockOwners = new ThreadLocal();
    final HashSet<String> locks = new HashSet();
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private String transactionManagerJNDIName = "java:TransactionManager";

    protected Logger getLog() {
        return this.log;
    }

    public void setTransactionManagerJNDIName(String transactionManagerJNDIName) {
        this.transactionManagerJNDIName = transactionManagerJNDIName;
    }

    private HashSet<String> getThreadLocks() {
        HashSet<String> threadLocks = this.lockOwners.get();
        if (threadLocks == null) {
            threadLocks = new HashSet();
            this.lockOwners.set(threadLocks);
        }
        return threadLocks;
    }

    @Override
    public synchronized boolean obtainLock(Connection conn, String lockName) throws LockException {
        lockName = lockName.intern();
        if (this.log.isDebugEnabled()) {
            this.log.debug("Lock '{}' is desired by: {}", (Object)lockName, (Object)Thread.currentThread().getName());
        }
        if (!this.isLockOwner(conn, lockName)) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Lock '{}' is being obtained: {}", (Object)lockName, (Object)Thread.currentThread().getName());
            }
            while (this.locks.contains(lockName)) {
                try {
                    this.wait();
                }
                catch (InterruptedException ie) {
                    if (!this.log.isDebugEnabled()) continue;
                    this.log.debug("Lock '{}' was not obtained by: {}", (Object)lockName, (Object)Thread.currentThread().getName());
                }
            }
            Transaction t = this.getTransaction();
            if (t != null) {
                try {
                    t.registerSynchronization((Synchronization)new SemaphoreSynchronization(lockName));
                }
                catch (Exception e) {
                    throw new LockException("Failed to register semaphore with Transaction.", e);
                }
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug("Lock '{}' given to: {}", (Object)lockName, (Object)Thread.currentThread().getName());
            }
            this.getThreadLocks().add(lockName);
            this.locks.add(lockName);
        } else if (this.log.isDebugEnabled()) {
            this.log.debug("Lock '{}' already owned by: {} -- but not owner!", lockName, Thread.currentThread().getName(), new Exception("stack-trace of wrongful returner"));
        }
        return true;
    }

    protected Transaction getTransaction() throws LockException {
        InitialContext ic = null;
        try {
            ic = new InitialContext();
            TransactionManager tm = (TransactionManager)ic.lookup(this.transactionManagerJNDIName);
            Transaction transaction = tm.getTransaction();
            return transaction;
        }
        catch (SystemException e) {
            throw new LockException("Failed to get Transaction from TransactionManager", e);
        }
        catch (NamingException e) {
            throw new LockException("Failed to find TransactionManager in JNDI under name: " + this.transactionManagerJNDIName, e);
        }
        finally {
            if (ic != null) {
                try {
                    ic.close();
                }
                catch (NamingException namingException) {}
            }
        }
    }

    @Override
    public synchronized void releaseLock(String lockName) throws LockException {
        this.releaseLock(lockName, false);
    }

    protected synchronized void releaseLock(String lockName, boolean fromSynchronization) throws LockException {
        if (this.isLockOwner(null, lockName = lockName.intern())) {
            Transaction t;
            if (!fromSynchronization && (t = this.getTransaction()) != null) {
                if (this.getLog().isDebugEnabled()) {
                    this.getLog().debug("Lock '{}' is in a JTA transaction.  Return deferred by: {}", (Object)lockName, (Object)Thread.currentThread().getName());
                }
                return;
            }
            if (this.getLog().isDebugEnabled()) {
                this.getLog().debug("Lock '{}' returned by: {}", (Object)lockName, (Object)Thread.currentThread().getName());
            }
            this.getThreadLocks().remove(lockName);
            this.locks.remove(lockName);
            this.notify();
        } else if (this.getLog().isDebugEnabled()) {
            this.getLog().debug("Lock '{}' attempt to return by: {} -- but not owner!", lockName, Thread.currentThread().getName(), new Exception("stack-trace of wrongful returner"));
        }
    }

    public synchronized boolean isLockOwner(Connection conn, String lockName) {
        lockName = lockName.intern();
        return this.getThreadLocks().contains(lockName);
    }

    @Override
    public boolean requiresConnection() {
        return false;
    }

    private class SemaphoreSynchronization
    implements Synchronization {
        private final String lockName;

        public SemaphoreSynchronization(String lockName) {
            this.lockName = lockName;
        }

        public void beforeCompletion() {
        }

        public void afterCompletion(int status) {
            try {
                JTANonClusteredSemaphore.this.releaseLock(this.lockName, true);
            }
            catch (LockException lockException) {
                // empty catch block
            }
        }
    }
}

