/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.util.internal;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.MathContext;
import java.util.Arrays;
import org.apache.sis.math.DecimalFunctions;
import org.apache.sis.math.Fraction;
import org.apache.sis.math.MathFunctions;
import org.apache.sis.util.internal.Numerics;

public final class DoubleDouble
extends Number
implements Comparable<DoubleDouble> {
    private static final long serialVersionUID = -7602414219228638550L;
    public static final boolean DISABLED = false;
    private static final int ZERO_THRESHOLD = 2;
    private static final double[] VALUES = new double[]{4.84813681109536E-6, 2.777777777777778E-4, 0.002777777777777778, 0.016666666666666666, Math.PI / 180, 0.7853981633974483, 1.1111111111111112, 1.4142135623730951, 1.5707963267948966, 2.356194490192345, Math.PI, Math.PI * 2, 57.29577951308232};
    private static final double[] ERRORS = new double[]{9.320078015422868E-23, 2.4093381610788987E-22, -1.0601087908747154E-19, 2.312964634635743E-19, 2.9486522708701687E-19, 3.061616997868383E-17, -4.9343245538895844E-17, -9.667293313452913E-17, 6.123233995736766E-17, 9.184850993605148E-17, 1.2246467991473532E-16, 2.4492935982947064E-16, -1.9878495670576283E-15};
    public static final DoubleDouble ZERO = new DoubleDouble(0.0, 0.0);
    public static final DoubleDouble ONE = new DoubleDouble(1.0, 0.0);
    public static final DoubleDouble PI = new DoubleDouble(Math.PI, 1.2246467991473532E-16);
    public static final DoubleDouble RADIANS_TO_DEGREES = new DoubleDouble(57.29577951308232, -1.9878495670576283E-15);
    public static final DoubleDouble DEGREES_TO_RADIANS = new DoubleDouble(Math.PI / 180, 2.9486522708701687E-19);
    public static final DoubleDouble SECONDS_TO_RADIANS = new DoubleDouble(4.84813681109536E-6, 9.320078015422868E-23);
    public static final DoubleDouble NaN = new DoubleDouble(Double.NaN, Double.NaN);
    public final double value;
    public final double error;

    private DoubleDouble(double value, double error) {
        this.value = value;
        this.error = error;
        assert (!(Math.abs(error) >= Math.ulp(value))) : this;
    }

    public static DoubleDouble of(Number value, boolean decimal) {
        if (value == null) {
            return null;
        }
        if (value instanceof DoubleDouble) {
            return (DoubleDouble)value;
        }
        if (value instanceof Fraction) {
            Fraction f = (Fraction)value;
            return new DoubleDouble(f.numerator, 0.0).divide(f.denominator);
        }
        if (value instanceof Float) {
            float f = ((Float)value).floatValue();
            value = decimal ? DecimalFunctions.floatToDouble(f) : (double)f;
        } else if (value instanceof BigInteger) {
            value = new BigDecimal((BigInteger)value, MathContext.DECIMAL128);
        }
        double v = value.doubleValue();
        double error = value instanceof Integer ? 0.0 : (value instanceof Long ? (double)(value.longValue() - (long)v) : (value instanceof BigDecimal ? ((BigDecimal)value).subtract(new BigDecimal(v), MathContext.DECIMAL64).doubleValue() : (decimal ? DoubleDouble.errorForWellKnownValue(v) : 0.0)));
        return new DoubleDouble(v, error);
    }

    public static DoubleDouble of(int value) {
        return new DoubleDouble(value, 0.0);
    }

    public static DoubleDouble of(long value) {
        double f = value;
        return new DoubleDouble(f, value - (long)f);
    }

    public static DoubleDouble of(double value, boolean decimal) {
        return new DoubleDouble(value, decimal ? DoubleDouble.errorForWellKnownValue(value) : 0.0);
    }

    public static DoubleDouble of(double value, double error) {
        return new DoubleDouble(value, error);
    }

    @Override
    public double doubleValue() {
        return this.value + this.error;
    }

    @Override
    public float floatValue() {
        return (float)this.doubleValue();
    }

    @Override
    public int intValue() {
        return Numerics.clamp(this.longValue());
    }

    @Override
    public long longValue() {
        return Numerics.saturatingAdd(Math.round(this.value), (long)this.error);
    }

    static double errorForWellKnownValue(double value) {
        double error;
        int i = Arrays.binarySearch(VALUES, Math.abs(value));
        if (i >= 0) {
            error = MathFunctions.xorSign(ERRORS[i], value);
        } else {
            double delta = DecimalFunctions.deltaForDoubleToDecimal(value);
            double d = error = Double.isNaN(delta) ? 0.0 : delta;
        }
        assert (!(Math.abs(error) >= Math.ulp(value))) : value;
        return error;
    }

    public boolean isZero() {
        return this.value == 0.0 && this.error == 0.0;
    }

    public boolean isNaN() {
        return Double.isNaN(this.value) || Double.isNaN(this.error);
    }

    static DoubleDouble quickSum(double a, double b) {
        double value = a + b;
        return new DoubleDouble(value, b - (value - a));
    }

    public static DoubleDouble sum(double a, double b) {
        double value = a + b;
        double v = value - a;
        return new DoubleDouble(value, a - (value - v) + (b - v));
    }

    public static DoubleDouble product(double a, double b) {
        double value = a * b;
        return new DoubleDouble(value, Math.fma(a, b, -value));
    }

    public DoubleDouble inverse() {
        return ONE.divide(this);
    }

    public DoubleDouble negate() {
        return new DoubleDouble(-this.value, -this.error);
    }

    public DoubleDouble add(DoubleDouble other) {
        return this.add(other.value, other.error);
    }

    public DoubleDouble add(Number other, boolean decimal) {
        return this.add(DoubleDouble.of(other, decimal));
    }

    public DoubleDouble add(int other) {
        return this.add((double)other, 0.0);
    }

    public DoubleDouble add(long other) {
        return this.add(DoubleDouble.of(other));
    }

    public DoubleDouble add(double other, boolean decimal) {
        return this.add(other, decimal ? DoubleDouble.errorForWellKnownValue(other) : 0.0);
    }

    private DoubleDouble add(double otherValue, double otherError) {
        double s = this.value + otherValue;
        double v = s - this.value;
        double e = this.value - (s - v) + (otherValue - v) + (this.error + otherError);
        if (s == 0.0 && e != 0.0 && Math.abs(e) <= Math.scalb(Math.ulp(otherValue), -50)) {
            return new DoubleDouble(s, 0.0);
        }
        return DoubleDouble.quickSum(s, e);
    }

    public DoubleDouble subtract(DoubleDouble other) {
        return this.add(-other.value, -other.error);
    }

    public DoubleDouble subtract(Number other, boolean decimal) {
        return this.subtract(DoubleDouble.of(other, decimal));
    }

    public DoubleDouble subtract(int other) {
        return this.add(-((double)other), 0.0);
    }

    public DoubleDouble subtract(long other) {
        return this.subtract(DoubleDouble.of(other));
    }

    public DoubleDouble subtract(double other, boolean decimal) {
        other = -other;
        return this.add(other, decimal ? DoubleDouble.errorForWellKnownValue(other) : 0.0);
    }

    public DoubleDouble multiply(DoubleDouble other) {
        return this.multiply(other.value, other.error);
    }

    public DoubleDouble multiply(Number other, boolean decimal) {
        return this.multiply(DoubleDouble.of(other, decimal));
    }

    public DoubleDouble multiply(int other) {
        return this.multiply((double)other, 0.0);
    }

    public DoubleDouble multiply(long other) {
        return this.multiply(DoubleDouble.of(other));
    }

    public DoubleDouble multiply(double other, boolean decimal) {
        return this.multiply(other, decimal ? DoubleDouble.errorForWellKnownValue(other) : 0.0);
    }

    private DoubleDouble multiply(double otherValue, double otherError) {
        double v = this.value * otherValue;
        double e = Math.fma(this.value, otherValue, -v);
        e = Math.fma(otherError, this.value, e);
        e = Math.fma(otherValue, this.error, e);
        return DoubleDouble.quickSum(v, e);
    }

    public DoubleDouble divide(DoubleDouble other) {
        return this.divide(other.value, other.error);
    }

    public DoubleDouble divide(Number other, boolean decimal) {
        return this.divide(DoubleDouble.of(other, decimal));
    }

    public DoubleDouble divide(int other) {
        return this.divide((double)other, 0.0);
    }

    public DoubleDouble divide(long other) {
        return this.divide(DoubleDouble.of(other));
    }

    public DoubleDouble divide(double other, boolean decimal) {
        return this.divide(other, decimal ? DoubleDouble.errorForWellKnownValue(other) : 0.0);
    }

    private DoubleDouble divide(double otherValue, double otherError) {
        double quotient = this.value / otherValue;
        double pe = Math.fma(quotient, otherValue, -this.value);
        pe = Math.fma(quotient, otherError, pe);
        double pv = this.value + pe;
        double s = this.value - pv;
        double v = s - this.value;
        double e = this.value - (s - v) - (pv + v) + (this.error - (pe += s));
        return DoubleDouble.quickSum(quotient, (s + e) / otherValue);
    }

    public DoubleDouble ratio_1m_1p() {
        return ONE.subtract(this).divide(this.add(1));
    }

    public DoubleDouble scalb(int n) {
        return new DoubleDouble(Math.scalb(this.value, n), Math.scalb(this.error, n));
    }

    public DoubleDouble square() {
        return this.multiply(this.value, this.error);
    }

    public DoubleDouble sqrt() {
        if (this.value == 0.0) {
            return ZERO;
        }
        double r = Math.sqrt(this.value);
        DoubleDouble t = DoubleDouble.product(r, r);
        t = t.subtract(this);
        t = t.divide(-2.0 * r, 0.0);
        return DoubleDouble.quickSum(r, t.value);
    }

    public DoubleDouble series(double ... coefficients) {
        DoubleDouble sum = new DoubleDouble(coefficients[0], 0.0);
        DoubleDouble xn = this;
        for (int i = 1; i < coefficients.length; ++i) {
            sum = sum.add(xn.multiply(coefficients[i], 0.0));
            xn = this.multiply(xn);
        }
        return sum;
    }

    @Override
    public int compareTo(DoubleDouble other) {
        int c = Double.compare(this.value, other.value);
        if (c == 0) {
            c = Double.compare(this.error, other.error);
        }
        return c;
    }

    public boolean equals(Object obj) {
        if (obj instanceof DoubleDouble) {
            DoubleDouble other = (DoubleDouble)obj;
            return Numerics.equals(this.value, other.value) && Numerics.equals(this.error, other.error);
        }
        return false;
    }

    public int hashCode() {
        return Long.hashCode(Double.doubleToLongBits(this.value) ^ Double.doubleToLongBits(this.error));
    }

    public String toString() {
        return Double.toString(this.doubleValue());
    }
}

