/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.util;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.measure.Unit;
import javax.measure.quantity.Angle;
import org.apache.sis.measure.Units;
import org.apache.sis.metadata.internal.NameToIdentifier;
import org.apache.sis.referencing.util.AxesMapper;
import org.apache.sis.util.ArraysExt;
import org.apache.sis.util.CharSequences;
import org.apache.sis.util.Characters;
import org.apache.sis.util.ComparisonMode;
import org.apache.sis.util.Static;
import org.apache.sis.util.Utilities;
import org.apache.sis.util.iso.Types;
import org.opengis.annotation.Obligation;
import org.opengis.annotation.Specification;
import org.opengis.annotation.UML;
import org.opengis.referencing.cs.AxisDirection;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.referencing.cs.CoordinateSystemAxis;

public final class AxisDirections
extends Static {
    public static final int COMPASS_COUNT = 16;
    public static final int GEOCENTRIC_COUNT = 3;
    public static final int DISPLAY_COUNT = 4;
    private static final int LAST_ORDINAL = AxisDirection.DISPLAY_DOWN.ordinal();
    @UML(identifier="forward", obligation=Obligation.CONDITIONAL, specification=Specification.UNSPECIFIED)
    public static final AxisDirection FORWARD = AxisDirection.valueOf("FORWARD");
    @UML(identifier="starboard", obligation=Obligation.CONDITIONAL, specification=Specification.UNSPECIFIED)
    public static final AxisDirection STARBOARD = AxisDirection.valueOf("STARBOARD");
    @UML(identifier="clockwise", obligation=Obligation.CONDITIONAL, specification=Specification.UNSPECIFIED)
    public static final AxisDirection CLOCKWISE = AxisDirection.valueOf("CLOCKWISE");
    @UML(identifier="counterClockwise", obligation=Obligation.CONDITIONAL, specification=Specification.UNSPECIFIED)
    public static final AxisDirection COUNTER_CLOCKWISE = AxisDirection.valueOf("COUNTER_CLOCKWISE");
    @UML(identifier="awayFrom", obligation=Obligation.CONDITIONAL, specification=Specification.UNSPECIFIED)
    public static final AxisDirection AWAY_FROM = AxisDirection.valueOf("AWAY_FROM");
    private static final Map<AxisDirection, AxisDirection> OPPOSITES = new HashMap<AxisDirection, AxisDirection>(20);
    private static final Map<AxisDirection, String> ABBREVIATIONS;
    private static final byte[] DISPLAY_ORDER;

    private static void put(AxisDirection dir, AxisDirection opposite) {
        OPPOSITES.put(dir, opposite);
        OPPOSITES.put(opposite, dir);
    }

    private AxisDirections() {
    }

    public static AxisDirection absolute(AxisDirection dir) {
        AxisDirection opposite = AxisDirections.opposite(dir);
        if (opposite != null) {
            if (opposite.ordinal() < dir.ordinal()) {
                dir = opposite;
            }
            if (dir == CLOCKWISE) {
                dir = COUNTER_CLOCKWISE;
            }
        }
        return dir;
    }

    public static AxisDirection opposite(AxisDirection dir) {
        return OPPOSITES.get(dir);
    }

    public static boolean isOpposite(AxisDirection dir) {
        AxisDirection opposite = AxisDirections.opposite(dir);
        return opposite != null && opposite.ordinal() < dir.ordinal();
    }

    public static boolean isCompass(AxisDirection dir) {
        if (dir == null) {
            return false;
        }
        int n = dir.ordinal() - AxisDirection.NORTH.ordinal();
        return n >= 0 && n < 16;
    }

    public static boolean isCardinal(AxisDirection dir) {
        if (dir == null) {
            return false;
        }
        int n = dir.ordinal() - AxisDirection.NORTH.ordinal();
        return n >= 0 && n < 16 && (n & 3) == 0;
    }

    public static boolean isIntercardinal(AxisDirection dir) {
        if (dir == null) {
            return false;
        }
        int n = dir.ordinal() - AxisDirection.NORTH.ordinal();
        return n >= 0 && n < 16 && (n & 3) != 0;
    }

    public static boolean isVertical(AxisDirection dir) {
        if (dir == null) {
            return false;
        }
        return (dir.ordinal() - AxisDirection.UP.ordinal() & 0xFFFFFFFE) == 0;
    }

    public static boolean isTemporal(AxisDirection dir) {
        if (dir == null) {
            return false;
        }
        return (dir.ordinal() - AxisDirection.FUTURE.ordinal() & 0xFFFFFFFE) == 0;
    }

    public static boolean isGeocentric(AxisDirection dir) {
        if (dir == null) {
            return false;
        }
        int ordinal = dir.ordinal();
        return ordinal >= AxisDirection.GEOCENTRIC_X.ordinal() && ordinal <= AxisDirection.GEOCENTRIC_Z.ordinal();
    }

    public static boolean isSpatialOrUserDefined(AxisDirection dir, boolean image) {
        if (dir == null) {
            return false;
        }
        int ordinal = dir.ordinal();
        return ordinal < AxisDirection.FUTURE.ordinal() || ordinal > (image ? AxisDirection.PAST : AxisDirection.DISPLAY_DOWN).ordinal();
    }

    public static boolean isUserDefined(AxisDirection dir) {
        return dir != null && dir.ordinal() > LAST_ORDINAL;
    }

    public static boolean isGrid(AxisDirection dir) {
        if (dir == null) {
            return false;
        }
        int ordinal = dir.ordinal();
        return ordinal >= AxisDirection.COLUMN_POSITIVE.ordinal() && ordinal <= AxisDirection.ROW_NEGATIVE.ordinal();
    }

    public static int angleForVehicle(AxisDirection source, AxisDirection target) {
        if (source == STARBOARD && target == FORWARD) {
            return 1;
        }
        if (source == FORWARD && target == STARBOARD) {
            return -1;
        }
        return Integer.MIN_VALUE;
    }

    public static int angleForGeocentric(AxisDirection source, AxisDirection target) {
        int tgt;
        int base = AxisDirection.GEOCENTRIC_X.ordinal();
        int src = source.ordinal() - base;
        if (src >= 0 && src < 3 && (tgt = target.ordinal() - base) >= 0 && tgt < 3) {
            int n = tgt - src;
            n -= 3 * (n / 2);
            return n;
        }
        return Integer.MIN_VALUE;
    }

    public static int angleForCompass(AxisDirection source, AxisDirection target) {
        int tgt;
        int base = AxisDirection.NORTH.ordinal();
        int src = source.ordinal() - base;
        if (src >= 0 && src < 16 && (tgt = target.ordinal() - base) >= 0 && tgt < 16) {
            int n = src - tgt;
            if (n < -8) {
                n += 16;
            } else if (n > 8) {
                n -= 16;
            }
            return n;
        }
        return Integer.MIN_VALUE;
    }

    public static int angleForDisplay(AxisDirection source, AxisDirection target) {
        int tgt;
        int base = AxisDirection.DISPLAY_RIGHT.ordinal();
        int src = source.ordinal() - base;
        if (src >= 0 && src < 4 && (tgt = target.ordinal() - base) >= 0 && tgt < 4) {
            int n = (src = DISPLAY_ORDER[src]) - (tgt = DISPLAY_ORDER[tgt]);
            if (n < -2) {
                n += 4;
            } else if (n > 2) {
                n -= 4;
            }
            return n;
        }
        return Integer.MIN_VALUE;
    }

    public static Unit<Angle> getAngularUnit(CoordinateSystem cs, Unit<Angle> fallback) {
        if (cs != null) {
            int i = cs.getDimension();
            while (--i >= 0) {
                Unit<?> candidate;
                CoordinateSystemAxis axis = cs.getAxis(i);
                if (axis == null || !Units.isAngular(candidate = axis.getUnit())) continue;
                fallback = candidate.asType(Angle.class);
                if (!AxisDirection.EAST.equals(AxisDirections.absolute(axis.getDirection()))) continue;
                break;
            }
        }
        return fallback;
    }

    public static int indexOfColinear(CoordinateSystem cs, AxisDirection direction) {
        int fallback = -1;
        if (cs != null) {
            int dimension = cs.getDimension();
            for (int i = 0; i < dimension; ++i) {
                AxisDirection d = cs.getAxis(i).getDirection();
                if (direction.equals(d)) {
                    return i;
                }
                if (fallback >= 0 || !d.equals(AxisDirections.opposite(direction))) continue;
                fallback = i;
            }
        }
        return fallback;
    }

    public static int indexOfColinear(CoordinateSystem cs, CoordinateSystem subCS) {
        int fallback = -1;
        if (cs != null) {
            boolean fallbackMatches = false;
            int subDim = subCS.getDimension();
            int limit = cs.getDimension() - subDim;
            block0: for (int i = 0; i <= limit; ++i) {
                boolean equal = true;
                boolean match = true;
                for (int j = 0; j < subDim; ++j) {
                    CoordinateSystemAxis expected = subCS.getAxis(j);
                    CoordinateSystemAxis actual = cs.getAxis(i + j);
                    if (!AxisDirections.isColinear(expected.getDirection(), actual.getDirection())) continue block0;
                    if (equal && (equal = Utilities.deepEquals(expected, actual, ComparisonMode.BY_CONTRACT)) || !match) continue;
                    match = NameToIdentifier.isHeuristicMatchForName(actual, expected.getName().getCode());
                }
                if (equal) {
                    return i;
                }
                if (!(fallback < 0 | match & !fallbackMatches)) continue;
                fallbackMatches = match;
                fallback = i;
            }
        }
        return fallback;
    }

    public static boolean isColinear(AxisDirection d1, AxisDirection d2) {
        return Objects.equals(AxisDirections.absolute(d1), AxisDirections.absolute(d2));
    }

    public static int[] indicesOfLenientMapping(CoordinateSystem cs, CoordinateSystem subCS) {
        int index = AxisDirections.indexOfColinear(cs, subCS);
        if (index >= 0) {
            return ArraysExt.range(index, index + subCS.getDimension());
        }
        return AxesMapper.indices(cs, subCS);
    }

    public static AxisDirection find(String name, AxisDirection[] directions) {
        for (AxisDirection candidate : directions) {
            String identifier = candidate.name();
            if (!CharSequences.equalsFiltered(name, identifier, Characters.Filter.LETTERS_AND_DIGITS, true) && !CharSequences.isAcronymForWords(name, identifier)) continue;
            return candidate;
        }
        return null;
    }

    public static AxisDirection valueOf(String name) {
        int d;
        AxisDirection[] directions;
        AxisDirection candidate = AxisDirections.find(name = name.replace('_', ' ').strip(), directions = AxisDirection.values());
        if (candidate == null && (d = name.indexOf(62)) >= 0 && AxisDirections.equalsIgnoreCase(name, 0, CharSequences.skipTrailingWhitespaces(name, 0, d), "Geocentre")) {
            int length = name.length();
            int s = name.indexOf(47, d = CharSequences.skipLeadingWhitespaces(name, d + 1, length));
            if (s < 0) {
                if (AxisDirections.equalsIgnoreCase(name, d, length, "north pole")) {
                    return AxisDirection.GEOCENTRIC_Z;
                }
            } else if (AxisDirections.equalsIgnoreCase(name, d, CharSequences.skipTrailingWhitespaces(name, d, s), "equator")) {
                if (AxisDirections.equalsIgnoreCase(name, s = CharSequences.skipLeadingWhitespaces(name, s + 1, length), length, "PM")) {
                    return AxisDirection.GEOCENTRIC_X;
                }
                int stopAt = Math.min(s + 6, length);
                for (int i = s; i < stopAt; ++i) {
                    char c = name.charAt(i);
                    if (c >= '0' && c <= '9') continue;
                    if (i == s) break;
                    int n = Integer.parseInt(name.substring(s, i));
                    if (!AxisDirections.equalsIgnoreCase(name, i = CharSequences.skipLeadingWhitespaces(name, i, length), length, "\u00b0E") && !AxisDirections.equalsIgnoreCase(name, i, length, "dE")) break;
                    switch (n) {
                        case 0: {
                            return AxisDirection.GEOCENTRIC_X;
                        }
                        case 90: {
                            return AxisDirection.GEOCENTRIC_Y;
                        }
                    }
                    break;
                }
            }
        }
        return candidate;
    }

    private static boolean equalsIgnoreCase(String name, int lower, int upper, String keyword) {
        int length = upper - lower;
        return length == keyword.length() && name.regionMatches(true, lower, keyword, 0, length);
    }

    private static boolean contains(String name, String keyword, boolean end) {
        int length = keyword.length();
        return name.regionMatches(true, end ? name.length() - length : 0, keyword, 0, length);
    }

    public static String suggestAbbreviation(String name, AxisDirection direction, Unit<?> unit) {
        String id;
        if (name.length() == 1) {
            return name;
        }
        if (AxisDirections.contains(name, "radius", true)) {
            return "r";
        }
        if (AxisDirections.isCompass(direction)) {
            if (!AxisDirections.isIntercardinal(direction) && Units.isAngular(unit)) {
                if (AxisDirections.contains(name, "Spherical", false)) {
                    return AxisDirection.NORTH.equals(AxisDirections.absolute(direction)) ? "\u03a9" : "\u03b8";
                }
                return AxisDirection.NORTH.equals(AxisDirections.absolute(direction)) ? "\u03c6" : "\u03bb";
            }
        } else {
            if (AxisDirection.UP.equals(direction)) {
                if (Units.isAngular(unit)) {
                    return "\u03b1";
                }
                if (AxisDirections.contains(name, "Gravity", false)) {
                    return "H";
                }
                if (AxisDirections.contains(name, "Geocentric", false)) {
                    return "r";
                }
                return "h";
            }
            if (AxisDirection.DOWN.equals(direction)) {
                return "D";
            }
            if (AxisDirections.isGeocentric(direction)) {
                String dir = direction.name();
                return dir.substring(dir.length() - 1).trim();
            }
            String abbreviation = ABBREVIATIONS.get(AxisDirections.absolute(direction));
            if (abbreviation != null) {
                return abbreviation;
            }
        }
        return CharSequences.camelCaseToAcronym((id = direction.identifier()) != null ? id : direction.name()).toString().intern();
    }

    public static AxisDirection fromAbbreviation(char abbreviation) {
        AxisDirection dir;
        if (abbreviation >= 'a' && abbreviation <= 'z') {
            abbreviation = (char)(abbreviation - 32);
        }
        switch (abbreviation) {
            default: {
                dir = null;
                break;
            }
            case 'W': {
                dir = AxisDirection.WEST;
                break;
            }
            case 'S': {
                dir = AxisDirection.SOUTH;
                break;
            }
            case 'E': 
            case '\u03b8': 
            case '\u03bb': {
                dir = AxisDirection.EAST;
                break;
            }
            case 'N': 
            case '\u03a9': 
            case '\u03c6': {
                dir = AxisDirection.NORTH;
                break;
            }
            case 'H': 
            case 'R': {
                dir = AxisDirection.UP;
                break;
            }
            case 'D': {
                dir = AxisDirection.DOWN;
                break;
            }
            case 'T': {
                dir = AxisDirection.FUTURE;
            }
        }
        return dir;
    }

    public static String appendTo(StringBuilder buffer, CoordinateSystemAxis[] axes) {
        String separator = ": ";
        for (CoordinateSystemAxis axis : axes) {
            String symbol;
            buffer.append(separator).append(Types.getCodeLabel(axis.getDirection()));
            separator = ", ";
            Unit<?> unit = axis.getUnit();
            if (unit == null || (symbol = unit.toString()) == null || symbol.isEmpty()) continue;
            buffer.append(" (").append(symbol).append(')');
        }
        return buffer.append('.').toString();
    }

    static {
        AxisDirections.put(AxisDirection.OTHER, AxisDirection.OTHER);
        AxisDirections.put(AxisDirection.NORTH, AxisDirection.SOUTH);
        AxisDirections.put(AxisDirection.NORTH_NORTH_EAST, AxisDirection.SOUTH_SOUTH_WEST);
        AxisDirections.put(AxisDirection.NORTH_EAST, AxisDirection.SOUTH_WEST);
        AxisDirections.put(AxisDirection.EAST_NORTH_EAST, AxisDirection.WEST_SOUTH_WEST);
        AxisDirections.put(AxisDirection.EAST, AxisDirection.WEST);
        AxisDirections.put(AxisDirection.EAST_SOUTH_EAST, AxisDirection.WEST_NORTH_WEST);
        AxisDirections.put(AxisDirection.SOUTH_EAST, AxisDirection.NORTH_WEST);
        AxisDirections.put(AxisDirection.SOUTH_SOUTH_EAST, AxisDirection.NORTH_NORTH_WEST);
        AxisDirections.put(AxisDirection.UP, AxisDirection.DOWN);
        AxisDirections.put(AxisDirection.FUTURE, AxisDirection.PAST);
        AxisDirections.put(AxisDirection.COLUMN_POSITIVE, AxisDirection.COLUMN_NEGATIVE);
        AxisDirections.put(AxisDirection.ROW_POSITIVE, AxisDirection.ROW_NEGATIVE);
        AxisDirections.put(AxisDirection.DISPLAY_RIGHT, AxisDirection.DISPLAY_LEFT);
        AxisDirections.put(AxisDirection.DISPLAY_UP, AxisDirection.DISPLAY_DOWN);
        AxisDirections.put(COUNTER_CLOCKWISE, CLOCKWISE);
        ABBREVIATIONS = Map.of(AxisDirection.FUTURE, "t", AxisDirection.COLUMN_POSITIVE, "i", AxisDirection.ROW_POSITIVE, "j", AxisDirection.DISPLAY_RIGHT, "x", AxisDirection.DISPLAY_UP, "y", AxisDirection.OTHER, "z", AWAY_FROM, "r", COUNTER_CLOCKWISE, "\u03b8");
        DISPLAY_ORDER = new byte[]{1, 3, 0, 2};
    }
}

