/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.factory.sql;

import javax.measure.Unit;
import org.apache.sis.referencing.crs.DefaultParametricCRS;
import org.apache.sis.referencing.cs.DefaultParametricCS;
import org.apache.sis.referencing.datum.DefaultParametricDatum;
import org.apache.sis.util.CharSequences;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.referencing.crs.CompoundCRS;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.crs.DerivedCRS;
import org.opengis.referencing.crs.EngineeringCRS;
import org.opengis.referencing.crs.GeocentricCRS;
import org.opengis.referencing.crs.GeographicCRS;
import org.opengis.referencing.crs.ProjectedCRS;
import org.opengis.referencing.crs.TemporalCRS;
import org.opengis.referencing.crs.VerticalCRS;
import org.opengis.referencing.cs.AffineCS;
import org.opengis.referencing.cs.CartesianCS;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.referencing.cs.CoordinateSystemAxis;
import org.opengis.referencing.cs.CylindricalCS;
import org.opengis.referencing.cs.EllipsoidalCS;
import org.opengis.referencing.cs.LinearCS;
import org.opengis.referencing.cs.PolarCS;
import org.opengis.referencing.cs.SphericalCS;
import org.opengis.referencing.cs.TimeCS;
import org.opengis.referencing.cs.VerticalCS;
import org.opengis.referencing.datum.Datum;
import org.opengis.referencing.datum.Ellipsoid;
import org.opengis.referencing.datum.EngineeringDatum;
import org.opengis.referencing.datum.GeodeticDatum;
import org.opengis.referencing.datum.PrimeMeridian;
import org.opengis.referencing.datum.TemporalDatum;
import org.opengis.referencing.datum.VerticalDatum;
import org.opengis.referencing.operation.Conversion;
import org.opengis.referencing.operation.CoordinateOperation;
import org.opengis.referencing.operation.OperationMethod;
import org.opengis.referencing.operation.Projection;
import org.opengis.referencing.operation.Transformation;

final class TableInfo {
    static final TableInfo CRS = new TableInfo(CoordinateReferenceSystem.class, "[Coordinate Reference System]", "COORD_REF_SYS_CODE", "COORD_REF_SYS_NAME", "COORD_REF_SYS_KIND", new Class[]{ProjectedCRS.class, GeographicCRS.class, GeocentricCRS.class, VerticalCRS.class, CompoundCRS.class, EngineeringCRS.class, DerivedCRS.class, TemporalCRS.class, DefaultParametricCRS.class}, new String[]{"projected", "geographic", "geocentric", "vertical", "compound", "engineering", "derived", "temporal", "parametric"}, "SHOW_CRS");
    static final TableInfo DATUM = new TableInfo(Datum.class, "[Datum]", "DATUM_CODE", "DATUM_NAME", "DATUM_TYPE", new Class[]{GeodeticDatum.class, VerticalDatum.class, EngineeringDatum.class, TemporalDatum.class, DefaultParametricDatum.class}, new String[]{"geodetic", "vertical", "engineering", "temporal", "parametric"}, null);
    static final TableInfo ELLIPSOID = new TableInfo(Ellipsoid.class, "[Ellipsoid]", "ELLIPSOID_CODE", "ELLIPSOID_NAME", null, null, null, null);
    static final TableInfo[] EPSG = new TableInfo[]{CRS, new TableInfo(CoordinateSystem.class, "[Coordinate System]", "COORD_SYS_CODE", "COORD_SYS_NAME", "COORD_SYS_TYPE", new Class[]{CartesianCS.class, EllipsoidalCS.class, VerticalCS.class, LinearCS.class, SphericalCS.class, PolarCS.class, CylindricalCS.class, TimeCS.class, DefaultParametricCS.class, AffineCS.class}, new String[]{"Cartesian", "ellipsoidal", "vertical", "linear", "spherical", "polar", "cylindrical", "temporal", "parametric", "affine"}, null), new TableInfo(CoordinateSystemAxis.class, "[Coordinate Axis] AS CA INNER JOIN [Coordinate Axis Name] AS CAN ON CA.COORD_AXIS_NAME_CODE=CAN.COORD_AXIS_NAME_CODE", "COORD_AXIS_CODE", "COORD_AXIS_NAME", null, null, null, null), DATUM, ELLIPSOID, new TableInfo(PrimeMeridian.class, "[Prime Meridian]", "PRIME_MERIDIAN_CODE", "PRIME_MERIDIAN_NAME", null, null, null, null), new TableInfo(CoordinateOperation.class, "[Coordinate_Operation]", "COORD_OP_CODE", "COORD_OP_NAME", "COORD_OP_TYPE", new Class[]{Projection.class, Conversion.class, Transformation.class}, new String[]{"conversion", "conversion", "transformation"}, "SHOW_OPERATION"), new TableInfo(OperationMethod.class, "[Coordinate_Operation Method]", "COORD_OP_METHOD_CODE", "COORD_OP_METHOD_NAME", null, null, null, null), new TableInfo(ParameterDescriptor.class, "[Coordinate_Operation Parameter]", "PARAMETER_CODE", "PARAMETER_NAME", null, null, null, null), new TableInfo(Unit.class, "[Unit of Measure]", "UOM_CODE", "UNIT_OF_MEAS_NAME", null, null, null, null)};
    final Class<?> type;
    final String table;
    final String codeColumn;
    final String nameColumn;
    private final String typeColumn;
    static final String ENUM_REPLACEMENT = "VARCHAR(80)";
    private final Class<?>[] subTypes;
    private final String[] typeNames;
    final String showColumn;

    private TableInfo(Class<?> type, String table, String codeColumn, String nameColumn, String typeColumn, Class<?>[] subTypes, String[] typeNames, String showColumn) {
        this.type = type;
        this.table = table;
        this.codeColumn = codeColumn;
        this.nameColumn = nameColumn;
        this.typeColumn = typeColumn;
        this.subTypes = subTypes;
        this.typeNames = typeNames;
        this.showColumn = showColumn;
    }

    final String unquoted() {
        return this.table.substring(1, this.table.length() - 1);
    }

    static boolean tableMatches(String expected, String name) {
        if (name == null) {
            return false;
        }
        if (name.startsWith("epsg_")) {
            name = name.substring("epsg_".length());
        }
        return CharSequences.isAcronymForWords(name, expected);
    }

    final Class<?> where(Class<?> userType, StringBuilder buffer) {
        buffer.append(" WHERE ");
        if (this.typeColumn != null) {
            for (int i = 0; i < this.subTypes.length; ++i) {
                Class<?> candidate = this.subTypes[i];
                if (!candidate.isAssignableFrom(userType)) continue;
                if (ENUM_REPLACEMENT != null) {
                    buffer.append("CAST(").append(this.typeColumn).append(" AS ").append(ENUM_REPLACEMENT).append(')');
                } else {
                    buffer.append(this.typeColumn);
                }
                buffer.append(" LIKE '").append(this.typeNames[i]).append("%' AND ");
                return candidate;
            }
        }
        return this.type;
    }
}

