/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.metadata.iso.spatial;

import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlType;
import org.apache.sis.measure.ValueRange;
import org.apache.sis.metadata.internal.ImplementationHelper;
import org.apache.sis.metadata.iso.ISOMetadata;
import org.opengis.metadata.spatial.GeometricObjectType;
import org.opengis.metadata.spatial.GeometricObjects;

@XmlType(name="MD_GeometricObjects_Type", propOrder={"geometricObjectType", "geometricObjectCount"})
@XmlRootElement(name="MD_GeometricObjects")
public class DefaultGeometricObjects
extends ISOMetadata
implements GeometricObjects {
    private static final long serialVersionUID = -7965994170083468201L;
    private GeometricObjectType geometricObjectType;
    private Integer geometricObjectCount;

    public DefaultGeometricObjects() {
    }

    public DefaultGeometricObjects(GeometricObjectType geometricObjectType) {
        this.geometricObjectType = geometricObjectType;
    }

    public DefaultGeometricObjects(GeometricObjects object) {
        super(object);
        if (object != null) {
            this.geometricObjectType = object.getGeometricObjectType();
            this.geometricObjectCount = object.getGeometricObjectCount();
        }
    }

    public static DefaultGeometricObjects castOrCopy(GeometricObjects object) {
        if (object == null || object instanceof DefaultGeometricObjects) {
            return (DefaultGeometricObjects)object;
        }
        return new DefaultGeometricObjects(object);
    }

    @Override
    @XmlElement(name="geometricObjectType", required=true)
    public GeometricObjectType getGeometricObjectType() {
        return this.geometricObjectType;
    }

    public void setGeometricObjectType(GeometricObjectType newValue) {
        this.checkWritePermission(this.geometricObjectType);
        this.geometricObjectType = newValue;
    }

    @Override
    @ValueRange(minimum=1.0)
    @XmlElement(name="geometricObjectCount")
    public Integer getGeometricObjectCount() {
        return this.geometricObjectCount;
    }

    public void setGeometricObjectCount(Integer newValue) {
        this.checkWritePermission(this.geometricObjectCount);
        if (ImplementationHelper.ensurePositive(DefaultGeometricObjects.class, "geometricObjectCount", true, newValue)) {
            this.geometricObjectCount = newValue;
        }
    }
}

