/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.metadata.iso.quality;

import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlType;
import org.apache.sis.metadata.iso.quality.AbstractResult;
import org.apache.sis.util.iso.Types;
import org.opengis.metadata.citation.Citation;
import org.opengis.metadata.quality.ConformanceResult;
import org.opengis.util.InternationalString;

@XmlType(name="DQ_ConformanceResult_Type", propOrder={"specification", "explanation", "pass"})
@XmlRootElement(name="DQ_ConformanceResult")
public class DefaultConformanceResult
extends AbstractResult
implements ConformanceResult {
    private static final long serialVersionUID = -2958690684356371311L;
    private Citation specification;
    private InternationalString explanation;
    @XmlElement(name="pass", required=true)
    private Boolean pass;

    public DefaultConformanceResult() {
    }

    public DefaultConformanceResult(Citation specification, CharSequence explanation, boolean pass) {
        this.specification = specification;
        this.explanation = Types.toInternationalString(explanation);
        this.pass = pass;
    }

    public DefaultConformanceResult(ConformanceResult object) {
        super(object);
        if (object != null) {
            this.specification = object.getSpecification();
            this.explanation = object.getExplanation();
            this.pass = object.pass();
        }
    }

    public static DefaultConformanceResult castOrCopy(ConformanceResult object) {
        if (object == null || object instanceof DefaultConformanceResult) {
            return (DefaultConformanceResult)object;
        }
        return new DefaultConformanceResult(object);
    }

    @Override
    @XmlElement(name="specification", required=true)
    public Citation getSpecification() {
        return this.specification;
    }

    public void setSpecification(Citation newValue) {
        this.checkWritePermission(this.specification);
        this.specification = newValue;
    }

    @Override
    @XmlElement(name="explanation")
    public InternationalString getExplanation() {
        return this.explanation;
    }

    public void setExplanation(InternationalString newValue) {
        this.checkWritePermission(this.explanation);
        this.explanation = newValue;
    }

    @Override
    public Boolean pass() {
        return this.pass;
    }

    public void setPass(Boolean newValue) {
        this.checkWritePermission(this.pass);
        this.pass = newValue;
    }
}

