/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.io.wkt;

import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.EnumMap;
import org.apache.sis.io.wkt.ElementKind;
import org.apache.sis.util.internal.X364;
import org.apache.sis.util.resources.Errors;

public class Colors
implements Cloneable,
Serializable {
    private static final long serialVersionUID = 256160285861027191L;
    public static final Colors DEFAULT = new Colors();
    public static final Colors NAMING;
    private EnumMap<ElementKind, X364> map;
    private boolean isImmutable;

    public Colors() {
        this.map = new EnumMap(ElementKind.class);
    }

    public Colors(Colors colors) {
        this.map = new EnumMap<ElementKind, X364>(colors.map);
    }

    public void setName(ElementKind key, String color) throws IllegalArgumentException {
        if (this.isImmutable) {
            throw new UnsupportedOperationException(Errors.format((short)153, "Colors"));
        }
        if (color == null) {
            this.map.remove((Object)key);
        } else {
            this.map.put(key, X364.forColorName(color));
        }
    }

    public final String getName(ElementKind key) {
        X364 color = this.map.get((Object)key);
        return color != null ? color.color : null;
    }

    final String getAnsiSequence(ElementKind key) {
        X364 color = this.map.get((Object)key);
        return color != null ? color.sequence() : null;
    }

    final Colors immutable() {
        if (this.isImmutable) {
            return this;
        }
        Colors clone = this.clone();
        clone.isImmutable = true;
        return clone;
    }

    public Colors clone() {
        Colors clone;
        try {
            clone = (Colors)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
        clone.map = clone.map.clone();
        clone.isImmutable = false;
        return clone;
    }

    public boolean equals(Object other) {
        if (other instanceof Colors) {
            Colors that = (Colors)other;
            return this.map.equals((Object)that.map);
        }
        return false;
    }

    public int hashCode() {
        return this.map.hashCode() ^ 0x3C4F1D77;
    }

    final Object readResolve() throws ObjectStreamException {
        return this.isImmutable && this.map.equals((Object)Colors.DEFAULT.map) ? DEFAULT : this;
    }

    static {
        EnumMap<ElementKind, X364> map = Colors.DEFAULT.map;
        map.put(ElementKind.NUMBER, X364.FOREGROUND_YELLOW);
        map.put(ElementKind.INTEGER, X364.FOREGROUND_YELLOW);
        map.put(ElementKind.UNIT, X364.FOREGROUND_YELLOW);
        map.put(ElementKind.AXIS, X364.FOREGROUND_CYAN);
        map.put(ElementKind.CODE_LIST, X364.FOREGROUND_CYAN);
        map.put(ElementKind.PARAMETER, X364.FOREGROUND_GREEN);
        map.put(ElementKind.METHOD, X364.FOREGROUND_GREEN);
        map.put(ElementKind.DATUM, X364.FOREGROUND_GREEN);
        map.put(ElementKind.IDENTIFIER, X364.FOREGROUND_RED);
        map.put(ElementKind.SCOPE, X364.FOREGROUND_GRAY);
        map.put(ElementKind.EXTENT, X364.FOREGROUND_GRAY);
        map.put(ElementKind.CITATION, X364.FOREGROUND_GRAY);
        map.put(ElementKind.REMARKS, X364.FOREGROUND_GRAY);
        map.put(ElementKind.ERROR, X364.BACKGROUND_RED);
        Colors.DEFAULT.isImmutable = true;
        NAMING = new Colors();
        map = Colors.NAMING.map;
        map.put(ElementKind.NAME, X364.FOREGROUND_GREEN);
        map.put(ElementKind.IDENTIFIER, X364.FOREGROUND_YELLOW);
        Colors.NAMING.isImmutable = true;
    }
}

