/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.image;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.image.ColorModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.nio.DoubleBuffer;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.DoubleUnaryOperator;
import java.util.function.Function;
import javax.measure.Quantity;
import org.apache.sis.coverage.Category;
import org.apache.sis.coverage.SampleDimension;
import org.apache.sis.coverage.grid.j2d.ColorModelBuilder;
import org.apache.sis.coverage.grid.j2d.ImageLayout;
import org.apache.sis.coverage.grid.j2d.ImageUtilities;
import org.apache.sis.coverage.internal.CompoundTransform;
import org.apache.sis.coverage.internal.SampleDimensions;
import org.apache.sis.feature.internal.Resources;
import org.apache.sis.image.BandSelectImage;
import org.apache.sis.image.Colorizer;
import org.apache.sis.image.ImageAdapter;
import org.apache.sis.image.ImageProcessor;
import org.apache.sis.image.Interpolation;
import org.apache.sis.image.RecoloredImage;
import org.apache.sis.image.ResampledImage;
import org.apache.sis.image.Transferer;
import org.apache.sis.math.Statistics;
import org.apache.sis.measure.NumberRange;
import org.apache.sis.referencing.operation.transform.MathTransforms;
import org.apache.sis.util.collection.BackingStoreException;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.MathTransform1D;
import org.opengis.referencing.operation.NoninvertibleTransformException;
import org.opengis.referencing.operation.TransformException;

final class Visualization
extends ResampledImage {
    private final MathTransform1D[] converters;
    private final ColorModel colorModel;

    private static Interpolation combine(Interpolation interpolation, MathTransform1D[] converters) {
        MathTransform converter = CompoundTransform.create(converters);
        if (converter.isIdentity()) {
            return interpolation;
        }
        if (converter instanceof MathTransform1D) {
            return new InterpConvertOneBand(interpolation, (MathTransform1D)converter);
        }
        return new InterpConvert(interpolation, converter);
    }

    private Visualization(Builder builder) {
        super(builder.source, builder.sampleModel, builder.layout.getMinTile(), builder.bounds, builder.toSource, builder.interpolation, builder.fillValues, builder.positionalAccuracyHints);
        this.colorModel = builder.colorModel;
        this.converters = builder.converters;
    }

    @Override
    final boolean hasNoMask() {
        return !(this.interpolation instanceof InterpConvert) && super.hasNoMask();
    }

    @Override
    public ColorModel getColorModel() {
        return this.colorModel;
    }

    @Override
    protected Raster computeTile(int tileX, int tileY, WritableRaster tile) throws TransformException {
        if (this.converters == null) {
            try {
                return super.computeTile(tileX, tileY, tile);
            }
            catch (BackingStoreException e) {
                throw e.unwrapOrRethrow(TransformException.class);
            }
        }
        if (tile == null) {
            tile = this.createTile(tileX, tileY);
        }
        Transferer.create(this.getSource(), tile).compute(this.converters);
        return tile;
    }

    @Override
    public boolean equals(Object object) {
        if (super.equals(object)) {
            Visualization other = (Visualization)object;
            return Arrays.equals(this.converters, other.converters) && Objects.equals(this.colorModel, other.colorModel);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return super.hashCode() + 67 * Arrays.hashCode(this.converters) + 97 * Objects.hashCode(this.colorModel);
    }

    private static final class InterpConvertOneBand
    extends InterpConvert {
        private final MathTransform1D singleConverter;

        InterpConvertOneBand(Interpolation interpolation, MathTransform1D converter) {
            super(interpolation, converter);
            this.singleConverter = converter;
        }

        @Override
        public void interpolate(DoubleBuffer source, int numBands, double xfrac, double yfrac, double[] writeTo, int writeToOffset) {
            this.interpolation.interpolate(source, numBands, xfrac, yfrac, writeTo, writeToOffset);
            try {
                writeTo[writeToOffset] = this.singleConverter.transform(writeTo[writeToOffset]);
            }
            catch (TransformException e) {
                throw new BackingStoreException(e);
            }
        }
    }

    static class InterpConvert
    extends Interpolation {
        final Interpolation interpolation;
        final MathTransform converter;

        InterpConvert(Interpolation interpolation, MathTransform converter) {
            this.interpolation = interpolation;
            this.converter = converter;
        }

        @Override
        public final Dimension getSupportSize() {
            return this.interpolation.getSupportSize();
        }

        @Override
        public void interpolate(DoubleBuffer source, int numBands, double xfrac, double yfrac, double[] writeTo, int writeToOffset) {
            this.interpolation.interpolate(source, numBands, xfrac, yfrac, writeTo, writeToOffset);
            try {
                this.converter.transform(writeTo, writeToOffset, writeTo, writeToOffset, 1);
            }
            catch (TransformException e) {
                throw new BackingStoreException(e);
            }
        }

        @Override
        Interpolation toCompatible(RenderedImage source) {
            return this;
        }
    }

    static final class Builder {
        private static final int NUM_BANDS = 1;
        private static final int VISIBLE_BAND = 0;
        private Rectangle bounds;
        private RenderedImage source;
        private MathTransform toSource;
        private SampleDimension[] sampleDimensions;
        ImageLayout layout;
        Interpolation interpolation;
        Colorizer colorizer;
        Number[] fillValues;
        Quantity<?>[] positionalAccuracyHints;
        private MathTransform1D[] converters;
        private SampleModel sampleModel;
        private ColorModel colorModel;

        Builder(Rectangle bounds, RenderedImage source, MathTransform toSource) {
            Object ranges;
            this.bounds = bounds;
            this.source = source;
            this.toSource = toSource;
            this.sampleDimensions = SampleDimensions.IMAGE_PROCESSOR_ARGUMENT.get();
            if (this.sampleDimensions == null && (ranges = source.getProperty("org.apache.sis.SampleDimensions")) instanceof SampleDimension[]) {
                this.sampleDimensions = (SampleDimension[])ranges;
            }
        }

        @Deprecated(since="1.4", forRemoval=true)
        Builder(Rectangle bounds, RenderedImage source, MathTransform toSource, List<SampleDimension> sampleDimensions) {
            this.bounds = bounds;
            this.source = source;
            this.toSource = toSource;
            if (sampleDimensions != null) {
                this.sampleDimensions = (SampleDimension[])sampleDimensions.toArray(SampleDimension[]::new);
            }
        }

        RenderedImage create(ImageProcessor processor) throws NoninvertibleTransformException {
            boolean initialized;
            ColorModelBuilder builder;
            boolean shortcut;
            RenderedImage coloredSource = this.source;
            int visibleBand = ImageUtilities.getVisibleBand(coloredSource);
            if (visibleBand < 0) {
                throw new IllegalArgumentException(Resources.format((short)55));
            }
            if (this.toSource == null) {
                this.toSource = MathTransforms.identity(2);
            }
            while (true) {
                if (this.source instanceof ImageAdapter) {
                    this.source = ((ImageAdapter)this.source).source;
                    continue;
                }
                if (!(this.source instanceof ResampledImage)) break;
                ResampledImage r = (ResampledImage)this.source;
                this.toSource = MathTransforms.concatenate(this.toSource, r.toSource);
                this.source = r.getSource();
            }
            this.source = BandSelectImage.create(this.source, true, visibleBand);
            SampleDimension visibleSD = this.sampleDimensions != null && visibleBand < this.sampleDimensions.length ? this.sampleDimensions[visibleBand] : null;
            boolean bl = shortcut = this.toSource.isIdentity() && (this.bounds == null || ImageUtilities.getBounds(this.source).contains(this.bounds));
            if (shortcut) {
                this.layout = ImageLayout.forTileSize(this.source);
            }
            this.sampleModel = this.layout.createBandedSampleModel(0, 1, this.source, this.bounds, 0);
            Target target = new Target(this.sampleModel, 0, visibleSD != null);
            if (this.colorizer != null) {
                this.colorModel = this.colorizer.apply(target).orElse(null);
            }
            SampleModel sourceSM = coloredSource.getSampleModel();
            ColorModel sourceCM = coloredSource.getColorModel();
            if (target.rangeColors != null) {
                builder = new ColorModelBuilder(target.rangeColors, sourceCM);
                initialized = true;
            } else {
                builder = new ColorModelBuilder(target.categoryColors, sourceCM, true);
                initialized = builder.initialize(sourceSM, visibleSD);
                if (initialized) {
                    builder.rescaleMainRange(sourceCM);
                } else {
                    initialized = builder.initialize(sourceCM);
                    if (!initialized) {
                        if (coloredSource instanceof RecoloredImage) {
                            RecoloredImage colored = (RecoloredImage)coloredSource;
                            builder.initialize(colored.minimum, colored.maximum, sourceSM.getDataType());
                            initialized = true;
                        } else {
                            initialized = builder.initialize(sourceSM, visibleBand);
                        }
                    }
                }
            }
            if (!initialized) {
                DoubleUnaryOperator[] sampleFilters = SampleDimensions.toSampleFilters(visibleSD);
                Statistics statistics = processor.valueOfStatistics(this.source, null, sampleFilters)[0];
                builder.initialize(statistics.minimum(), statistics.maximum(), sourceSM.getDataType());
            }
            if (this.colorModel == null) {
                this.colorModel = builder.createColorModel(0, 1, 0);
            }
            this.converters = new MathTransform1D[]{builder.getSampleToIndexValues()};
            if (shortcut) {
                if (this.converters[0].isIdentity() && this.colorModel.equals(sourceCM)) {
                    return coloredSource;
                }
                this.interpolation = Interpolation.NEAREST;
            } else {
                this.interpolation = Visualization.combine(this.interpolation.toCompatible(this.source), this.converters);
                this.converters = null;
            }
            if (this.bounds == null) {
                this.bounds = ImageUtilities.getBounds(this.source);
            }
            return ImageProcessor.unique(new Visualization(this));
        }
    }

    static final class Target
    extends Colorizer.Target {
        List<Map.Entry<NumberRange<?>, Color[]>> rangeColors;
        Function<Category, Color[]> categoryColors;
        private final boolean hasCategories;

        Target(SampleModel model, int visibleBand, boolean hasCategories) {
            super(model, null, visibleBand);
            this.hasCategories = hasCategories;
        }

        @Override
        boolean isConsumed() {
            return this.rangeColors != null || this.hasCategories && this.categoryColors != null;
        }
    }
}

