/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.converter;

import java.io.ObjectStreamException;
import java.util.EnumSet;
import java.util.Set;
import org.apache.sis.converter.ClassPair;
import org.apache.sis.converter.SystemRegistry;
import org.apache.sis.math.FunctionProperty;
import org.apache.sis.util.ObjectConverter;
import org.apache.sis.util.resources.Errors;

abstract class SystemConverter<S, T>
extends ClassPair<S, T>
implements ObjectConverter<S, T> {
    private static final long serialVersionUID = -5003169442214901702L;

    SystemConverter(Class<S> sourceClass, Class<T> targetClass) {
        super(sourceClass, targetClass);
    }

    @Override
    public final Class<S> getSourceClass() {
        return this.sourceClass;
    }

    @Override
    public final Class<T> getTargetClass() {
        return this.targetClass;
    }

    static Set<FunctionProperty> bijective() {
        return EnumSet.of(FunctionProperty.INJECTIVE, FunctionProperty.SURJECTIVE, FunctionProperty.ORDER_PRESERVING, FunctionProperty.INVERTIBLE);
    }

    @Override
    public ObjectConverter<T, S> inverse() throws UnsupportedOperationException {
        throw new UnsupportedOperationException(Errors.format((short)102));
    }

    @Override
    public final boolean equals(Object other) {
        if (super.equals(other)) {
            Class<?> type = other.getClass();
            return type == ClassPair.class || type == this.getClass();
        }
        return false;
    }

    public ObjectConverter<S, T> unique() {
        ObjectConverter existing;
        if (this.sourceClass != null && this.targetClass != null && (existing = SystemRegistry.INSTANCE.findEquals(this)) != null) {
            return existing;
        }
        return this;
    }

    protected final Object readResolve() throws ObjectStreamException {
        return this.unique();
    }

    final String formatErrorMessage(S value) {
        return Errors.format((short)8, value, this.targetClass);
    }
}

