/*
 * Decompiled with CFR 0.152.
 */
package ucar.ma2;

import java.util.Formatter;
import java.util.HashMap;
import java.util.Map;
import ucar.ma2.Array;
import ucar.ma2.ArrayChar;
import ucar.ma2.ArraySequence;
import ucar.ma2.ArrayStructure;
import ucar.ma2.DataType;
import ucar.ma2.Index;
import ucar.ma2.StructureData;
import ucar.ma2.StructureMembers;
import ucar.nc2.util.Indent;

public class StructureDataW
extends StructureData {
    protected final Map<StructureMembers.Member, Array> memberData;

    public StructureDataW(StructureMembers members) {
        super(members);
        this.memberData = new HashMap<StructureMembers.Member, Array>(2 * members.getMembers().size());
    }

    public StructureDataW(StructureMembers members, int size) {
        super(members);
        this.memberData = new HashMap<StructureMembers.Member, Array>(2 * size);
    }

    public void setMemberData(StructureMembers.Member m4, Array data) {
        if (data == null) {
            throw new IllegalArgumentException("data cant be null");
        }
        this.memberData.put(m4, data);
    }

    public void setMemberData(String memberName, Array data) {
        StructureMembers.Member m4 = this.members.findMember(memberName);
        if (m4 == null) {
            throw new IllegalArgumentException("illegal member name =" + memberName);
        }
        this.setMemberData(m4, data);
    }

    @Override
    public Array getArray(StructureMembers.Member m4) {
        if (m4 == null) {
            throw new IllegalArgumentException("member is null");
        }
        return this.memberData.get(m4);
    }

    @Override
    public float convertScalarFloat(StructureMembers.Member m4) {
        return this.getScalarFloat(m4);
    }

    @Override
    public double convertScalarDouble(StructureMembers.Member m4) {
        return this.getScalarDouble(m4);
    }

    @Override
    public int convertScalarInt(StructureMembers.Member m4) {
        return this.getScalarInt(m4);
    }

    @Override
    public long convertScalarLong(StructureMembers.Member m4) {
        return this.getScalarLong(m4);
    }

    @Override
    public double getScalarDouble(StructureMembers.Member m4) {
        Array data = this.getArray(m4);
        return data.getDouble(Index.scalarIndexImmutable);
    }

    @Override
    public double[] getJavaArrayDouble(StructureMembers.Member m4) {
        Array data = this.getArray(m4);
        return (double[])data.getStorage();
    }

    @Override
    public float getScalarFloat(StructureMembers.Member m4) {
        Array data = this.getArray(m4);
        return data.getFloat(Index.scalarIndexImmutable);
    }

    @Override
    public float[] getJavaArrayFloat(StructureMembers.Member m4) {
        Array data = this.getArray(m4);
        return (float[])data.getStorage();
    }

    @Override
    public byte getScalarByte(StructureMembers.Member m4) {
        Array data = this.getArray(m4);
        if (data == null) {
            System.out.println("StructureDataW HEY");
            data = this.getArray(m4);
        }
        return data.getByte(Index.scalarIndexImmutable);
    }

    @Override
    public byte[] getJavaArrayByte(StructureMembers.Member m4) {
        Array data = this.getArray(m4);
        return (byte[])data.getStorage();
    }

    @Override
    public int getScalarInt(StructureMembers.Member m4) {
        Array data = this.getArray(m4);
        return data.getInt(Index.scalarIndexImmutable);
    }

    @Override
    public int[] getJavaArrayInt(StructureMembers.Member m4) {
        Array data = this.getArray(m4);
        return (int[])data.getStorage();
    }

    @Override
    public short getScalarShort(StructureMembers.Member m4) {
        Array data = this.getArray(m4);
        return data.getShort(Index.scalarIndexImmutable);
    }

    @Override
    public short[] getJavaArrayShort(StructureMembers.Member m4) {
        Array data = this.getArray(m4);
        return (short[])data.getStorage();
    }

    @Override
    public long getScalarLong(StructureMembers.Member m4) {
        Array data = this.getArray(m4);
        return data.getLong(Index.scalarIndexImmutable);
    }

    @Override
    public long[] getJavaArrayLong(StructureMembers.Member m4) {
        Array data = this.getArray(m4);
        return (long[])data.getStorage();
    }

    @Override
    public char getScalarChar(StructureMembers.Member m4) {
        Array data = this.getArray(m4);
        return data.getChar(Index.scalarIndexImmutable);
    }

    @Override
    public char[] getJavaArrayChar(StructureMembers.Member m4) {
        Array data = this.getArray(m4);
        return (char[])data.getStorage();
    }

    @Override
    public String getScalarString(StructureMembers.Member m4) {
        int count;
        if (m4.getDataType() == DataType.STRING) {
            Array data = this.getArray(m4);
            if (data == null) {
                data = this.getArray(m4);
            }
            return (String)data.getObject(0);
        }
        char[] ba = this.getJavaArrayChar(m4);
        for (count = 0; count < ba.length && '\u0000' != ba[count]; ++count) {
        }
        return new String(ba, 0, count);
    }

    @Override
    public String[] getJavaArrayString(StructureMembers.Member m4) {
        if (m4.getDataType() == DataType.STRING) {
            Array data = this.getArray(m4);
            int n = m4.getSize();
            String[] result = new String[n];
            for (int i = 0; i < result.length; ++i) {
                result[i] = (String)data.getObject(i);
            }
            return result;
        }
        if (m4.getDataType() == DataType.CHAR) {
            ArrayChar data = (ArrayChar)this.getArray(m4);
            ArrayChar.StringIterator iter = data.getStringIterator();
            String[] result = new String[iter.getNumElems()];
            int count = 0;
            while (iter.hasNext()) {
                result[count++] = iter.next();
            }
            return result;
        }
        throw new IllegalArgumentException("getJavaArrayString: not String DataType :" + (Object)((Object)m4.getDataType()));
    }

    @Override
    public StructureData getScalarStructure(StructureMembers.Member m4) {
        ArrayStructure data = (ArrayStructure)this.getArray(m4);
        return data.getStructureData(0);
    }

    @Override
    public ArrayStructure getArrayStructure(StructureMembers.Member m4) {
        return (ArrayStructure)this.getArray(m4);
    }

    @Override
    public ArraySequence getArraySequence(StructureMembers.Member m4) {
        return (ArraySequence)this.getArray(m4);
    }

    @Override
    public void showInternal(Formatter f, Indent indent) {
        super.showInternal(f, indent);
        for (StructureMembers.Member m4 : this.memberData.keySet()) {
            Array data = this.memberData.get(m4);
            f.format("%s %s = %s%n", indent, m4, data);
        }
    }
}

