/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.io;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.text.DateFormat;
import java.text.FieldPosition;
import java.text.Format;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.IdentityHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import javax.measure.Quantity;
import javax.measure.Unit;
import org.apache.sis.internal.util.LocalizedParseException;
import org.apache.sis.internal.util.MetadataServices;
import org.apache.sis.io.ClassFormat;
import org.apache.sis.io.DefaultFormat;
import org.apache.sis.io.IdentifiedObjectFormat;
import org.apache.sis.measure.Angle;
import org.apache.sis.measure.AngleFormat;
import org.apache.sis.measure.QuantityFormat;
import org.apache.sis.measure.Range;
import org.apache.sis.measure.RangeFormat;
import org.apache.sis.measure.UnitFormat;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.ArraysExt;
import org.apache.sis.util.Classes;
import org.apache.sis.util.Localized;
import org.apache.sis.util.Numbers;
import org.opengis.geometry.DirectPosition;
import org.opengis.referencing.IdentifiedObject;

public abstract class CompoundFormat<T>
extends Format
implements Localized {
    private static final long serialVersionUID = -689151528653024968L;
    private final Locale locale;
    private final TimeZone timezone;
    private transient Map<Class<?>, Format> formats;

    protected CompoundFormat(Locale locale, TimeZone timeZone) {
        this.locale = locale != null ? locale : Locale.ROOT;
        this.timezone = timeZone;
    }

    @Override
    public Locale getLocale() {
        return this.locale;
    }

    public Locale getLocale(Locale.Category category) {
        ArgumentChecks.ensureNonNull("category", (Object)category);
        return this.getLocale();
    }

    public TimeZone getTimeZone() {
        return this.timezone != null ? (TimeZone)this.timezone.clone() : TimeZone.getTimeZone("UTC");
    }

    public abstract Class<? extends T> getValueType();

    public abstract T parse(CharSequence var1, ParsePosition var2) throws ParseException;

    public T parseObject(String string, ParsePosition parsePosition) {
        try {
            return this.parse(string, parsePosition);
        }
        catch (ParseException parseException) {
            if (parsePosition.getErrorIndex() < 0) {
                parsePosition.setErrorIndex(parseException.getErrorOffset());
            }
            return null;
        }
    }

    public T parseObject(String string) throws ParseException {
        ParsePosition parsePosition = new ParsePosition(0);
        T t2 = this.parse(string, parsePosition);
        if (t2 != null) {
            int n;
            int n2 = string.length();
            int n3 = 0;
            int n4 = parsePosition.getIndex();
            do {
                if ((n4 += n3) >= n2) {
                    return t2;
                }
                n = string.codePointAt(n4);
                n3 = Character.charCount(n);
            } while (Character.isSpaceChar(n) || Character.isISOControl(n));
            parsePosition.setErrorIndex(n4);
        }
        throw new LocalizedParseException(this.getLocale(Locale.Category.DISPLAY), this.getValueType(), string, parsePosition);
    }

    public abstract void format(T var1, Appendable var2) throws IOException;

    @Override
    public StringBuffer format(Object object, StringBuffer stringBuffer, FieldPosition fieldPosition) {
        Class<T> clazz = this.getValueType();
        ArgumentChecks.ensureCanCast("object", clazz, object);
        try {
            this.format(clazz.cast(object), stringBuffer);
        }
        catch (IOException iOException) {
            throw new UncheckedIOException(iOException);
        }
        return stringBuffer;
    }

    protected Format getFormat(Class<?> clazz) {
        Format format;
        if (this.formats == null) {
            this.formats = new IdentityHashMap(4);
        }
        if ((format = this.formats.get(clazz)) == null && !this.formats.containsKey(clazz)) {
            format = this.createFormat(clazz);
            if (format == null) {
                Class<?>[] classArray = Classes.getAllInterfaces(clazz);
                Class<?> clazz2 = null;
                int n = 0;
                while (true) {
                    if (n < classArray.length) {
                        clazz2 = classArray[n];
                    } else {
                        if (n == classArray.length) {
                            clazz2 = clazz;
                        }
                        if ((clazz2 = clazz2.getSuperclass()) == null) break;
                    }
                    format = this.formats.get(clazz2);
                    if (format != null) break;
                    format = this.createFormat(clazz2);
                    if (format != null) {
                        this.formats.put(clazz2, format);
                        break;
                    }
                    ++n;
                }
            }
            this.formats.put(clazz, format);
        }
        return format;
    }

    protected Format createFormat(Class<?> clazz) {
        Locale locale = this.getLocale(Locale.Category.FORMAT);
        if (Number.class.isAssignableFrom(clazz)) {
            if (Locale.ROOT.equals(locale)) {
                return DefaultFormat.getInstance(clazz);
            }
            if (clazz == Number.class) {
                return NumberFormat.getInstance(locale);
            }
            if (Numbers.isInteger(clazz)) {
                return NumberFormat.getIntegerInstance(locale);
            }
        } else {
            if (clazz == Date.class) {
                DateFormat dateFormat = !Locale.ROOT.equals(locale) ? DateFormat.getDateTimeInstance(2, 2, locale) : new SimpleDateFormat("yyyy-MM-dd HH:mm:ss", Locale.ROOT);
                dateFormat.setTimeZone(this.getTimeZone());
                return dateFormat;
            }
            if (clazz == Angle.class) {
                return AngleFormat.getInstance(locale);
            }
            if (clazz == Unit.class) {
                return new UnitFormat(locale);
            }
            if (clazz == Quantity.class) {
                return new QuantityFormat(locale);
            }
            if (clazz == Range.class) {
                return new RangeFormat(locale);
            }
            if (clazz == DirectPosition.class) {
                return MetadataServices.getInstance().createCoordinateFormat(locale, this.getTimeZone());
            }
            if (clazz == Class.class) {
                return ClassFormat.INSTANCE;
            }
            Object[] objectArray = clazz.getInterfaces();
            if (ArraysExt.contains(objectArray, IdentifiedObject.class)) {
                return new IdentifiedObjectFormat(locale);
            }
        }
        return null;
    }

    @Override
    public CompoundFormat<T> clone() {
        CompoundFormat compoundFormat = (CompoundFormat)super.clone();
        if (compoundFormat.formats != null) {
            compoundFormat.formats = new IdentityHashMap(compoundFormat.formats);
            for (Map.Entry<Class<?>, Format> entry : compoundFormat.formats.entrySet()) {
                entry.setValue((Format)entry.getValue().clone());
            }
        }
        return compoundFormat;
    }
}

