/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.system;

import java.util.logging.Logger;
import org.apache.sis.internal.system.DaemonThread;
import org.apache.sis.util.Static;
import org.apache.sis.util.logging.Logging;

public final class Threads
extends Static {
    public static final ThreadGroup SIS;
    static final ThreadGroup DAEMONS;
    static DaemonThread lastCreatedDaemon;

    private Threads() {
    }

    static synchronized void shutdown(long l) throws InterruptedException {
        DaemonThread.killAll(lastCreatedDaemon, l);
    }

    static {
        ThreadGroup threadGroup = Thread.currentThread().getThreadGroup();
        try {
            ThreadGroup threadGroup2;
            while ((threadGroup2 = threadGroup.getParent()) != null) {
                threadGroup = threadGroup2;
            }
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        SIS = new ThreadGroup(threadGroup, "Apache SIS");
        DAEMONS = new ThreadGroup(SIS, "Daemons"){

            @Override
            public void uncaughtException(Thread thread, Throwable throwable) {
                Logging.severeException(Logger.getLogger("org.apache.sis.system"), thread.getClass(), "run", throwable);
            }
        };
    }
}

