/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.netcdf;

import org.apache.sis.internal.netcdf.Decoder;
import org.apache.sis.internal.referencing.AxisDirections;
import org.apache.sis.internal.referencing.GeodeticObjectBuilder;
import org.apache.sis.referencing.crs.AbstractCRS;
import org.apache.sis.referencing.cs.AxesConvention;
import org.apache.sis.util.Utilities;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.cs.AxisDirection;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.referencing.cs.EllipsoidalCS;
import org.opengis.util.FactoryException;

final class CRSMerger
extends GeodeticObjectBuilder {
    CRSMerger(Decoder decoder) {
        super(decoder, decoder.listeners.getLocale());
    }

    @Override
    public CoordinateReferenceSystem replaceComponent(CoordinateReferenceSystem coordinateReferenceSystem, int n, CoordinateReferenceSystem coordinateReferenceSystem2) throws FactoryException {
        CoordinateReferenceSystem coordinateReferenceSystem3;
        int n2;
        CoordinateSystem coordinateSystem = coordinateReferenceSystem.getCoordinateSystem();
        if (coordinateSystem instanceof EllipsoidalCS && (n2 = AxisDirections.indexOfColinear(coordinateSystem, AxisDirection.EAST)) >= 0 && coordinateSystem.getAxis(n2).getMinimumValue() >= 0.0) {
            coordinateReferenceSystem2 = AbstractCRS.castOrCopy(coordinateReferenceSystem2).forConvention(AxesConvention.POSITIVE_RANGE);
        }
        return Utilities.equalsIgnoreMetadata(coordinateReferenceSystem, coordinateReferenceSystem3 = super.replaceComponent(coordinateReferenceSystem, n, coordinateReferenceSystem2)) ? coordinateReferenceSystem : coordinateReferenceSystem3;
    }
}

