/*
 * Decompiled with CFR 0.152.
 */
package jj2000.j2k.image.forwcomptransf;

import java.util.StringTokenizer;
import jj2000.j2k.image.CompTransfSpec;
import jj2000.j2k.util.ParameterList;
import jj2000.j2k.wavelet.FilterTypes;
import jj2000.j2k.wavelet.analysis.AnWTFilter;
import jj2000.j2k.wavelet.analysis.AnWTFilterSpec;

public class ForwCompTransfSpec
extends CompTransfSpec
implements FilterTypes {
    public ForwCompTransfSpec(int nt, int nc, byte type, AnWTFilterSpec wfs, ParameterList pl) {
        super(nt, nc, type);
        int t2;
        String param = pl.getParameter("Mct");
        if (param == null) {
            int c;
            AnWTFilter[][] anfilt;
            if (nc < 3) {
                this.setDefault("none");
                return;
            }
            if (pl.getBooleanParameter("lossless")) {
                this.setDefault("rct");
                return;
            }
            int[] filtType = new int[this.nComp];
            for (int c2 = 0; c2 < 3; ++c2) {
                anfilt = (AnWTFilter[][])wfs.getCompDef(c2);
                filtType[c2] = anfilt[0][0].getFilterType();
            }
            boolean reject = false;
            for (c = 1; c < 3; ++c) {
                if (filtType[c] == filtType[0]) continue;
                reject = true;
            }
            if (reject) {
                this.setDefault("none");
            } else {
                anfilt = (AnWTFilter[][])wfs.getCompDef(0);
                if (anfilt[0][0].getFilterType() == 0) {
                    this.setDefault("ict");
                } else {
                    this.setDefault("rct");
                }
            }
            for (int t3 = 0; t3 < nt; ++t3) {
                AnWTFilter[][] anfilt2;
                int[] filtType2 = new int[this.nComp];
                for (c = 0; c < 3; ++c) {
                    anfilt2 = (AnWTFilter[][])wfs.getTileCompVal(t3, c);
                    filtType2[c] = anfilt2[0][0].getFilterType();
                }
                boolean reject2 = false;
                for (int c3 = 1; c3 < this.nComp; ++c3) {
                    if (filtType2[c3] == filtType2[0]) continue;
                    reject2 = true;
                }
                if (reject2) {
                    this.setTileDef(t3, "none");
                    continue;
                }
                anfilt2 = (AnWTFilter[][])wfs.getTileCompVal(t3, 0);
                if (anfilt2[0][0].getFilterType() == 0) {
                    this.setTileDef(t3, "ict");
                    continue;
                }
                this.setTileDef(t3, "rct");
            }
            return;
        }
        StringTokenizer stk = new StringTokenizer(param);
        int curSpecType = 0;
        boolean[] tileSpec = null;
        block17: while (stk.hasMoreTokens()) {
            int i;
            String word = stk.nextToken();
            switch (word.charAt(0)) {
                case 't': {
                    tileSpec = ForwCompTransfSpec.parseIdx(word, this.nTiles);
                    if (curSpecType == 1) {
                        curSpecType = 3;
                        continue block17;
                    }
                    curSpecType = 2;
                    continue block17;
                }
                case 'c': {
                    throw new IllegalArgumentException("Component specific  parameters not allowed with '-Mct' option");
                }
            }
            if (word.equals("off")) {
                if (curSpecType == 0) {
                    this.setDefault("none");
                } else if (curSpecType == 2) {
                    for (i = tileSpec.length - 1; i >= 0; --i) {
                        if (!tileSpec[i]) continue;
                        this.setTileDef(i, "none");
                    }
                }
            } else if (word.equals("on")) {
                if (nc < 3) {
                    throw new IllegalArgumentException("Cannot use component transformation on a image with less than three components");
                }
                if (curSpecType == 0) {
                    this.setDefault("rct");
                } else if (curSpecType == 2) {
                    for (i = tileSpec.length - 1; i >= 0; --i) {
                        if (!tileSpec[i]) continue;
                        if (this.getFilterType(i, wfs) == 1) {
                            this.setTileDef(i, "rct");
                            continue;
                        }
                        this.setTileDef(i, "ict");
                    }
                }
            } else {
                throw new IllegalArgumentException("Default parameter of option Mct not recognized: " + param);
            }
            curSpecType = 0;
            tileSpec = null;
        }
        if (this.getDefault() == null) {
            this.setDefault("none");
            for (t2 = 0; t2 < nt; ++t2) {
                AnWTFilter[][] anfilt;
                if (this.isTileSpecified(t2)) continue;
                int[] filtType = new int[this.nComp];
                for (int c = 0; c < 3; ++c) {
                    anfilt = (AnWTFilter[][])wfs.getTileCompVal(t2, c);
                    filtType[c] = anfilt[0][0].getFilterType();
                }
                boolean reject = false;
                for (int c = 1; c < this.nComp; ++c) {
                    if (filtType[c] == filtType[0]) continue;
                    reject = true;
                }
                if (reject) {
                    this.setTileDef(t2, "none");
                    continue;
                }
                anfilt = (AnWTFilter[][])wfs.getTileCompVal(t2, 0);
                if (anfilt[0][0].getFilterType() == 0) {
                    this.setTileDef(t2, "ict");
                    continue;
                }
                this.setTileDef(t2, "rct");
            }
        }
        block23: for (t2 = nt - 1; t2 >= 0; --t2) {
            int filterType;
            if (((String)this.getTileDef(t2)).equals("none")) continue;
            if (((String)this.getTileDef(t2)).equals("rct")) {
                filterType = this.getFilterType(t2, wfs);
                switch (filterType) {
                    case 1: {
                        break;
                    }
                    case 0: {
                        if (this.isTileSpecified(t2)) {
                            throw new IllegalArgumentException("Cannot use RCT with 9x7 filter in tile " + t2);
                        }
                        this.setTileDef(t2, "ict");
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Default filter is not JPEG 2000 part I compliant");
                    }
                }
                continue;
            }
            filterType = this.getFilterType(t2, wfs);
            switch (filterType) {
                case 1: {
                    if (this.isTileSpecified(t2)) {
                        throw new IllegalArgumentException("Cannot use ICT with filter 5x3 in tile " + t2);
                    }
                    this.setTileDef(t2, "rct");
                    continue block23;
                }
                case 0: {
                    continue block23;
                }
                default: {
                    throw new IllegalArgumentException("Default filter is not JPEG 2000 part I compliant");
                }
            }
        }
    }

    private int getFilterType(int t2, AnWTFilterSpec wfs) {
        int[] filtType = new int[this.nComp];
        for (int c = 0; c < this.nComp; ++c) {
            AnWTFilter[][] anfilt = t2 == -1 ? (AnWTFilter[][])wfs.getCompDef(c) : (AnWTFilter[][])wfs.getTileCompVal(t2, c);
            filtType[c] = anfilt[0][0].getFilterType();
        }
        boolean reject = false;
        for (int c = 1; c < this.nComp; ++c) {
            if (filtType[c] == filtType[0]) continue;
            reject = true;
        }
        if (reject) {
            throw new IllegalArgumentException("Can not use component transformation when components do not use the same filters");
        }
        return filtType[0];
    }
}

