/*
 * Decompiled with CFR 0.152.
 */
package thredds.catalog;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public final class DataFormatType {
    private static List<DataFormatType> members = new ArrayList<DataFormatType>(20);
    public static final DataFormatType NONE = new DataFormatType("");
    public static final DataFormatType BUFR = new DataFormatType("BUFR");
    public static final DataFormatType ESML = new DataFormatType("ESML");
    public static final DataFormatType GEMPAK = new DataFormatType("GEMPAK");
    public static final DataFormatType GINI = new DataFormatType("GINI");
    public static final DataFormatType GRIB1 = new DataFormatType("GRIB-1");
    public static final DataFormatType GRIB2 = new DataFormatType("GRIB-2");
    public static final DataFormatType HDF4 = new DataFormatType("HDF4");
    public static final DataFormatType HDF5 = new DataFormatType("HDF5");
    public static final DataFormatType NETCDF = new DataFormatType("netCDF");
    public static final DataFormatType NETCDF4 = new DataFormatType("netCDF-4");
    public static final DataFormatType NEXRAD2 = new DataFormatType("NEXRAD-2");
    public static final DataFormatType NCML = new DataFormatType("NcML");
    public static final DataFormatType NIDS = new DataFormatType("NEXRAD-3");
    public static final DataFormatType MCIDAS_AREA = new DataFormatType("McIDAS-AREA");
    public static final DataFormatType GIF = new DataFormatType("image/gif");
    public static final DataFormatType JPEG = new DataFormatType("image/jpeg");
    public static final DataFormatType TIFF = new DataFormatType("image/tiff");
    public static final DataFormatType PLAIN = new DataFormatType("text/plain");
    public static final DataFormatType TSV = new DataFormatType("text/tab-separated-values");
    public static final DataFormatType XML = new DataFormatType("text/xml");
    public static final DataFormatType MPEG = new DataFormatType("video/mpeg");
    public static final DataFormatType QUICKTIME = new DataFormatType("video/quicktime");
    public static final DataFormatType REALTIME = new DataFormatType("video/realtime");
    public static final DataFormatType OTHER_UNKNOWN = new DataFormatType("other/unknown");
    private String name;

    private DataFormatType(String s2) {
        this.name = s2;
        members.add(this);
    }

    private DataFormatType(String s2, boolean fake) {
        this.name = s2;
    }

    public static Collection<DataFormatType> getAllTypes() {
        return members;
    }

    public static DataFormatType findType(String name) {
        if (name == null) {
            return null;
        }
        for (DataFormatType m4 : members) {
            if (!m4.name.equalsIgnoreCase(name)) continue;
            return m4;
        }
        return null;
    }

    public static DataFormatType getType(String name) {
        if (name == null) {
            return null;
        }
        DataFormatType t2 = DataFormatType.findType(name);
        return t2 != null ? t2 : new DataFormatType(name, false);
    }

    public String toString() {
        return this.name;
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DataFormatType)) {
            return false;
        }
        return o.hashCode() == this.hashCode();
    }
}

