/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.util.iso;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.IllformedLocaleException;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.SortedMap;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import org.apache.sis.internal.util.CodeLists;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.CharSequences;
import org.apache.sis.util.DefaultInternationalString;
import org.apache.sis.util.Locales;
import org.apache.sis.util.ResourceInternationalString;
import org.apache.sis.util.SimpleInternationalString;
import org.apache.sis.util.Static;
import org.apache.sis.util.collection.BackingStoreException;
import org.apache.sis.util.collection.Containers;
import org.apache.sis.util.logging.Logging;
import org.apache.sis.util.resources.Errors;
import org.apache.sis.util.resources.Messages;
import org.opengis.annotation.UML;
import org.opengis.util.CodeList;
import org.opengis.util.InternationalString;

public final class Types
extends Static {
    private static final char SEPARATOR = '.';
    private static Map<String, Object> typeForNames;

    private Types() {
    }

    public static String getStandardName(Class<?> clazz) {
        String string;
        UML uML;
        if (clazz != null && (uML = clazz.getAnnotation(UML.class)) != null && (string = uML.identifier()) != null && !string.isEmpty()) {
            return string.intern();
        }
        return null;
    }

    public static String getListName(CodeList<?> codeList) {
        if (codeList == null) {
            return null;
        }
        Class<?> clazz = codeList.getClass();
        String string = Types.getStandardName(clazz);
        return string != null ? string : clazz.getSimpleName();
    }

    public static String getCodeName(CodeList<?> codeList) {
        if (codeList == null) {
            return null;
        }
        String string = codeList.identifier();
        return string != null && !string.isEmpty() ? string : codeList.name();
    }

    public static String getCodeLabel(CodeList<?> codeList) {
        if (codeList == null) {
            return null;
        }
        String string = codeList.identifier();
        String string2 = codeList.name();
        if (string == null) {
            string = string2;
        }
        for (String string3 : codeList.names()) {
            if (string3.equals(string2) || string3.length() < string.length()) continue;
            string = string3;
        }
        return CharSequences.camelCaseToSentence(string).toString();
    }

    public static InternationalString getCodeTitle(CodeList<?> codeList) {
        return codeList != null ? new CodeTitle(codeList) : null;
    }

    public static InternationalString getDescription(CodeList<?> codeList) {
        String string;
        if (codeList != null && (string = Types.getResources(codeList.getClass().getName())) != null) {
            return new Description(string, Description.resourceKey(codeList));
        }
        return null;
    }

    public static InternationalString getDescription(Class<?> clazz) {
        String string;
        String string2 = Types.getStandardName(clazz);
        if (string2 != null && (string = Types.getResources(clazz.getName())) != null) {
            return new Description(string, string2);
        }
        return null;
    }

    public static InternationalString getDescription(Class<?> clazz, String string) {
        String string2;
        String string3;
        if (string != null && (string3 = Types.getStandardName(clazz)) != null && (string2 = Types.getResources(clazz.getName())) != null) {
            return new Description(string2, string3 + '.' + string);
        }
        return null;
    }

    static String getResources(String string) {
        String string2 = "org.opengis.metadata.Descriptions";
        if (string.regionMatches(0, string2, 0, 21)) {
            return string2;
        }
        return null;
    }

    public static <T extends CodeList<?>> T[] getCodeValues(Class<T> clazz) {
        return CodeLists.values(clazz);
    }

    public static synchronized Class<?> forStandardName(String string) {
        Object object;
        Class<Types> clazz;
        if (string == null) {
            return null;
        }
        if (typeForNames == null) {
            clazz = Types.class;
            object = clazz.getResourceAsStream("class-index.properties");
            if (object == null) {
                throw new MissingResourceException("class-index.properties", clazz.getName(), string);
            }
            Properties properties = new Properties();
            try {
                properties.load((InputStream)object);
                ((InputStream)object).close();
            }
            catch (IOException | IllegalArgumentException exception) {
                throw new BackingStoreException(exception);
            }
            typeForNames = new HashMap<String, Object>(Containers.hashMapCapacity(2 * properties.size()));
            for (Map.Entry<Object, Object> entry : properties.entrySet()) {
                String string2 = ((String)entry.getKey()).intern();
                String string3 = ((String)entry.getValue()).intern();
                typeForNames.put(string2, string3);
                if (string2.length() <= 3 || string2.charAt(2) != '_' || !Character.isUpperCase(string2.charAt(1))) continue;
                typeForNames.putIfAbsent(string2.substring(3).intern(), string3);
            }
            typeForNames.putIfAbsent("MI_SensorTypeCode", "org.apache.sis.internal.jaxb.metadata.replace.SensorType");
        }
        if ((clazz = typeForNames.get(string)) == null || clazz instanceof Class) {
            return clazz;
        }
        try {
            object = Class.forName((String)((Object)clazz));
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new TypeNotPresentException((String)((Object)clazz), classNotFoundException);
        }
        typeForNames.put(string.intern(), object);
        return object;
    }

    public static <T extends Enum<T>> T forEnumName(Class<T> clazz, String string) {
        return CodeLists.forName(clazz, string);
    }

    public static <T extends CodeList<T>> T forCodeName(Class<T> clazz, String string, boolean bl) {
        return CodeLists.forName(clazz, string, bl);
    }

    public static CodeList<?> forCodeTitle(CharSequence charSequence) {
        return charSequence instanceof CodeTitle ? ((CodeTitle)charSequence).code : null;
    }

    public static InternationalString toInternationalString(Map<String, ?> map, String string) throws IllegalArgumentException {
        Object object;
        ArgumentChecks.ensureNonEmpty("prefix", string);
        if (map == null) {
            return null;
        }
        boolean bl = false;
        if (map instanceof SortedMap && (object = (SortedMap)map).comparator() == null) {
            map = object.tailMap(string);
            bl = true;
        }
        object = null;
        Locale locale = null;
        DefaultInternationalString defaultInternationalString = null;
        int n = string.length();
        for (Map.Entry<String, ?> entry : map.entrySet()) {
            Object obj;
            Locale locale2;
            String string2 = entry.getKey();
            if (string2 == null) continue;
            if (!string2.startsWith(string)) {
                if (!bl) continue;
                break;
            }
            if (string2.length() == n) {
                locale2 = Locale.ROOT;
            } else {
                char c = string2.charAt(n);
                if (c != '_') {
                    if (!bl || c <= '_') continue;
                    break;
                }
                int n2 = n + 1;
                try {
                    locale2 = Locales.parse(string2, n2);
                }
                catch (IllformedLocaleException illformedLocaleException) {
                    throw new IllegalArgumentException(Errors.getResources(map).getString((short)54, '(' + string2.substring(0, n2) + '\uff09' + string2.substring(n2), illformedLocaleException));
                }
            }
            if ((obj = entry.getValue()) == null) continue;
            if (!(obj instanceof CharSequence)) {
                throw new IllegalArgumentException(Errors.getResources(map).getString((short)58, string2, obj.getClass()));
            }
            if (object == null) {
                object = (CharSequence)obj;
                locale = locale2;
                continue;
            }
            if (defaultInternationalString == null) {
                defaultInternationalString = new DefaultInternationalString();
                Types.add(defaultInternationalString, locale, (CharSequence)object);
                object = defaultInternationalString;
            }
            Types.add(defaultInternationalString, locale2, (CharSequence)obj);
        }
        return Types.toInternationalString((CharSequence)object);
    }

    private static void add(DefaultInternationalString defaultInternationalString, Locale locale, CharSequence charSequence) {
        boolean bl = charSequence instanceof InternationalString;
        defaultInternationalString.add(locale, bl ? ((InternationalString)charSequence).toString(locale) : charSequence.toString());
        if (bl && !(charSequence instanceof SimpleInternationalString)) {
            LogRecord logRecord = Messages.getResources(null).getLogRecord(Level.WARNING, (short)25);
            logRecord.setLoggerName("org.apache.sis.metadata");
            Logging.log(Types.class, "toInternationalString", logRecord);
        }
    }

    public static InternationalString toInternationalString(CharSequence charSequence) {
        if (charSequence == null || charSequence instanceof InternationalString) {
            return (InternationalString)charSequence;
        }
        return new SimpleInternationalString(charSequence.toString());
    }

    public static InternationalString[] toInternationalStrings(CharSequence ... charSequenceArray) {
        if (charSequenceArray == null || charSequenceArray instanceof InternationalString[]) {
            return (InternationalString[])charSequenceArray;
        }
        InternationalString[] internationalStringArray = new InternationalString[charSequenceArray.length];
        for (int i = 0; i < charSequenceArray.length; ++i) {
            internationalStringArray[i] = Types.toInternationalString(charSequenceArray[i]);
        }
        return internationalStringArray;
    }

    public static String toString(InternationalString internationalString, Locale locale) {
        return internationalString == null ? null : (locale == null ? internationalString.toString() : internationalString.toString(locale));
    }

    private static final class CodeTitle
    extends Description {
        private static final long serialVersionUID = 3306532357801489365L;
        final CodeList<?> code;

        CodeTitle(CodeList<?> codeList) {
            super("org.opengis.metadata.CodeLists", CodeTitle.resourceKey(codeList));
            this.code = codeList;
        }

        @Override
        String fallback() {
            return Types.getCodeLabel(this.code);
        }
    }

    private static class Description
    extends ResourceInternationalString {
        private static final long serialVersionUID = -6202647167398898834L;
        private static final ClassLoader CLASSLOADER = UML.class.getClassLoader();

        Description(String string, String string2) {
            super(string, string2);
        }

        @Override
        protected final ResourceBundle getBundle(Locale locale) {
            return ResourceBundle.getBundle(this.resources, locale, CLASSLOADER);
        }

        @Override
        public final String toString(Locale locale) {
            try {
                return super.toString(locale);
            }
            catch (MissingResourceException missingResourceException) {
                Logging.ignorableException(Logger.getLogger("org.apache.sis.util.resources"), ResourceInternationalString.class, "toString", missingResourceException);
                return this.fallback();
            }
        }

        String fallback() {
            return CharSequences.camelCaseToSentence(this.key.substring(this.key.lastIndexOf(46) + 1)).toString();
        }

        static String resourceKey(CodeList<?> codeList) {
            String string = Types.getCodeName(codeList);
            if (string.indexOf(46) < 0) {
                string = Types.getListName(codeList) + '.' + string;
            }
            return string;
        }
    }
}

