/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.storage;

import java.util.Locale;
import java.util.Optional;
import org.apache.sis.geometry.Envelopes;
import org.apache.sis.internal.storage.MetadataBuilder;
import org.apache.sis.internal.storage.Resources;
import org.apache.sis.metadata.ModifiableMetadata;
import org.apache.sis.metadata.iso.DefaultMetadata;
import org.apache.sis.referencing.CRS;
import org.apache.sis.referencing.IdentifiedObjects;
import org.apache.sis.storage.DataStoreException;
import org.apache.sis.storage.Resource;
import org.apache.sis.storage.event.StoreEvent;
import org.apache.sis.storage.event.StoreListener;
import org.apache.sis.storage.event.StoreListeners;
import org.apache.sis.util.logging.Logging;
import org.apache.sis.util.resources.Errors;
import org.apache.sis.xml.NilReason;
import org.opengis.geometry.Envelope;
import org.opengis.metadata.Metadata;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.TransformException;
import org.opengis.util.GenericName;

public abstract class AbstractResource
implements Resource {
    protected final StoreListeners listeners;
    private volatile Metadata metadata;

    protected AbstractResource(StoreListeners storeListeners, boolean bl) {
        this.listeners = bl && storeListeners != null ? storeListeners : new StoreListeners(storeListeners, this);
    }

    @Override
    public Optional<GenericName> getIdentifier() throws DataStoreException {
        return Optional.empty();
    }

    public Optional<Envelope> getEnvelope() throws DataStoreException {
        return Optional.empty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final Metadata getMetadata() throws DataStoreException {
        Metadata metadata = this.metadata;
        if (metadata == null) {
            Object object = this.getSynchronizationLock();
            synchronized (object) {
                metadata = this.metadata;
                if (metadata == null) {
                    metadata = this.createMetadata();
                    if (metadata == null) {
                        metadata = NilReason.UNKNOWN.createNilObject(Metadata.class);
                    } else if (metadata instanceof DefaultMetadata) {
                        ((DefaultMetadata)metadata).transitionTo(ModifiableMetadata.State.FINAL);
                    }
                    this.metadata = metadata;
                }
            }
        }
        return metadata;
    }

    protected Metadata createMetadata() throws DataStoreException {
        MetadataBuilder metadataBuilder = new MetadataBuilder();
        metadataBuilder.addDefaultMetadata(this, this.listeners);
        return metadataBuilder.build();
    }

    protected void clearCache() {
        this.metadata = null;
    }

    protected Object getSynchronizationLock() {
        return this;
    }

    @Override
    public <T extends StoreEvent> void addListener(Class<T> clazz, StoreListener<? super T> storeListener) {
        this.listeners.addListener(clazz, storeListener);
    }

    @Override
    public <T extends StoreEvent> void removeListener(Class<T> clazz, StoreListener<? super T> storeListener) {
        this.listeners.removeListener(clazz, storeListener);
    }

    final String createExceptionMessage(String string, Envelope envelope) {
        Locale locale = this.listeners.getLocale();
        String string2 = Errors.getResources(locale).getString((short)12, string);
        if (envelope != null) {
            try {
                Envelope envelope2 = this.getEnvelope().orElse(null);
                if (envelope2 != null) {
                    CoordinateReferenceSystem coordinateReferenceSystem = CRS.suggestCommonTarget(null, envelope2.getCoordinateReferenceSystem(), envelope.getCoordinateReferenceSystem());
                    envelope = Envelopes.transform(envelope, coordinateReferenceSystem);
                    envelope2 = Envelopes.transform(envelope2, coordinateReferenceSystem);
                    int n = envelope.getDimension();
                    StringBuilder stringBuilder = null;
                    for (int i = 0; i < n; ++i) {
                        double d = envelope.getMinimum(i);
                        double d2 = envelope.getMaximum(i);
                        double d3 = envelope2.getMinimum(i);
                        double d4 = envelope2.getMaximum(i);
                        if (!(d2 < d3) && !(d > d4)) continue;
                        String string3 = coordinateReferenceSystem != null ? IdentifiedObjects.getDisplayName(coordinateReferenceSystem.getCoordinateSystem().getAxis(i), locale) : (i < 3 ? String.valueOf((char)(120 + i)) : "#" + (i + 1));
                        if (stringBuilder == null) {
                            stringBuilder = new StringBuilder(string2);
                        }
                        stringBuilder.append(System.lineSeparator()).append(" \u2022 ").append(Resources.forLocale(locale).getString((short)64, string3, d3, d4, d, d2));
                    }
                    if (stringBuilder != null) {
                        string2 = stringBuilder.toString();
                    }
                }
            }
            catch (DataStoreException | TransformException exception) {
                Logging.ignorableException(this.listeners.getLogger(), AbstractResource.class, "createExceptionMessage", exception);
            }
        }
        return string2;
    }
}

