/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.cs;

import java.util.Locale;
import java.util.regex.Pattern;
import org.apache.sis.referencing.IdentifiedObjects;
import org.apache.sis.util.resources.Vocabulary;
import org.opengis.referencing.cs.CoordinateSystemAxis;

final class AxisName {
    private static final AxisName[] KEYWORDS = new AxisName[]{new AxisName(".*\\blatitudes?\\b.*", 112), new AxisName(".*\\blongitudes?\\b.*", 122), new AxisName(".*\\bheights?\\b.*", 98), new AxisName(".*\\btimes?\\b.*", 195)};
    private final Pattern pattern;
    private final short word;

    private AxisName(String string, short s2) {
        this.pattern = Pattern.compile(string, 2);
        this.word = s2;
    }

    static String find(CoordinateSystemAxis coordinateSystemAxis, Locale locale) {
        String string = IdentifiedObjects.getName(coordinateSystemAxis, null);
        if (string != null) {
            for (AxisName axisName : KEYWORDS) {
                if (!axisName.pattern.matcher(string).matches()) continue;
                return Vocabulary.getResources(locale).getString(axisName.word);
            }
        }
        return IdentifiedObjects.getDisplayName(coordinateSystemAxis, locale);
    }
}

