/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.metadata.iso.quality;

import java.util.Collection;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.apache.sis.internal.jaxb.FilterByVersion;
import org.apache.sis.metadata.iso.ISOMetadata;
import org.apache.sis.metadata.iso.quality.DefaultEvaluationReportInformation;
import org.apache.sis.metadata.iso.quality.DefaultScope;
import org.opengis.annotation.Obligation;
import org.opengis.annotation.Specification;
import org.opengis.annotation.UML;
import org.opengis.metadata.lineage.Lineage;
import org.opengis.metadata.maintenance.ScopeCode;
import org.opengis.metadata.quality.DataQuality;
import org.opengis.metadata.quality.Element;
import org.opengis.metadata.quality.Scope;

@XmlType(name="DQ_DataQuality_Type", propOrder={"scope", "reports", "standaloneQualityReport", "lineage"})
@XmlRootElement(name="DQ_DataQuality")
public class DefaultDataQuality
extends ISOMetadata
implements DataQuality {
    private static final long serialVersionUID = 5036527927404894540L;
    private Scope scope;
    private Collection<Element> reports;
    @Deprecated
    private Lineage lineage;
    private DefaultEvaluationReportInformation standaloneQualityReport;

    public DefaultDataQuality() {
    }

    public DefaultDataQuality(ScopeCode scopeCode) {
        if (scopeCode != null) {
            this.scope = new DefaultScope(scopeCode);
        }
    }

    public DefaultDataQuality(Scope scope) {
        this.scope = scope;
    }

    public DefaultDataQuality(DataQuality dataQuality) {
        super(dataQuality);
        if (dataQuality != null) {
            this.scope = dataQuality.getScope();
            this.reports = this.copyCollection(dataQuality.getReports(), Element.class);
            this.lineage = dataQuality.getLineage();
            if (dataQuality instanceof DefaultDataQuality) {
                this.standaloneQualityReport = ((DefaultDataQuality)dataQuality).getStandaloneQualityReport();
            }
        }
    }

    public static DefaultDataQuality castOrCopy(DataQuality dataQuality) {
        if (dataQuality == null || dataQuality instanceof DefaultDataQuality) {
            return (DefaultDataQuality)dataQuality;
        }
        return new DefaultDataQuality(dataQuality);
    }

    @Override
    @XmlElement(name="scope", required=true)
    public Scope getScope() {
        return this.scope;
    }

    public void setScope(Scope scope) {
        this.checkWritePermission(this.scope);
        this.scope = scope;
    }

    @XmlElement(name="report", required=true)
    public Collection<Element> getReports() {
        this.reports = this.nonNullCollection(this.reports, Element.class);
        return this.reports;
    }

    public void setReports(Collection<? extends Element> collection) {
        this.reports = this.writeCollection(collection, this.reports, Element.class);
    }

    @XmlElement(name="standaloneQualityReport")
    @UML(identifier="standaloneQualityReport", obligation=Obligation.OPTIONAL, specification=Specification.UNSPECIFIED)
    public DefaultEvaluationReportInformation getStandaloneQualityReport() {
        return this.standaloneQualityReport;
    }

    public void setStandaloneQualityReport(DefaultEvaluationReportInformation defaultEvaluationReportInformation) {
        this.checkWritePermission(this.standaloneQualityReport);
        this.standaloneQualityReport = defaultEvaluationReportInformation;
    }

    @Override
    @Deprecated
    @XmlElement(name="lineage", namespace="http://www.isotc211.org/2005/gmd")
    public Lineage getLineage() {
        return FilterByVersion.LEGACY_METADATA.accept() ? this.lineage : null;
    }

    @Deprecated
    public void setLineage(Lineage lineage) {
        this.checkWritePermission(this.lineage);
        this.lineage = lineage;
    }
}

