/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.measure;

import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.Map;
import java.util.Objects;
import javax.measure.Dimension;
import javax.measure.IncommensurableException;
import javax.measure.Quantity;
import javax.measure.UnconvertibleException;
import javax.measure.Unit;
import javax.measure.UnitConverter;
import javax.measure.spi.QuantityFactory;
import org.apache.sis.internal.converter.SurjectiveConverter;
import org.apache.sis.math.Fraction;
import org.apache.sis.measure.AbstractConverter;
import org.apache.sis.measure.AbstractUnit;
import org.apache.sis.measure.ConventionalUnit;
import org.apache.sis.measure.IdentityConverter;
import org.apache.sis.measure.Prefixes;
import org.apache.sis.measure.Scalar;
import org.apache.sis.measure.ScalarFactory;
import org.apache.sis.measure.ScalarFallback;
import org.apache.sis.measure.UnitDimension;
import org.apache.sis.measure.UnitRegistry;
import org.apache.sis.measure.Units;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.Characters;
import org.apache.sis.util.ComparisonMode;
import org.apache.sis.util.ObjectConverters;
import org.apache.sis.util.resources.Errors;

final class SystemUnit<Q extends Quantity<Q>>
extends AbstractUnit<Q>
implements QuantityFactory<Q> {
    private static final long serialVersionUID = 4097466138698631914L;
    static final String ONE = "1";
    final Class<Q> quantity;
    final UnitDimension dimension;
    final transient ScalarFactory<Q> factory;
    private transient ConventionalUnit<Q>[] related;

    SystemUnit(Class<Q> clazz, UnitDimension unitDimension, String string, byte by, short s2, ScalarFactory<Q> scalarFactory) {
        super(string, by, s2);
        this.quantity = clazz;
        this.dimension = unitDimension;
        this.factory = scalarFactory;
    }

    private SystemUnit<?> create(UnitDimension unitDimension, char c, Unit<?> unit) {
        SystemUnit<?> systemUnit;
        Object object;
        boolean bl;
        String string = this.getSymbol();
        boolean bl2 = string != null && string.isEmpty() && c == '\u2215';
        boolean bl3 = bl = unitDimension.isDimensionless() || !bl2 && this.dimension.isDimensionless() || unit != null && UnitDimension.isDimensionless(unit.getDimension());
        if (!bl && (object = Units.get(unitDimension)) != null) {
            return object;
        }
        object = null;
        if (c != '\u0000') {
            object = this.inferSymbol(c, unit);
        }
        if (bl && (systemUnit = Units.get(unitDimension)) != null && super.sameSymbol((String)object)) {
            return systemUnit;
        }
        if (unitDimension == this.dimension && this.sameSymbol((String)object)) {
            return this;
        }
        return new SystemUnit<Q>(null, unitDimension, (String)object, 0, 0, null);
    }

    private boolean sameSymbol(String string) {
        return string == null || string.equals(this.getSymbol());
    }

    @Override
    public Dimension getDimension() {
        return this.dimension;
    }

    @Override
    public SystemUnit<Q> getSystemUnit() {
        return this;
    }

    @Override
    public Map<SystemUnit<?>, Integer> getBaseUnits() {
        Map<UnitDimension, Integer> map = this.dimension.getBaseDimensions();
        if (map == null) {
            return null;
        }
        return ObjectConverters.derivedKeys(map, DimToUnit.INSTANCE, Integer.class);
    }

    @Override
    final Map<SystemUnit<?>, Fraction> getBaseSystemUnits() {
        return ObjectConverters.derivedKeys(this.dimension.components, DimToUnit.INSTANCE, Fraction.class);
    }

    @Override
    public <T extends Quantity<T>> Unit<T> asType(Class<T> clazz) throws ClassCastException {
        ArgumentChecks.ensureNonNull("type", clazz);
        if (clazz == this.quantity) {
            SystemUnit<T> systemUnit;
            if (this.getSymbol() == null && (systemUnit = Units.get(clazz)) != null) {
                return systemUnit;
            }
            return this;
        }
        SystemUnit<T> systemUnit = Units.get(clazz);
        if (systemUnit == null) {
            systemUnit = new SystemUnit<T>(clazz, this.dimension, null, 0, 0, null);
        }
        if (!this.dimension.equals(systemUnit.dimension)) {
            throw new ClassCastException(Errors.format((short)64, new Object[]{this, this.quantity != null ? this.quantity.getSimpleName() : "?", this.dimension, clazz.getSimpleName(), systemUnit.dimension}));
        }
        return systemUnit;
    }

    final boolean equalsIgnoreMetadata(Unit<Q> unit) {
        Class<Q> clazz;
        if (this.quantity != null && unit instanceof SystemUnit && (clazz = ((SystemUnit)unit).quantity) != null) {
            return this.quantity == clazz;
        }
        assert (unit == unit.getSystemUnit()) : unit;
        return this.dimension.equals(unit.getDimension());
    }

    @Override
    public UnitConverter getConverterTo(Unit<Q> unit) throws UnconvertibleException {
        ArgumentChecks.ensureNonNull("unit", unit);
        Unit<Q> unit2 = unit.getSystemUnit();
        if (unit2 != this && !this.equalsIgnoreMetadata(unit2)) {
            throw new UnconvertibleException(this.incompatible(unit));
        }
        if (unit2 == unit) {
            return IdentityConverter.INSTANCE;
        }
        return unit.getConverterTo(unit2).inverse();
    }

    @Override
    public UnitConverter getConverterToAny(Unit<?> unit) throws IncommensurableException {
        ArgumentChecks.ensureNonNull("unit", unit);
        Unit<?> unit2 = unit.getSystemUnit();
        if (unit2 != this && !this.isCompatible(unit2)) {
            throw new IncommensurableException(this.incompatible(unit));
        }
        if (unit2 == unit) {
            return IdentityConverter.INSTANCE;
        }
        return unit.getConverterToAny(unit2).inverse();
    }

    @Override
    public Unit<Q> alternate(String string) {
        ArgumentChecks.ensureNonEmpty("symbol", string);
        int n = SystemUnit.invalidCharForSymbol(string, 0, false);
        if (n >= 0) {
            throw new IllegalArgumentException(Errors.format((short)49, "symbol", String.valueOf(Character.toChars(n))));
        }
        if (string.equals(this.getSymbol())) {
            return this;
        }
        SystemUnit<Q> systemUnit = new SystemUnit<Q>(this.quantity, this.dimension, string, 0, 0, this.factory);
        if (this.quantity != null) {
            Object object = UnitRegistry.putIfAbsent(string, systemUnit);
            if (object != null) {
                if (object instanceof SystemUnit) {
                    SystemUnit systemUnit2 = (SystemUnit)object;
                    if (this.quantity.equals(systemUnit2.quantity) && this.dimension.equals(systemUnit2.dimension)) {
                        return systemUnit2;
                    }
                }
                throw new IllegalArgumentException(Errors.format((short)27, string));
            }
            UnitRegistry.putIfAbsent(this.quantity, systemUnit);
        }
        return systemUnit;
    }

    @Override
    public Unit<?> multiply(Unit<?> unit) {
        ArgumentChecks.ensureNonNull("multiplier", unit);
        if (unit == this) {
            return this.pow(2);
        }
        return this.product(unit, false);
    }

    @Override
    public Unit<?> divide(Unit<?> unit) {
        ArgumentChecks.ensureNonNull("divisor", unit);
        return this.product(unit, true);
    }

    private <T extends Quantity<T>> Unit<?> product(Unit<T> unit, boolean bl) {
        UnitDimension unitDimension;
        char c;
        Unit<T> unit2 = unit.getSystemUnit();
        Dimension dimension = unit2.getDimension();
        if (bl) {
            c = '\u2215';
            unitDimension = this.dimension.divide(dimension);
        } else {
            c = '\u22c5';
            unitDimension = this.dimension.multiply(dimension);
        }
        boolean bl2 = unit2 != unit;
        Unit<Object> unit3 = this.create(unitDimension, c, bl2 ? null : unit);
        if (bl2) {
            UnitConverter unitConverter = unit.getConverterTo(unit2);
            if (!unitConverter.isLinear()) {
                throw new IllegalArgumentException(Errors.format((short)104, unit));
            }
            if (!unitConverter.isIdentity()) {
                if (bl) {
                    unitConverter = unitConverter.inverse();
                }
                unit3 = unit3.transform(unitConverter);
                unit3 = this.inferSymbol(unit3, c, unit);
            }
        }
        return unit3;
    }

    @Override
    public Unit<?> pow(int n) {
        switch (n) {
            case 0: {
                return Units.UNITY;
            }
            case 1: {
                return this;
            }
        }
        char c = n >= 0 && n <= 9 ? Characters.toSuperScript((char)(48 + n)) : (char)'\u0000';
        return this.create(this.dimension.pow(n), c, null);
    }

    @Override
    public Unit<?> root(int n) {
        return this.create(this.dimension.root(n), '\u0000', null);
    }

    @Override
    public Unit<Q> transform(UnitConverter unitConverter) {
        ArgumentChecks.ensureNonNull("operation", unitConverter);
        AbstractUnit abstractUnit = this;
        ConventionalUnit conventionalUnit = Prefixes.pseudoSystemUnit(this);
        if (conventionalUnit != null) {
            unitConverter = unitConverter.concatenate(conventionalUnit.toTarget.inverse());
            abstractUnit = conventionalUnit;
        }
        return ConventionalUnit.create(abstractUnit, unitConverter);
    }

    final void related(int n) {
        if (this.related != null) {
            throw new IllegalStateException();
        }
        this.related = new ConventionalUnit[n];
    }

    @Override
    final ConventionalUnit<Q>[] related() {
        return this.related;
    }

    @Override
    public boolean equals(Object object, ComparisonMode comparisonMode) {
        if (object == this) {
            return true;
        }
        if (super.equals(object, comparisonMode)) {
            SystemUnit systemUnit = (SystemUnit)object;
            return Objects.equals(this.quantity, systemUnit.quantity) && this.dimension.equals(systemUnit.dimension);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return super.hashCode() + 37 * this.dimension.hashCode();
    }

    @Override
    public Quantity<Q> create(Number number, Unit<Q> unit) {
        ArgumentChecks.ensureNonNull("value", number);
        ArgumentChecks.ensureNonNull("unit", unit);
        double d = AbstractConverter.doubleValue(number);
        if (this.factory != null) {
            return this.factory.create(d, unit);
        }
        if (this.quantity != null) {
            return ScalarFallback.factory(d, unit, this.quantity);
        }
        return new Scalar<Q>(d, unit);
    }

    private static final class DimToUnit
    extends SurjectiveConverter<UnitDimension, SystemUnit<?>>
    implements Serializable {
        private static final long serialVersionUID = 7545067577687885675L;
        static final DimToUnit INSTANCE = new DimToUnit();

        private DimToUnit() {
        }

        @Override
        public Class<UnitDimension> getSourceClass() {
            return UnitDimension.class;
        }

        @Override
        public Class<SystemUnit<?>> getTargetClass() {
            return SystemUnit.class;
        }

        @Override
        public SystemUnit<?> apply(UnitDimension unitDimension) {
            return Units.get(unitDimension);
        }

        Object readResolve() throws ObjectStreamException {
            return INSTANCE;
        }
    }
}

