/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.referencing.provider;

import javax.xml.bind.annotation.XmlTransient;
import org.apache.sis.internal.referencing.provider.AbstractProvider;
import org.apache.sis.internal.referencing.provider.SouthPoleRotation;
import org.apache.sis.measure.Units;
import org.apache.sis.metadata.iso.citation.Citations;
import org.apache.sis.parameter.ParameterBuilder;
import org.apache.sis.parameter.Parameters;
import org.apache.sis.referencing.operation.transform.PoleRotation;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.cs.EllipsoidalCS;
import org.opengis.referencing.operation.Conversion;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.MathTransformFactory;
import org.opengis.util.FactoryException;

@XmlTransient
public final class NorthPoleRotation
extends AbstractProvider {
    private static final long serialVersionUID = 3485083285768740448L;
    private static final ParameterDescriptor<Double> POLE_LATITUDE;
    private static final ParameterDescriptor<Double> POLE_LONGITUDE;
    private static final ParameterDescriptor<Double> AXIS_ANGLE;
    public static final ParameterDescriptorGroup PARAMETERS;

    public NorthPoleRotation() {
        super(Conversion.class, PARAMETERS, EllipsoidalCS.class, 2, false, EllipsoidalCS.class, 2, false);
    }

    @Override
    public MathTransform createMathTransform(MathTransformFactory mathTransformFactory, ParameterValueGroup parameterValueGroup) throws FactoryException {
        Parameters parameters = Parameters.castOrWrap(parameterValueGroup);
        return PoleRotation.rotateNorthPole(mathTransformFactory, parameters.getValue(POLE_LATITUDE), parameters.getValue(POLE_LONGITUDE), parameters.getValue(AXIS_ANGLE));
    }

    static {
        ParameterBuilder parameterBuilder = ((ParameterBuilder)new ParameterBuilder().setCodeSpace(Citations.NETCDF, "NetCDF")).setRequired(true);
        POLE_LATITUDE = ((ParameterBuilder)((ParameterBuilder)parameterBuilder.addNameAndIdentifier(Citations.SIS, SouthPoleRotation.POLE_LATITUDE)).addName("grid_north_pole_latitude")).createBounded(-90.0, 90.0, Double.NaN, Units.DEGREE);
        POLE_LONGITUDE = ((ParameterBuilder)((ParameterBuilder)parameterBuilder.addNameAndIdentifier(Citations.SIS, SouthPoleRotation.POLE_LONGITUDE)).addName("grid_north_pole_longitude")).createBounded(-180.0, 180.0, Double.NaN, Units.DEGREE);
        AXIS_ANGLE = ((ParameterBuilder)((ParameterBuilder)parameterBuilder.setRequired(false).addNameAndIdentifier(Citations.SIS, SouthPoleRotation.AXIS_ANGLE)).addName("north_pole_grid_longitude")).createBounded(-180.0, 180.0, 0.0, Units.DEGREE);
        PARAMETERS = ((ParameterBuilder)((ParameterBuilder)parameterBuilder.setRequired(true).addName(Citations.SIS, "North pole rotation")).addName("rotated_latitude_longitude")).createGroup(POLE_LATITUDE, POLE_LONGITUDE, AXIS_ANGLE);
    }
}

