/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.coverage;

import org.apache.sis.internal.coverage.CompoundTransform;
import org.apache.sis.referencing.operation.matrix.Matrices;
import org.apache.sis.referencing.operation.matrix.MatrixSIS;
import org.apache.sis.referencing.operation.transform.IterationStrategy;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.MathTransform1D;
import org.opengis.referencing.operation.Matrix;
import org.opengis.referencing.operation.TransformException;

final class CompoundTransformOf1D
extends CompoundTransform {
    private final MathTransform1D[] components;

    CompoundTransformOf1D(MathTransform1D[] mathTransform1DArray) {
        this.components = mathTransform1DArray;
    }

    @Override
    final MathTransform[] components() {
        return this.components;
    }

    @Override
    public int getSourceDimensions() {
        return this.components.length;
    }

    @Override
    public int getTargetDimensions() {
        return this.components.length;
    }

    @Override
    public Matrix transform(double[] dArray, int n, double[] dArray2, int n2, boolean bl) throws TransformException {
        if (dArray == dArray2 && n2 > n) {
            System.arraycopy(dArray, n, dArray2, n2, this.getSourceDimensions());
            dArray = dArray2;
            n = n2;
        }
        if (!bl) {
            for (MathTransform1D mathTransform1D : this.components) {
                dArray2[n2++] = mathTransform1D.transform(dArray[n++]);
            }
            return null;
        }
        int n3 = this.components.length;
        MatrixSIS matrixSIS = Matrices.createZero(n3, n3);
        for (int i = 0; i < n3; ++i) {
            MathTransform1D mathTransform1D = this.components[i];
            double d = dArray[n++];
            dArray2[n2++] = mathTransform1D.transform(d);
            matrixSIS.setElement(i, i, mathTransform1D.derivative(d));
        }
        return matrixSIS;
    }

    @Override
    public void transform(double[] dArray, int n, double[] dArray2, int n2, int n3) throws TransformException {
        int n4 = this.components.length;
        if (IterationStrategy.suggest(n, n4, n2, n4, n3) != IterationStrategy.ASCENDING) {
            System.arraycopy(dArray, n, dArray2, n2, n3 * n4);
            dArray = dArray2;
            n = n2;
        }
        while (--n3 >= 0) {
            for (MathTransform1D mathTransform1D : this.components) {
                dArray2[n2++] = mathTransform1D.transform(dArray[n++]);
            }
        }
    }

    @Override
    public void transform(float[] fArray, int n, float[] fArray2, int n2, int n3) throws TransformException {
        int n4 = this.components.length;
        if (IterationStrategy.suggest(n, n4, n2, n4, n3) != IterationStrategy.ASCENDING) {
            System.arraycopy(fArray, n, fArray2, n2, n3 * n4);
            fArray = fArray2;
            n = n2;
        }
        while (--n3 >= 0) {
            for (MathTransform1D mathTransform1D : this.components) {
                fArray2[n2++] = (float)mathTransform1D.transform(fArray[n++]);
            }
        }
    }

    @Override
    public void transform(double[] dArray, int n, float[] fArray, int n2, int n3) throws TransformException {
        while (--n3 >= 0) {
            for (MathTransform1D mathTransform1D : this.components) {
                fArray[n2++] = (float)mathTransform1D.transform(dArray[n++]);
            }
        }
    }

    @Override
    public void transform(float[] fArray, int n, double[] dArray, int n2, int n3) throws TransformException {
        while (--n3 >= 0) {
            for (MathTransform1D mathTransform1D : this.components) {
                dArray[n2++] = mathTransform1D.transform(fArray[n++]);
            }
        }
    }
}

