/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.image;

import java.awt.Dimension;
import java.nio.DoubleBuffer;
import org.apache.sis.image.Interpolation;

final class LanczosInterpolation
extends Interpolation {
    private final double a;
    private final int span;

    LanczosInterpolation(int n) {
        this.a = n;
        this.span = 2 * n;
    }

    public String toString() {
        return "LANCZOS";
    }

    @Override
    public Dimension getSupportSize() {
        return new Dimension(this.span, this.span);
    }

    @Override
    public void interpolate(DoubleBuffer doubleBuffer, int n, double d, double d2, double[] dArray, int n2) {
        int n3;
        doubleBuffer.mark();
        double[] dArray2 = new double[this.span];
        double d3 = (d - (1.0 - this.a)) * Math.PI;
        double d4 = (d2 - (1.0 - this.a)) * Math.PI;
        double d5 = Math.sin(d3);
        double d6 = Math.sin(d4);
        dArray2[0] = this.kernel(d3, d5);
        double d7 = this.kernel(d4, d6);
        double d8 = dArray2[0] * d7;
        for (n3 = 0; n3 < n; ++n3) {
            dArray[n2 + n3] = d8 * doubleBuffer.get();
        }
        n3 = 1;
        while (n3 < this.span) {
            int n4 = n3++;
            d5 = -d5;
            dArray2[n4] = d8 = this.kernel((d - ((double)n3 - this.a)) * Math.PI, d5);
            d8 *= d7;
            for (int i = 0; i < n; ++i) {
                int n5 = n2 + i;
                dArray[n5] = dArray[n5] + d8 * doubleBuffer.get();
            }
        }
        int n6 = 1;
        while (n6 < this.span) {
            d6 = -d6;
            d7 = this.kernel((d2 - ((double)(++n6) - this.a)) * Math.PI, d6);
            for (int i = 0; i < this.span; ++i) {
                d3 = dArray2[i] * d7;
                for (int j = 0; j < n; ++j) {
                    int n7 = n2 + j;
                    dArray[n7] = dArray[n7] + d3 * doubleBuffer.get();
                }
            }
        }
        doubleBuffer.reset();
    }

    private double kernel(double d, double d2) {
        double d3 = d2 * Math.sin(d / this.a) * this.a / (d * d);
        return d3 <= 1.0 ? d3 : 1.0;
    }
}

