/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.coverage.grid;

import java.io.IOException;
import java.io.Serializable;
import java.io.UncheckedIOException;
import java.math.RoundingMode;
import java.text.Format;
import java.text.NumberFormat;
import java.time.Instant;
import java.util.Locale;
import java.util.Optional;
import java.util.logging.Logger;
import org.apache.sis.coverage.grid.CoordinateOperationFinder;
import org.apache.sis.coverage.grid.GridClippingMode;
import org.apache.sis.coverage.grid.GridDerivation;
import org.apache.sis.coverage.grid.GridExtent;
import org.apache.sis.coverage.grid.GridExtentCRS;
import org.apache.sis.coverage.grid.GridOrientation;
import org.apache.sis.coverage.grid.GridRoundingMode;
import org.apache.sis.coverage.grid.IllegalGridGeometryException;
import org.apache.sis.coverage.grid.IncompleteGridGeometryException;
import org.apache.sis.coverage.grid.PixelTranslation;
import org.apache.sis.coverage.grid.SliceGeometry;
import org.apache.sis.geometry.Envelopes;
import org.apache.sis.geometry.GeneralEnvelope;
import org.apache.sis.geometry.ImmutableEnvelope;
import org.apache.sis.internal.metadata.ReferencingServices;
import org.apache.sis.internal.metadata.Resources;
import org.apache.sis.internal.referencing.AxisDirections;
import org.apache.sis.internal.referencing.DirectPositionView;
import org.apache.sis.internal.referencing.ExtendedPrecisionMatrix;
import org.apache.sis.internal.referencing.TemporalAccessor;
import org.apache.sis.internal.util.DoubleDouble;
import org.apache.sis.internal.util.Numerics;
import org.apache.sis.io.TableAppender;
import org.apache.sis.math.MathFunctions;
import org.apache.sis.measure.AngleFormat;
import org.apache.sis.measure.Latitude;
import org.apache.sis.measure.Longitude;
import org.apache.sis.metadata.ModifiableMetadata;
import org.apache.sis.metadata.iso.extent.DefaultGeographicBoundingBox;
import org.apache.sis.referencing.CRS;
import org.apache.sis.referencing.IdentifiedObjects;
import org.apache.sis.referencing.crs.AbstractCRS;
import org.apache.sis.referencing.operation.matrix.Matrices;
import org.apache.sis.referencing.operation.matrix.MatrixSIS;
import org.apache.sis.referencing.operation.transform.LinearTransform;
import org.apache.sis.referencing.operation.transform.MathTransforms;
import org.apache.sis.referencing.operation.transform.PassThroughTransform;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.ArraysExt;
import org.apache.sis.util.CharSequences;
import org.apache.sis.util.Classes;
import org.apache.sis.util.ComparisonMode;
import org.apache.sis.util.LenientComparable;
import org.apache.sis.util.NullArgumentException;
import org.apache.sis.util.Utilities;
import org.apache.sis.util.collection.BackingStoreException;
import org.apache.sis.util.collection.DefaultTreeTable;
import org.apache.sis.util.collection.TableColumn;
import org.apache.sis.util.collection.TreeTable;
import org.apache.sis.util.logging.Logging;
import org.apache.sis.util.resources.Errors;
import org.apache.sis.util.resources.Vocabulary;
import org.apache.sis.xml.NilObject;
import org.apache.sis.xml.NilReason;
import org.opengis.geometry.Envelope;
import org.opengis.geometry.MismatchedDimensionException;
import org.opengis.metadata.Identifier;
import org.opengis.metadata.extent.GeographicBoundingBox;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.crs.DerivedCRS;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.referencing.cs.CoordinateSystemAxis;
import org.opengis.referencing.datum.PixelInCell;
import org.opengis.referencing.operation.CoordinateOperation;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.Matrix;
import org.opengis.referencing.operation.NoninvertibleTransformException;
import org.opengis.referencing.operation.TransformException;
import org.opengis.util.FactoryException;

public class GridGeometry
implements LenientComparable,
Serializable {
    private static final long serialVersionUID = -954786616001606624L;
    public static final int CRS = 1;
    public static final int ENVELOPE = 2;
    public static final int EXTENT = 4;
    public static final int GRID_TO_CRS = 8;
    public static final int RESOLUTION = 16;
    public static final int GEOGRAPHIC_EXTENT = 32;
    public static final int TEMPORAL_EXTENT = 64;
    protected final GridExtent extent;
    protected final ImmutableEnvelope envelope;
    protected final MathTransform gridToCRS;
    final MathTransform cornerToCRS;
    protected final double[] resolution;
    final long nonLinears;
    private volatile transient GeographicBoundingBox geographicBBox;
    private volatile transient Instant[] timeRange;
    public static final GridGeometry UNDEFINED = new GridGeometry();

    private GridGeometry() {
        this.extent = null;
        this.gridToCRS = null;
        this.cornerToCRS = null;
        this.envelope = null;
        this.resolution = null;
        this.nonLinears = 0L;
    }

    protected GridGeometry(GridGeometry gridGeometry) {
        this.extent = gridGeometry.extent;
        this.gridToCRS = gridGeometry.gridToCRS;
        this.cornerToCRS = gridGeometry.cornerToCRS;
        this.envelope = gridGeometry.envelope;
        this.resolution = gridGeometry.resolution;
        this.nonLinears = gridGeometry.nonLinears;
    }

    public GridGeometry(GridGeometry gridGeometry, GridExtent gridExtent, MathTransform mathTransform) throws TransformException {
        Object object;
        ArgumentChecks.ensureNonNull("other", gridGeometry);
        int n = gridGeometry.getDimension();
        this.extent = gridExtent;
        GridGeometry.ensureDimensionMatches(n, gridExtent);
        if (mathTransform == null || mathTransform.isIdentity()) {
            this.gridToCRS = gridGeometry.gridToCRS;
            this.cornerToCRS = gridGeometry.cornerToCRS;
            this.resolution = gridGeometry.resolution;
            this.nonLinears = gridGeometry.nonLinears;
        } else if (gridGeometry.gridToCRS != null) {
            object = MathTransforms.concatenate(MathTransforms.uniformTranslation(n, 0.5), mathTransform, MathTransforms.uniformTranslation(n, -0.5));
            this.cornerToCRS = MathTransforms.concatenate(mathTransform, gridGeometry.cornerToCRS);
            this.gridToCRS = MathTransforms.concatenate((MathTransform)object, gridGeometry.gridToCRS);
            this.resolution = GridGeometry.resolution(this.gridToCRS, gridExtent, PixelInCell.CELL_CENTER);
            this.nonLinears = GridGeometry.findNonLinearTargets(this.gridToCRS);
        } else {
            this.cornerToCRS = null;
            this.gridToCRS = null;
            this.resolution = GridGeometry.resolution(mathTransform, gridExtent, PixelInCell.CELL_CENTER);
            this.nonLinears = GridGeometry.findNonLinearTargets(mathTransform);
        }
        object = gridGeometry.envelope;
        ImmutableEnvelope immutableEnvelope = this.computeEnvelope(this.gridToCRS, GridGeometry.getCoordinateReferenceSystem((Envelope)object), (Envelope)(mathTransform == null ? null : object));
        if (immutableEnvelope == null || !immutableEnvelope.equals(object)) {
            object = immutableEnvelope;
        }
        this.envelope = object;
        if (object == null && this.gridToCRS == null) {
            ArgumentChecks.ensureNonNull("extent", gridExtent);
        }
    }

    public GridGeometry(GridExtent gridExtent, PixelInCell pixelInCell, MathTransform mathTransform, CoordinateReferenceSystem coordinateReferenceSystem) {
        if (mathTransform != null) {
            GridGeometry.ensureDimensionMatches(mathTransform.getSourceDimensions(), gridExtent);
            ArgumentChecks.ensureDimensionMatches("crs", mathTransform.getTargetDimensions(), coordinateReferenceSystem);
        } else if (coordinateReferenceSystem == null) {
            ArgumentChecks.ensureNonNull("extent", gridExtent);
        }
        try {
            this.extent = gridExtent;
            this.gridToCRS = PixelTranslation.translate(mathTransform, pixelInCell, PixelInCell.CELL_CENTER);
            this.cornerToCRS = PixelTranslation.translate(mathTransform, pixelInCell, PixelInCell.CELL_CORNER);
            this.envelope = this.computeEnvelope(mathTransform, coordinateReferenceSystem, null);
            this.resolution = GridGeometry.resolution(mathTransform, gridExtent, pixelInCell);
            this.nonLinears = GridGeometry.findNonLinearTargets(mathTransform);
        }
        catch (TransformException transformException) {
            throw new IllegalGridGeometryException(transformException, "gridToCRS");
        }
    }

    private ImmutableEnvelope computeEnvelope(MathTransform mathTransform, CoordinateReferenceSystem coordinateReferenceSystem, Envelope envelope) throws TransformException {
        GeneralEnvelope generalEnvelope;
        if (this.extent != null && this.cornerToCRS != null) {
            generalEnvelope = this.extent.toEnvelope(this.cornerToCRS, mathTransform, envelope);
            generalEnvelope.setCoordinateReferenceSystem(coordinateReferenceSystem);
            if (envelope != null) {
                generalEnvelope.intersect(envelope);
            }
        } else if (coordinateReferenceSystem != null) {
            generalEnvelope = new GeneralEnvelope(coordinateReferenceSystem);
            generalEnvelope.setToNaN();
        } else {
            return null;
        }
        return new ImmutableEnvelope(generalEnvelope);
    }

    public GridGeometry(PixelInCell pixelInCell, MathTransform mathTransform, Envelope envelope, GridRoundingMode gridRoundingMode) {
        if (mathTransform == null) {
            ArgumentChecks.ensureNonNull("envelope", envelope);
        } else {
            ArgumentChecks.ensureDimensionMatches("envelope", mathTransform.getTargetDimensions(), envelope);
        }
        ArgumentChecks.ensureNonNull("rounding", (Object)gridRoundingMode);
        this.gridToCRS = PixelTranslation.translate(mathTransform, pixelInCell, PixelInCell.CELL_CENTER);
        this.cornerToCRS = PixelTranslation.translate(mathTransform, pixelInCell, PixelInCell.CELL_CORNER);
        Matrix matrix = MathTransforms.getMatrix(mathTransform);
        int n = 1;
        if (envelope != null && this.cornerToCRS != null) {
            GeneralEnvelope generalEnvelope;
            try {
                generalEnvelope = Envelopes.transform(this.cornerToCRS.inverse(), envelope);
                this.extent = new GridExtent(generalEnvelope, gridRoundingMode, GridClippingMode.STRICT, null, null, null, null);
                generalEnvelope = this.extent.toEnvelope(this.cornerToCRS, mathTransform, envelope);
            }
            catch (TransformException transformException) {
                throw new IllegalGridGeometryException(transformException, "gridToCRS");
            }
            generalEnvelope.setCoordinateReferenceSystem(envelope.getCoordinateReferenceSystem());
            this.envelope = new ImmutableEnvelope(generalEnvelope);
            if (matrix == null) {
                try {
                    matrix = mathTransform.derivative(new DirectPositionView.Double(this.extent.getPointOfInterest(pixelInCell)));
                    n = 0;
                }
                catch (TransformException transformException) {
                    GridGeometry.recoverableException("<init>", transformException);
                }
            }
        } else {
            this.extent = null;
            this.envelope = ImmutableEnvelope.castOrCopy(envelope);
        }
        this.resolution = matrix != null ? GridGeometry.resolution(matrix, n) : null;
        this.nonLinears = GridGeometry.findNonLinearTargets(mathTransform);
    }

    private static void ensureDimensionMatches(int n, GridExtent gridExtent) throws MismatchedDimensionException {
        int n2;
        if (gridExtent != null && (n2 = gridExtent.getDimension()) != n) {
            throw new MismatchedDimensionException(Errors.format((short)81, "extent", n, n2));
        }
    }

    static void recoverableException(String string, TransformException transformException) {
        Logging.recoverableException(Logger.getLogger("org.apache.sis.raster"), GridGeometry.class, string, transformException);
    }

    public GridGeometry(GridExtent gridExtent, Envelope envelope, GridOrientation gridOrientation) {
        LenientComparable lenientComparable;
        this.nonLinears = 0L;
        long l = 0L;
        ImmutableEnvelope immutableEnvelope = null;
        int[] nArray = null;
        if (envelope != null) {
            CoordinateSystem coordinateSystem;
            CoordinateSystem coordinateSystem2;
            AbstractCRS abstractCRS;
            ArgumentChecks.ensureNonNull("orientation", gridOrientation);
            if (gridOrientation.crsVariant != null && (abstractCRS = AbstractCRS.castOrCopy(envelope.getCoordinateReferenceSystem())) != null && (lenientComparable = abstractCRS.forConvention(gridOrientation.crsVariant)) != abstractCRS && (nArray = AxisDirections.indicesOfLenientMapping(coordinateSystem2 = abstractCRS.getCoordinateSystem(), coordinateSystem = ((AbstractCRS)lenientComparable).getCoordinateSystem())) != null) {
                double[] dArray = new double[nArray.length];
                double[] dArray2 = new double[nArray.length];
                for (int i = 0; i < nArray.length; ++i) {
                    int n = nArray[i];
                    dArray[i] = envelope.getMinimum(n);
                    dArray2[i] = envelope.getMaximum(n);
                    if (coordinateSystem2.getAxis(n).getDirection() == coordinateSystem.getAxis(i).getDirection()) continue;
                    l |= Numerics.bitmask(i);
                }
                immutableEnvelope = new ImmutableEnvelope(dArray, dArray2, (CoordinateReferenceSystem)((Object)lenientComparable));
            }
        }
        if (immutableEnvelope == null) {
            immutableEnvelope = ImmutableEnvelope.castOrCopy(envelope);
        }
        boolean bl = true;
        if (immutableEnvelope == null || (bl = immutableEnvelope.isAllNaN()) && immutableEnvelope.getCoordinateReferenceSystem() == null) {
            if (immutableEnvelope != null && bl) {
                throw new NullArgumentException(Errors.format((short)157));
            }
            ArgumentChecks.ensureNonNull("extent", gridExtent);
            this.envelope = null;
        } else {
            this.envelope = immutableEnvelope;
            if (gridExtent != null) {
                if (nArray != null && gridOrientation.canReorderGridAxis) {
                    if (!ArraysExt.isRange(0, nArray)) {
                        gridExtent = gridExtent.reorder(nArray);
                    }
                    nArray = null;
                }
                if (!bl) {
                    lenientComparable = gridExtent.cornerToCRS(immutableEnvelope, gridOrientation.flippedAxes ^ l, nArray);
                    this.cornerToCRS = MathTransforms.linear((Matrix)((Object)lenientComparable));
                    int n = this.cornerToCRS.getSourceDimensions();
                    int n2 = this.cornerToCRS.getTargetDimensions();
                    this.resolution = new double[n2];
                    for (int i = 0; i < n2; ++i) {
                        int n3 = nArray != null ? nArray[i] : i;
                        DoubleDouble doubleDouble = (DoubleDouble)((MatrixSIS)lenientComparable).getNumber(i, n3);
                        DoubleDouble doubleDouble2 = (DoubleDouble)((MatrixSIS)lenientComparable).getNumber(i, n);
                        this.resolution[i] = Math.abs(doubleDouble.doubleValue());
                        doubleDouble.multiply(0.5);
                        doubleDouble2.add(doubleDouble);
                        ((MatrixSIS)lenientComparable).setNumber(i, n, doubleDouble2);
                    }
                    this.gridToCRS = MathTransforms.linear((Matrix)((Object)lenientComparable));
                    this.extent = gridExtent;
                    return;
                }
            }
        }
        this.extent = gridExtent;
        this.gridToCRS = null;
        this.cornerToCRS = null;
        this.resolution = null;
    }

    GridGeometry(GridExtent gridExtent, MathTransform mathTransform, MathTransform mathTransform2, ImmutableEnvelope immutableEnvelope, double[] dArray, long l) {
        this.extent = gridExtent;
        this.gridToCRS = mathTransform;
        this.cornerToCRS = mathTransform2;
        this.envelope = immutableEnvelope;
        this.resolution = dArray;
        this.nonLinears = l;
        if (mathTransform != null) {
            assert (gridExtent == null || mathTransform.getSourceDimensions() == gridExtent.getDimension());
            assert (immutableEnvelope == null || mathTransform.getTargetDimensions() == immutableEnvelope.getDimension());
            assert (dArray == null || mathTransform.getTargetDimensions() == dArray.length);
        }
    }

    private static MathTransform cornerToCenter(MathTransform mathTransform) {
        return PixelTranslation.translate(mathTransform, PixelInCell.CELL_CORNER, PixelInCell.CELL_CENTER);
    }

    public final int getDimension() {
        if (this.extent != null) {
            return this.extent.getDimension();
        }
        if (this.gridToCRS != null) {
            return this.gridToCRS.getSourceDimensions();
        }
        if (this.envelope != null) {
            return this.envelope.getDimension();
        }
        throw this.incomplete(4, (short)73);
    }

    final int getTargetDimension() {
        if (this.envelope != null) {
            return this.envelope.getDimension();
        }
        if (this.gridToCRS != null) {
            return this.gridToCRS.getTargetDimensions();
        }
        return this.extent.getDimension();
    }

    public GridExtent getExtent() {
        if (this.extent != null) {
            return this.extent;
        }
        throw this.incomplete(4, (short)73);
    }

    public MathTransform getGridToCRS(PixelInCell pixelInCell) {
        MathTransform mathTransform = PixelInCell.CELL_CENTER.equals(pixelInCell) ? this.gridToCRS : (PixelInCell.CELL_CORNER.equals(pixelInCell) ? this.cornerToCRS : PixelTranslation.translate(this.gridToCRS, PixelInCell.CELL_CENTER, pixelInCell));
        if (mathTransform != null) {
            return mathTransform;
        }
        throw this.incomplete(8, (short)75);
    }

    public LinearTransform getLinearGridToCRS(PixelInCell pixelInCell) throws TransformException {
        MathTransform mathTransform = this.getGridToCRS(pixelInCell);
        if (mathTransform instanceof LinearTransform) {
            return (LinearTransform)mathTransform;
        }
        return MathTransforms.linear(MathTransforms.getMatrix(mathTransform, new DirectPositionView.Double(this.getExtent().getPointOfInterest(pixelInCell))));
    }

    private static CoordinateReferenceSystem getCoordinateReferenceSystem(Envelope envelope) {
        return envelope != null ? envelope.getCoordinateReferenceSystem() : null;
    }

    public CoordinateReferenceSystem getCoordinateReferenceSystem() {
        CoordinateReferenceSystem coordinateReferenceSystem = GridGeometry.getCoordinateReferenceSystem(this.envelope);
        if (coordinateReferenceSystem != null) {
            return coordinateReferenceSystem;
        }
        throw this.incomplete(1, (short)72);
    }

    public Envelope getEnvelope() {
        if (this.envelope != null && !this.envelope.isAllNaN()) {
            return this.envelope;
        }
        throw this.incomplete(2, this.extent == null ? (short)73 : 75);
    }

    public Envelope getEnvelope(CoordinateReferenceSystem coordinateReferenceSystem) throws TransformException {
        int n;
        int n2;
        ArgumentChecks.ensureNonNull("crs", coordinateReferenceSystem);
        CoordinateReferenceSystem coordinateReferenceSystem2 = GridGeometry.getCoordinateReferenceSystem(this.envelope);
        if (Utilities.equalsIgnoreMetadata(coordinateReferenceSystem2, coordinateReferenceSystem)) {
            return this.envelope;
        }
        if (coordinateReferenceSystem2 == null) {
            n2 = 1;
            n = 72;
        } else if (this.extent == null && this.envelope == null) {
            n2 = 4;
            n = 73;
        } else if (this.cornerToCRS == null && this.envelope == null) {
            n2 = 8;
            n = 75;
        } else {
            try {
                GeneralEnvelope generalEnvelope;
                boolean bl = this.extent == null || this.cornerToCRS == null;
                CoordinateOperation coordinateOperation = org.apache.sis.referencing.CRS.findOperation(coordinateReferenceSystem2, coordinateReferenceSystem, this.geographicBBox());
                try {
                    generalEnvelope = Envelopes.transform(coordinateOperation, (Envelope)this.envelope);
                    if (bl) {
                        return generalEnvelope;
                    }
                }
                catch (TransformException transformException) {
                    if (bl) {
                        throw transformException;
                    }
                    GridGeometry.recoverableException("getEnvelope", transformException);
                    generalEnvelope = null;
                }
                MathTransform mathTransform = MathTransforms.concatenate(this.cornerToCRS, coordinateOperation.getMathTransform());
                GeneralEnvelope generalEnvelope2 = this.extent.toEnvelope(mathTransform, mathTransform, generalEnvelope);
                generalEnvelope2.setCoordinateReferenceSystem(coordinateOperation.getTargetCRS());
                generalEnvelope2.normalize();
                if (generalEnvelope != null) {
                    generalEnvelope2.intersect(generalEnvelope);
                }
                return generalEnvelope2;
            }
            catch (FactoryException factoryException) {
                throw new TransformException(null, factoryException);
            }
        }
        throw this.incomplete(n2, (short)n);
    }

    public Optional<GeographicBoundingBox> getGeographicExtent() {
        return Optional.ofNullable(this.geographicBBox());
    }

    final GeographicBoundingBox geographicBBox() {
        GeographicBoundingBox geographicBoundingBox = this.geographicBBox;
        if (geographicBoundingBox == null && GridGeometry.getCoordinateReferenceSystem(this.envelope) != null && !this.envelope.isAllNaN()) {
            try {
                DefaultGeographicBoundingBox defaultGeographicBoundingBox = ReferencingServices.getInstance().setBounds(this.envelope, null, null);
                defaultGeographicBoundingBox.transitionTo(ModifiableMetadata.State.FINAL);
                geographicBoundingBox = defaultGeographicBoundingBox;
            }
            catch (TransformException transformException) {
                geographicBoundingBox = NilReason.INAPPLICABLE.createNilObject(GeographicBoundingBox.class);
            }
            this.geographicBBox = geographicBoundingBox;
        }
        return geographicBoundingBox instanceof NilObject ? null : geographicBoundingBox;
    }

    public Instant[] getTemporalExtent() {
        Instant[] instantArray = this.timeRange();
        if (instantArray.length != 0) {
            instantArray = (Instant[])instantArray.clone();
        }
        return instantArray;
    }

    private Instant[] timeRange() {
        Instant[] instantArray = this.timeRange;
        if (instantArray == null) {
            TemporalAccessor temporalAccessor = TemporalAccessor.of(GridGeometry.getCoordinateReferenceSystem(this.envelope), 0);
            instantArray = temporalAccessor != null ? temporalAccessor.getTimeBounds(this.envelope) : TemporalAccessor.EMPTY;
            this.timeRange = instantArray;
        }
        return instantArray;
    }

    public double[] getResolution(boolean bl) {
        if (this.resolution != null) {
            double[] dArray = (double[])this.resolution.clone();
            if (!bl) {
                int n;
                for (long i = this.nonLinears; i != 0L; i &= 1L << n ^ 0xFFFFFFFFFFFFFFFFL) {
                    n = Long.numberOfTrailingZeros(i);
                    dArray[n] = Double.NaN;
                }
            }
            return dArray;
        }
        throw this.incomplete(16, this.gridToCRS == null ? (short)75 : 73);
    }

    static double[] resolution(MathTransform mathTransform, GridExtent gridExtent, PixelInCell pixelInCell) {
        Matrix matrix = MathTransforms.getMatrix(mathTransform);
        if (matrix != null) {
            return GridGeometry.resolution(matrix, 1);
        }
        if (gridExtent != null && mathTransform != null) {
            try {
                return GridGeometry.resolution(mathTransform.derivative(new DirectPositionView.Double(gridExtent.getPointOfInterest(pixelInCell))), 0);
            }
            catch (TransformException transformException) {
                GridGeometry.recoverableException("resolution", transformException);
            }
        }
        return null;
    }

    private static double[] resolution(Matrix matrix, int n) {
        double[] dArray = new double[matrix.getNumRow() - n];
        double[] dArray2 = new double[matrix.getNumCol() - n];
        for (int i = 0; i < dArray.length; ++i) {
            for (int j = 0; j < dArray2.length; ++j) {
                dArray2[j] = matrix.getElement(i, j);
            }
            dArray[i] = MathFunctions.magnitude(dArray2);
        }
        return dArray;
    }

    public boolean isConversionLinear(int ... nArray) {
        int n = this.getTargetDimension();
        long l = 0L;
        for (int n2 : nArray) {
            ArgumentChecks.ensureValidIndex(n, n2);
            l |= Numerics.bitmask(n2);
        }
        return (this.nonLinears & l) == 0L;
    }

    private static long findNonLinearTargets(MathTransform mathTransform) {
        long l = 0L;
        for (MathTransform mathTransform2 : MathTransforms.getSteps(mathTransform)) {
            int n;
            int n2;
            long l2;
            Matrix matrix = MathTransforms.getMatrix(mathTransform2);
            if (matrix != null) {
                l2 = l;
                l = 0L;
                while (l2 != 0L) {
                    n2 = Long.numberOfTrailingZeros(l2);
                    n = matrix.getNumRow() - 1;
                    while (--n >= 0) {
                        if (matrix.getElement(n, n2) == 0.0) continue;
                        if (n >= 64) {
                            throw GridGeometry.excessiveDimension(mathTransform);
                        }
                        l |= 1L << n;
                    }
                    l2 &= 1L << n2 ^ 0xFFFFFFFFFFFFFFFFL;
                }
                continue;
            }
            if (mathTransform2 instanceof PassThroughTransform) {
                l2 = 0L;
                n2 = mathTransform2.getTargetDimensions() - mathTransform2.getSourceDimensions();
                n = 64 - Math.max(n2, 0);
                for (int n3 : ((PassThroughTransform)mathTransform2).getModifiedCoordinates()) {
                    if (n3 >= n) {
                        throw GridGeometry.excessiveDimension(mathTransform);
                    }
                    l2 |= 1L << n3;
                }
                if (n2 != 0) {
                    l2 = (Long.highestOneBit(l2) << n2 + 1) - Long.lowestOneBit(l2);
                }
                l |= l2;
                continue;
            }
            int n4 = mathTransform.getTargetDimensions();
            if (n4 > 64) {
                throw GridGeometry.excessiveDimension(mathTransform);
            }
            return Numerics.bitmask(n4) - 1L;
        }
        return l;
    }

    static ArithmeticException excessiveDimension(MathTransform mathTransform) {
        return new ArithmeticException(Errors.format((short)37, mathTransform.getTargetDimensions()));
    }

    private IncompleteGridGeometryException incomplete(int n, short s2) {
        assert (this.getClass() != GridGeometry.class || !this.isDefined(n));
        return new IncompleteGridGeometryException(org.apache.sis.internal.feature.Resources.format(s2));
    }

    final MathTransform requireGridToCRS(boolean bl) throws IncompleteGridGeometryException {
        MathTransform mathTransform;
        if (this.extent == null) {
            throw this.incomplete(4, (short)73);
        }
        MathTransform mathTransform2 = mathTransform = bl ? this.gridToCRS : this.cornerToCRS;
        if (mathTransform == null) {
            throw this.incomplete(8, (short)75);
        }
        return mathTransform;
    }

    public boolean isDefined(int n) {
        if ((n & 0xFFFFFF80) != 0) {
            throw new IllegalArgumentException(Errors.format((short)45, "bitmask", n));
        }
        return !((n & 1) != 0 && null == GridGeometry.getCoordinateReferenceSystem(this.envelope) || (n & 2) != 0 && (null == this.envelope || this.envelope.isAllNaN()) || (n & 4) != 0 && null == this.extent || (n & 8) != 0 && null == this.gridToCRS || (n & 0x10) != 0 && null == this.resolution || (n & 0x20) != 0 && null == this.geographicBBox() || (n & 0x40) != 0 && this.timeRange().length == 0);
    }

    final boolean isExtentOnly() {
        return this.gridToCRS == null && this.envelope == null && this.extent != null;
    }

    final boolean isEnvelopeOnly() {
        return this.gridToCRS == null && this.extent == null && this.envelope != null;
    }

    public GridDerivation derive() {
        return new GridDerivation(this);
    }

    public GridGeometry upsample(int ... nArray) {
        GridExtent gridExtent = this.extent;
        if (gridExtent != null && (gridExtent = gridExtent.upsample(nArray)) == this.extent) {
            return this;
        }
        boolean bl = false;
        MathTransform mathTransform = null;
        double[] dArray = null;
        if (this.cornerToCRS != null) {
            boolean bl2;
            int n = this.cornerToCRS.getTargetDimensions();
            int n2 = this.cornerToCRS.getSourceDimensions();
            MatrixSIS matrixSIS = Matrices.copy(MathTransforms.getMatrix(this.cornerToCRS));
            boolean bl3 = bl2 = matrixSIS == null;
            if (bl2) {
                matrixSIS = Matrices.create(n + 1, n2 + 1, ExtendedPrecisionMatrix.IDENTITY);
            }
            dArray = (double[])this.resolution.clone();
            DoubleDouble doubleDouble = new DoubleDouble();
            int n3 = Math.min(n2, nArray.length);
            while (--n3 >= 0) {
                double d = nArray[n3];
                if (d == 1.0) continue;
                int n4 = n3;
                dArray[n4] = dArray[n4] / d;
                for (int i = 0; i < n; ++i) {
                    doubleDouble.error = 0.0;
                    doubleDouble.value = d;
                    doubleDouble.inverseDivide(DoubleDouble.castOrCopy(matrixSIS.getNumber(i, n3)));
                    matrixSIS.setNumber(i, n3, doubleDouble);
                    bl = true;
                }
            }
            mathTransform = MathTransforms.linear(matrixSIS);
            if (bl2) {
                mathTransform = MathTransforms.concatenate(mathTransform, this.cornerToCRS);
            }
        }
        if (!bl) {
            return this;
        }
        return new GridGeometry(gridExtent, GridGeometry.cornerToCenter(mathTransform), mathTransform, this.envelope, dArray, this.nonLinears);
    }

    public GridGeometry shiftGrid(long ... lArray) {
        ArgumentChecks.ensureNonNull("translation", lArray);
        GridExtent gridExtent = this.extent;
        if (gridExtent != null && (gridExtent = gridExtent.translate(lArray)) == this.extent) {
            return this;
        }
        MathTransform mathTransform = this.gridToCRS;
        MathTransform mathTransform2 = this.cornerToCRS;
        if (mathTransform != null || mathTransform2 != null) {
            boolean bl = true;
            double[] dArray = new double[this.getDimension()];
            int n = Math.min(dArray.length, lArray.length);
            while (--n >= 0) {
                bl &= lArray[n] == 0L;
                dArray[n] = Math.negateExact(lArray[n]);
            }
            if (bl) {
                return this;
            }
            LinearTransform linearTransform = MathTransforms.translation(dArray);
            mathTransform = MathTransforms.concatenate(linearTransform, mathTransform);
            mathTransform2 = MathTransforms.concatenate(linearTransform, mathTransform2);
        }
        return new GridGeometry(gridExtent, mathTransform, mathTransform2, this.envelope, this.resolution, this.nonLinears);
    }

    @Deprecated
    public GridGeometry translate(long ... lArray) {
        return this.shiftGrid(lArray);
    }

    public GridGeometry relocate(GridExtent gridExtent) throws TransformException {
        ImmutableEnvelope immutableEnvelope;
        ArgumentChecks.ensureNonNull("newExtent", gridExtent);
        if (gridExtent.equals(this.extent)) {
            return this;
        }
        GridGeometry.ensureDimensionMatches(this.getDimension(), gridExtent);
        if (this.cornerToCRS != null) {
            GeneralEnvelope generalEnvelope = gridExtent.toEnvelope(this.cornerToCRS, this.gridToCRS, null);
            generalEnvelope.setCoordinateReferenceSystem(GridGeometry.getCoordinateReferenceSystem(this.envelope));
            immutableEnvelope = new ImmutableEnvelope(generalEnvelope);
        } else {
            immutableEnvelope = this.envelope;
        }
        return new GridGeometry(gridExtent, this.gridToCRS, this.cornerToCRS, immutableEnvelope, this.resolution, this.nonLinears);
    }

    public GridGeometry selectDimensions(int ... nArray) {
        if ((nArray = GridExtent.verifyDimensions(nArray, this.getDimension())) != null) {
            try {
                return new SliceGeometry(this, null, nArray, null).reduce(null, -1);
            }
            catch (FactoryException factoryException) {
                throw new BackingStoreException(factoryException);
            }
        }
        return this;
    }

    @Deprecated
    public GridGeometry reduce(int ... nArray) {
        return this.selectDimensions(nArray);
    }

    public DerivedCRS createImageCRS(String string, PixelInCell pixelInCell) {
        ArgumentChecks.ensureNonEmpty("name", string);
        try {
            return GridExtentCRS.forCoverage(string, this, pixelInCell, null);
        }
        catch (FactoryException factoryException) {
            throw new BackingStoreException(factoryException);
        }
        catch (NoninvertibleTransformException noninvertibleTransformException) {
            throw new IllegalStateException(noninvertibleTransformException);
        }
    }

    public MathTransform createTransformTo(GridGeometry gridGeometry, PixelInCell pixelInCell) throws TransformException {
        MathTransform mathTransform;
        ArgumentChecks.ensureNonNull("target", gridGeometry);
        ArgumentChecks.ensureNonNull("anchor", pixelInCell);
        CoordinateOperationFinder coordinateOperationFinder = new CoordinateOperationFinder(gridGeometry, this);
        coordinateOperationFinder.verifyPresenceOfCRS(false);
        coordinateOperationFinder.setAnchor(pixelInCell);
        try {
            mathTransform = coordinateOperationFinder.inverse();
        }
        catch (FactoryException factoryException) {
            throw new TransformException(factoryException.getMessage(), factoryException);
        }
        return MathTransforms.concatenate(this.getGridToCRS(pixelInCell), mathTransform);
    }

    public int hashCode() {
        int n = -1527952352;
        if (this.gridToCRS != null) {
            n += this.gridToCRS.hashCode();
        }
        if (this.extent != null) {
            n += this.extent.hashCode();
        }
        return n;
    }

    @Override
    public boolean equals(Object object) {
        return this.equals(object, ComparisonMode.STRICT);
    }

    @Override
    public boolean equals(Object object, ComparisonMode comparisonMode) {
        if (object == this) {
            return true;
        }
        if (object instanceof GridGeometry) {
            GridGeometry gridGeometry = (GridGeometry)object;
            if ((comparisonMode != ComparisonMode.STRICT || this.getClass().equals(object.getClass())) && Utilities.deepEquals(this.extent, gridGeometry.extent, comparisonMode) && Utilities.deepEquals(this.gridToCRS, gridGeometry.gridToCRS, comparisonMode)) {
                ImmutableEnvelope immutableEnvelope = gridGeometry.envelope;
                if (!comparisonMode.isApproximate()) {
                    return Utilities.deepEquals(this.envelope, immutableEnvelope, comparisonMode);
                }
                if (this.envelope == null == (immutableEnvelope == null) && Utilities.deepEquals(GridGeometry.getCoordinateReferenceSystem(this.envelope), GridGeometry.getCoordinateReferenceSystem(immutableEnvelope), comparisonMode)) {
                    return this.equalsApproximately(immutableEnvelope);
                }
            }
        }
        return false;
    }

    final boolean equalsApproximately(ImmutableEnvelope immutableEnvelope) {
        if (this.envelope != null) {
            int n = this.envelope.getDimension();
            while (--n >= 0) {
                double d;
                double d2 = d = this.resolution != null ? this.resolution[n] * 0.5 : 0.0;
                if (MathFunctions.epsilonEqual(this.envelope.getLower(n), immutableEnvelope.getLower(n), d) && MathFunctions.epsilonEqual(this.envelope.getUpper(n), immutableEnvelope.getUpper(n), d)) continue;
                return false;
            }
        }
        return true;
    }

    final int defaultFlags() {
        int n = 13;
        if (null != this.envelope) {
            n |= 2;
        }
        if (null != this.resolution) {
            n |= 0x10;
        }
        if (null != this.geographicBBox()) {
            n |= 0x20;
        }
        if (this.timeRange().length != 0) {
            n |= 0x40;
        }
        return n;
    }

    public String toString() {
        return this.toTree(Locale.getDefault(), this.defaultFlags()).toString();
    }

    public TreeTable toTree(Locale locale, int n) {
        ArgumentChecks.ensureNonNull("locale", locale);
        DefaultTreeTable defaultTreeTable = new DefaultTreeTable(TableColumn.VALUE_AS_TEXT);
        TreeTable.Node node = defaultTreeTable.getRoot();
        node.setValue(TableColumn.VALUE_AS_TEXT, Classes.getShortClassName(this));
        this.formatTo(locale, Vocabulary.getResources(locale), n, node);
        return defaultTreeTable;
    }

    final void formatTo(Locale locale, Vocabulary vocabulary, int n, TreeTable.Node node) {
        if ((n & 0xFFFFFF80) != 0) {
            throw new IllegalArgumentException(Errors.format((short)45, "bitmask", n));
        }
        try {
            new Formatter(locale, vocabulary, n, node).format();
        }
        catch (IOException iOException) {
            throw new UncheckedIOException(iOException);
        }
    }

    private final class Formatter {
        private final int bitmask;
        private final StringBuilder buffer;
        private final TreeTable.Node root;
        private TreeTable.Node section;
        private final Vocabulary vocabulary;
        private final Locale locale;
        private final CoordinateReferenceSystem crs;
        private final CoordinateSystem cs;

        Formatter(Locale locale, Vocabulary vocabulary, int n, TreeTable.Node node) {
            this.root = node;
            this.bitmask = n;
            this.buffer = new StringBuilder(256);
            this.locale = locale;
            this.vocabulary = vocabulary;
            this.crs = GridGeometry.getCoordinateReferenceSystem(GridGeometry.this.envelope);
            this.cs = this.crs != null ? this.crs.getCoordinateSystem() : null;
        }

        final void format() throws IOException {
            Matrix matrix;
            int n;
            double d;
            Object object;
            Object object2;
            if (this.section(4, (short)97, true, false)) {
                GridGeometry.this.extent.appendTo(this.buffer, this.vocabulary);
                this.writeNodes();
            }
            if (this.section(32, (short)93, false, false) || this.section(64, (short)192, false, false)) {
                object2 = new TableAppender(this.buffer, "  ");
                object = new AngleFormat("DD\u00b0MM\u2032SS\u2033", this.locale);
                GeographicBoundingBox geographicBoundingBox = (this.bitmask & 0x20) != 0 ? GridGeometry.this.geographicBBox() : null;
                double d2 = Double.NaN;
                d = Double.NaN;
                Instant[] instantArray = (this.bitmask & 0x40) != 0 ? GridGeometry.this.timeRange() : TemporalAccessor.EMPTY;
                this.vocabulary.appendLabel((short)123, (Appendable)object2);
                ((TableAppender)object2).setCellAlignment((byte)1);
                if (geographicBoundingBox != null) {
                    ((AngleFormat)object).setRoundingMode(RoundingMode.FLOOR);
                    d2 = geographicBoundingBox.getWestBoundLongitude();
                    ((TableAppender)object2).nextColumn();
                    ((TableAppender)object2).append(((Format)object).format(new Latitude(geographicBoundingBox.getSouthBoundLatitude())));
                    ((TableAppender)object2).nextColumn();
                    ((TableAppender)object2).append(((Format)object).format(new Longitude(d2)));
                }
                if (instantArray.length >= 1) {
                    ((TableAppender)object2).nextColumn();
                    ((TableAppender)object2).append(instantArray[0].toString());
                }
                ((TableAppender)object2).nextLine();
                ((TableAppender)object2).setCellAlignment((byte)-1);
                this.vocabulary.appendLabel((short)211, (Appendable)object2);
                ((TableAppender)object2).setCellAlignment((byte)1);
                if (geographicBoundingBox != null) {
                    ((AngleFormat)object).setRoundingMode(RoundingMode.CEILING);
                    d = geographicBoundingBox.getEastBoundLongitude();
                    ((TableAppender)object2).nextColumn();
                    ((TableAppender)object2).append(((Format)object).format(new Latitude(geographicBoundingBox.getNorthBoundLatitude())));
                    ((TableAppender)object2).nextColumn();
                    ((TableAppender)object2).append(((Format)object).format(new Longitude(d)));
                }
                if (instantArray.length >= 2) {
                    ((TableAppender)object2).nextColumn();
                    ((TableAppender)object2).append(instantArray[1].toString());
                }
                ((TableAppender)object2).flush();
                if (Longitude.isWraparound(d2, d)) {
                    this.vocabulary.appendLabel((short)143, this.buffer);
                    this.buffer.append(' ').append(Resources.forLocale(this.locale).getString((short)3));
                }
                this.writeNodes();
            }
            if (this.section(2, (short)79, true, false)) {
                boolean bl = (this.bitmask & 0x10) != 0 && GridGeometry.this.resolution != null;
                object = new TableAppender(this.buffer, "");
                int n2 = GridGeometry.this.envelope.getDimension();
                NumberFormat numberFormat = NumberFormat.getNumberInstance(this.locale);
                for (n = 0; n < n2; ++n) {
                    d = GridGeometry.this.envelope.getLower(n);
                    double d3 = GridGeometry.this.envelope.getUpper(n);
                    double d4 = GridGeometry.this.resolution != null ? GridGeometry.this.resolution[n] : Double.NaN;
                    numberFormat.setMinimumFractionDigits(Numerics.fractionDigitsForDelta(d4));
                    numberFormat.setMaximumFractionDigits(Numerics.suggestFractionDigits(d, d3));
                    CoordinateSystemAxis coordinateSystemAxis = this.cs != null ? this.cs.getAxis(n) : null;
                    String string = coordinateSystemAxis != null ? coordinateSystemAxis.getName().getCode() : this.vocabulary.getString((short)64, n);
                    ((TableAppender)object).append(string).append(": ").nextColumn();
                    ((TableAppender)object).setCellAlignment((byte)1);
                    ((TableAppender)object).append(numberFormat.format(d)).nextColumn();
                    ((TableAppender)object).setCellAlignment((byte)-1);
                    ((TableAppender)object).append(" \u2026 ").append(numberFormat.format(d3));
                    if (bl) {
                        boolean bl2 = n < 64 && (GridGeometry.this.nonLinears & 1L << n) == 0L;
                        ((TableAppender)object).nextColumn();
                        ((TableAppender)object).append("  \u2206");
                        if (coordinateSystemAxis != null) {
                            ((TableAppender)object).append(coordinateSystemAxis.getAbbreviation());
                        }
                        ((TableAppender)object).nextColumn();
                        ((TableAppender)object).append(' ').append(bl2 ? (char)'=' : '\u2248').append(' ');
                        this.appendResolution((Appendable)object, numberFormat, d4, n);
                    }
                    ((TableAppender)object).nextLine();
                }
                ((TableAppender)object).flush();
                this.writeNodes();
            } else if (this.section(16, (short)172, true, false)) {
                object2 = "";
                object = NumberFormat.getNumberInstance(this.locale);
                for (int i = 0; i < GridGeometry.this.resolution.length; ++i) {
                    this.appendResolution(this.buffer.append((String)object2), (NumberFormat)object, GridGeometry.this.resolution[i], i);
                    object2 = " \u00d7 ";
                }
                this.writeNode();
            }
            if (this.section(1, (short)36, true, false)) {
                Identifier identifier = IdentifiedObjects.getIdentifier(this.crs, null);
                if (identifier != null) {
                    this.buffer.append(IdentifiedObjects.toString(identifier)).append(" \u2014 ");
                }
                this.buffer.append(this.crs.getName().getCode());
                this.writeNode();
            }
            if (this.section(8, (short)34, true, (matrix = MathTransforms.getMatrix(GridGeometry.this.gridToCRS)) != null)) {
                if (matrix != null) {
                    this.writeNode(Matrices.toString(matrix));
                } else {
                    long l;
                    this.buffer.append(GridGeometry.this.gridToCRS.getSourceDimensions()).append("D \u2192 ").append(GridGeometry.this.gridToCRS.getTargetDimensions()).append("D ");
                    String string = org.apache.sis.internal.feature.Resources.forLocale(this.locale).getString((short)51, Long.bitCount(l));
                    for (l = GridGeometry.this.nonLinears; l != 0L; l &= 1L << n ^ 0xFFFFFFFFFFFFFFFFL) {
                        n = Long.numberOfTrailingZeros(l);
                        this.buffer.append(string).append(' ').append(this.cs != null ? this.cs.getAxis(n).getName().getCode() : String.valueOf(n));
                        string = ",";
                    }
                    this.writeNode();
                }
            }
        }

        private boolean section(int n, short s2, boolean bl, boolean bl2) {
            if ((this.bitmask & n) != 0) {
                String string = this.vocabulary.getString(s2);
                if (bl2) {
                    string = this.buffer.append((CharSequence)string).append(" (").append(this.vocabulary.getString((short)155).toLowerCase(this.locale)).append(')').toString();
                    this.buffer.setLength(0);
                }
                this.section = this.root.newChild();
                this.section.setValue(TableColumn.VALUE_AS_TEXT, string);
                if (GridGeometry.this.isDefined(n)) {
                    return true;
                }
                if (bl) {
                    this.writeNode(this.vocabulary.getString((short)209));
                }
            }
            return false;
        }

        private void writeNode(CharSequence charSequence) {
            String string = charSequence.toString().trim();
            if (!string.isEmpty()) {
                this.section.newChild().setValue(TableColumn.VALUE_AS_TEXT, string);
            }
        }

        private void writeNode() {
            this.writeNode(this.buffer);
            this.buffer.setLength(0);
        }

        private void writeNodes() {
            for (CharSequence charSequence : CharSequences.splitOnEOL(this.buffer)) {
                this.writeNode(charSequence);
            }
            this.buffer.setLength(0);
        }

        private void appendResolution(Appendable appendable, NumberFormat numberFormat, double d, int n) throws IOException {
            if (Double.isNaN(d)) {
                appendable.append('?');
            } else {
                numberFormat.setMaximumFractionDigits(Numerics.suggestFractionDigits(d) / 2);
                appendable.append(numberFormat.format(d));
            }
            if (this.cs != null) {
                String string = String.valueOf(this.cs.getAxis(n).getUnit());
                if (string.isEmpty() || Character.isLetterOrDigit(string.codePointAt(0))) {
                    appendable.append(' ');
                }
                appendable.append(string);
            }
        }
    }
}

