/*
 * Decompiled with CFR 0.152.
 */
package jj2000.j2k.image.output;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import jj2000.j2k.image.BlkImgDataSrc;
import jj2000.j2k.image.DataBlkInt;
import jj2000.j2k.image.output.ImgWriter;

public class ImgWriterPPM
extends ImgWriter {
    private int[] levShift = new int[3];
    private RandomAccessFile out;
    private int[] cps = new int[3];
    private int[] fb = new int[3];
    private DataBlkInt db = new DataBlkInt();
    private int offset;
    private byte[] buf;

    public ImgWriterPPM(File out, BlkImgDataSrc imgSrc, int n1, int n2, int n3) throws IOException {
        if (n1 < 0 || n1 >= imgSrc.getNumComps() || n2 < 0 || n2 >= imgSrc.getNumComps() || n3 < 0 || n3 >= imgSrc.getNumComps() || imgSrc.getNomRangeBits(n1) > 8 || imgSrc.getNomRangeBits(n2) > 8 || imgSrc.getNomRangeBits(n3) > 8) {
            throw new IllegalArgumentException("Invalid component indexes");
        }
        this.w = imgSrc.getCompImgWidth(n1);
        this.h = imgSrc.getCompImgHeight(n1);
        if (this.w != imgSrc.getCompImgWidth(n2) || this.w != imgSrc.getCompImgWidth(n3) || this.h != imgSrc.getCompImgHeight(n2) || this.h != imgSrc.getCompImgHeight(n3)) {
            throw new IllegalArgumentException("All components must have the same dimensions and no subsampling");
        }
        this.w = imgSrc.getImgWidth();
        this.h = imgSrc.getImgHeight();
        if (out.exists() && !out.delete()) {
            throw new IOException("Could not reset file");
        }
        this.out = new RandomAccessFile(out, "rw");
        this.src = imgSrc;
        this.cps[0] = n1;
        this.cps[1] = n2;
        this.cps[2] = n3;
        this.fb[0] = imgSrc.getFixedPoint(n1);
        this.fb[1] = imgSrc.getFixedPoint(n2);
        this.fb[2] = imgSrc.getFixedPoint(n3);
        this.levShift[0] = 1 << imgSrc.getNomRangeBits(n1) - 1;
        this.levShift[1] = 1 << imgSrc.getNomRangeBits(n2) - 1;
        this.levShift[2] = 1 << imgSrc.getNomRangeBits(n3) - 1;
        this.writeHeaderInfo();
    }

    public ImgWriterPPM(String fname, BlkImgDataSrc imgSrc, int n1, int n2, int n3) throws IOException {
        this(new File(fname), imgSrc, n1, n2, n3);
    }

    @Override
    public void close() throws IOException {
        if (this.out.length() != (long)(3 * this.w * this.h + this.offset)) {
            this.out.seek(this.out.length());
            for (int i = 3 * this.w * this.h + this.offset - (int)this.out.length(); i > 0; --i) {
                this.out.writeByte(0);
            }
        }
        this.out.close();
        this.src = null;
        this.out = null;
        this.db = null;
    }

    @Override
    public void flush() throws IOException {
        this.buf = null;
    }

    @Override
    public void write(int ulx, int uly, int w, int h2) throws IOException {
        int tOffx = this.src.getCompULX(this.cps[0]) - (int)Math.ceil((double)this.src.getImgULX() / (double)this.src.getCompSubsX(this.cps[0]));
        int tOffy = this.src.getCompULY(this.cps[0]) - (int)Math.ceil((double)this.src.getImgULY() / (double)this.src.getCompSubsY(this.cps[0]));
        if (this.db.data != null && this.db.data.length < w) {
            this.db.data = null;
        }
        if (this.buf == null || this.buf.length < 3 * w) {
            this.buf = new byte[3 * w];
        }
        for (int i = 0; i < h2; ++i) {
            for (int c = 0; c < 3; ++c) {
                int tmp;
                int j;
                int k;
                int maxVal = (1 << this.src.getNomRangeBits(this.cps[c])) - 1;
                int shift = this.levShift[c];
                this.db.ulx = ulx;
                this.db.uly = uly + i;
                this.db.w = w;
                this.db.h = 1;
                do {
                    this.db = (DataBlkInt)this.src.getInternCompData(this.db, this.cps[c]);
                } while (this.db.progressive);
                int fracbits = this.fb[c];
                if (fracbits == 0) {
                    k = this.db.offset + w - 1;
                    j = 3 * w - 1 + c - 2;
                    while (j >= 0) {
                        tmp = this.db.data[k] + shift;
                        this.buf[j] = (byte)(tmp < 0 ? 0 : (tmp > maxVal ? maxVal : tmp));
                        j -= 3;
                        --k;
                    }
                    continue;
                }
                k = this.db.offset + w - 1;
                j = 3 * w - 1 + c - 2;
                while (j >= 0) {
                    tmp = (this.db.data[k] >>> fracbits) + shift;
                    this.buf[j] = (byte)(tmp < 0 ? 0 : (tmp > maxVal ? maxVal : tmp));
                    j -= 3;
                    --k;
                }
            }
            this.out.seek(this.offset + 3 * (this.w * (uly + tOffy + i) + ulx + tOffx));
            this.out.write(this.buf, 0, 3 * w);
        }
    }

    @Override
    public void write() throws IOException {
        int tIdx = this.src.getTileIdx();
        int tw = this.src.getTileCompWidth(tIdx, 0);
        int th = this.src.getTileCompHeight(tIdx, 0);
        for (int i = 0; i < th; i += 64) {
            this.write(0, i, tw, th - i < 64 ? th - i : 64);
        }
    }

    private void writeHeaderInfo() throws IOException {
        int i;
        this.out.seek(0L);
        this.out.write(80);
        this.out.write(54);
        this.out.write(10);
        this.offset = 3;
        String val = String.valueOf(this.w);
        byte[] byteVals = val.getBytes();
        for (i = 0; i < byteVals.length; ++i) {
            this.out.write(byteVals[i]);
            ++this.offset;
        }
        this.out.write(32);
        ++this.offset;
        val = String.valueOf(this.h);
        byteVals = val.getBytes();
        for (i = 0; i < byteVals.length; ++i) {
            this.out.write(byteVals[i]);
            ++this.offset;
        }
        this.out.write(10);
        this.out.write(50);
        this.out.write(53);
        this.out.write(53);
        this.out.write(10);
        this.offset += 5;
    }

    public String toString() {
        return "ImgWriterPPM: WxH = " + this.w + "x" + this.h + ", Components = " + this.cps[0] + "," + this.cps[1] + "," + this.cps[2] + "\nUnderlying RandomAccessFile:\n" + this.out.toString();
    }
}

