/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.scientific.integration;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import org.apache.tika.exception.TikaException;
import org.apache.tika.mime.MediaType;
import org.apache.tika.parser.DefaultParser;
import org.apache.tika.parser.Parser;
import org.apache.tika.parser.external.CompositeExternalParser;
import org.apache.tika.parser.ocr.TesseractOCRParser;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestParsers {
    @Test
    public void testDiffsFrom241() throws Exception {
        Map<String, String> currentDefault = this.getDefault();
        String path241 = "/2.4.1-no-tesseract.txt";
        if (new TesseractOCRParser().hasTesseract()) {
            path241 = "/2.4.1-tesseract.txt";
        }
        int checked = 0;
        CompositeExternalParser externalParser = new CompositeExternalParser();
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(this.getClass().getResourceAsStream(path241), StandardCharsets.UTF_8));){
            String line = reader.readLine();
            while (line != null) {
                String[] data = line.split("\t");
                String mediaType = data[0];
                String parserClass = data[1];
                Parser external = (Parser)externalParser.getParsers().get(MediaType.parse((String)mediaType));
                if (external != null) {
                    parserClass = externalParser.getClass().toString();
                }
                Assertions.assertEquals((Object)parserClass, (Object)currentDefault.get(mediaType), (String)("for mediaType '" + mediaType + "'"));
                ++checked;
                line = reader.readLine();
            }
        }
        Assertions.assertTrue((checked > 340 ? 1 : 0) != 0);
    }

    private Map<String, String> getDefault() throws IOException, TikaException {
        DefaultParser p = new DefaultParser();
        HashMap<String, String> ret = new HashMap<String, String>();
        for (Map.Entry e : p.getParsers().entrySet()) {
            ret.put(((MediaType)e.getKey()).toString(), ((Parser)e.getValue()).getClass().toString());
        }
        return ret;
    }
}

