/*
 * Decompiled with CFR 0.152.
 */
package ucar.coord;

import java.util.ArrayList;
import java.util.Formatter;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.coord.Counter;
import ucar.nc2.util.Misc;

public class SparseArray<T> {
    private static final Logger logger = LoggerFactory.getLogger(SparseArray.class);
    private int[] size;
    private int[] stride;
    private int totalSize;
    private int[] track;
    private List<T> content;
    private int ndups = 0;

    public SparseArray(int ... size) {
        this.size = size;
        this.calcStrides();
        this.track = new int[this.totalSize];
        this.content = new ArrayList<T>(this.totalSize);
    }

    public SparseArray(int[] size, int[] track, List<T> content) {
        this.size = size;
        this.calcStrides();
        this.track = track;
        this.content = content;
        if (track.length != this.totalSize) {
            throw new IllegalStateException("track len " + track.length + " != totalSize " + this.totalSize);
        }
    }

    private void calcStrides() {
        this.totalSize = 1;
        for (int aSize : this.size) {
            this.totalSize *= aSize;
        }
        this.stride = new int[this.size.length];
        int product = 1;
        for (int ii = this.size.length - 1; ii >= 0; --ii) {
            int thisDim = this.size[ii];
            this.stride[ii] = product;
            product *= thisDim;
        }
    }

    public void add(T thing, Formatter info, int ... index) {
        this.content.add(thing);
        int where = this.calcIndex(index);
        if (where < 0 || where >= this.track.length) {
            logger.error("BAD index add=" + Misc.showInts(index), new Throwable());
        }
        if (this.track[where] > 0) {
            ++this.ndups;
            if (info != null) {
                info.format(" duplicate %s%n     with %s%n%n", thing, this.content.get(this.track[where] - 1));
            }
        }
        this.track[where] = this.content.size();
    }

    public int calcIndex(int ... index) {
        assert (index.length == this.size.length);
        int result = 0;
        for (int ii = 0; ii < index.length; ++ii) {
            result += index[ii] * this.stride[ii];
        }
        return result;
    }

    public T getContent(int idx) {
        int contentIdx;
        if (idx > this.track.length || idx < 0) {
            logger.error("BAD index get=" + idx + " max= " + this.track.length, new Throwable());
        }
        if ((contentIdx = this.track[idx] - 1) < 0) {
            return null;
        }
        return this.content.get(contentIdx);
    }

    public T getContent(int[] index) {
        int where = this.calcIndex(index);
        return this.getContent(where);
    }

    public int[] getShape() {
        return this.size;
    }

    public int getRank() {
        return this.size.length;
    }

    public int getTotalSize() {
        return this.totalSize;
    }

    public void setSize(int[] size) {
        this.size = size;
    }

    public int[] getTrack() {
        return this.track;
    }

    public int getTrack(int idx) {
        return this.track[idx];
    }

    public void setTrack(int[] track) {
        this.track = track;
    }

    public List<T> getContent() {
        return this.content;
    }

    public void setContent(List<T> content) {
        this.content = content;
    }

    public int getNduplicates() {
        return this.ndups;
    }

    public int countNotMissing() {
        int result = 0;
        for (int idx : this.track) {
            if (idx <= 0) continue;
            ++result;
        }
        return result;
    }

    public int countMissing() {
        int result = 0;
        for (int idx : this.track) {
            if (idx != 0) continue;
            ++result;
        }
        return result;
    }

    public float getDensity() {
        return (float)this.countNotMissing() / (float)this.totalSize;
    }

    public void showInfo(Formatter info, Counter all) {
        info.format("ndups=%d total=%d/%d density= %f%n", this.ndups, this.countNotMissing(), this.totalSize, Float.valueOf(this.getDensity()));
        if (all != null) {
            all.dups += this.ndups;
            all.recordsUnique += this.countNotMissing();
            all.recordsTotal += this.totalSize;
            ++all.vars;
        }
        info.format("sizes=", new Object[0]);
        ArrayList<Integer> sizes = new ArrayList<Integer>();
        for (int s2 : this.size) {
            info.format("%d,", s2);
            if (s2 == 1) continue;
            sizes.add(s2);
        }
        info.format("%n%n", new Object[0]);
        this.showRecurse(0, sizes, info);
    }

    int showRecurse(int offset, List<Integer> sizes, Formatter f) {
        if (sizes.size() == 0) {
            return 0;
        }
        if (sizes.size() == 1) {
            int len = sizes.get(0);
            for (int i = 0; i < len; ++i) {
                boolean hasRecord;
                boolean bl = hasRecord = this.track[offset + i] > 0;
                if (hasRecord) {
                    f.format("X", new Object[0]);
                    continue;
                }
                f.format("-", new Object[0]);
            }
            f.format("%n", new Object[0]);
            return len;
        }
        int total = 0;
        int len = sizes.get(0);
        for (int i = 0; i < len; ++i) {
            int count = this.showRecurse(offset, sizes.subList(1, sizes.size()), f);
            offset += count;
            total += count;
        }
        f.format("%n", new Object[0]);
        return total;
    }

    public void showContent(Formatter f) {
        int count = 0;
        f.format("Content%n", new Object[0]);
        for (T record : this.content) {
            f.format(" %d %s %n", count++, record);
        }
    }
}

